﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/sf/sf_Types.h>
#include <nn/svc/svc_Handle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace dmnt { namespace detail { // NOLINT(whitespace/braces)

class IInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BreakDebugProcess, (::nn::svc::Handle debug))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateDebugProcess, (::nn::svc::Handle debug))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseHandle, (::nn::svc::Handle debug))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadImage, (::nn::sf::Out<::std::uint32_t> pOutHandle, const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Args))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessId, (::nn::sf::Out<::nn::Bit64> outPid, ::nn::svc::Handle process))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessHandle, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WaitSynchronization, (::nn::svc::Handle handle, ::nn::Bit64 ns))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugEvent, (const ::nn::sf::OutBuffer& pEvent, ::nn::svc::Handle process))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessModuleInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutBuffer& pOutModules, ::std::int32_t num, ::nn::os::ProcessId pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessList, (::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outProcessIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetThreadList, (::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outThreads, ::nn::svc::Handle domain))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugThreadContext, (const ::nn::sf::OutBuffer& outContext, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::nn::Bit32 controlFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ContinueDebugEvent, (::nn::svc::Handle debug, ::nn::Bit32 flags, const ::nn::sf::InBuffer& threadIds, ::nn::Bit32 size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadDebugProcessMemory, (const ::nn::sf::OutBuffer& buf, ::nn::svc::Handle debug, ::std::int64_t addr, ::std::int64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteDebugProcessMemory, (::nn::svc::Handle debug, const ::nn::sf::InBuffer& buf, ::std::int64_t addr, ::std::int64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDebugThreadContext, (::nn::svc::Handle debug, ::nn::Bit64 threadId, const ::nn::sf::InBuffer& context, ::nn::Bit32 controlFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugThreadParam, (::nn::sf::Out<::nn::Bit64> pOut1, ::nn::sf::Out<::nn::Bit32> pOut2, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::std::uint32_t select))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeThreadInfo, (const ::nn::sf::OutBuffer& threadInfo, ::nn::svc::Handle debug, const ::nn::sf::InBuffer& createProcess, const ::nn::sf::InBuffer& createThread))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetHardwareBreakPoint, (::std::uint32_t regNo, ::nn::Bit64 control, ::nn::Bit64 value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryDebugProcessMemory, (const ::nn::sf::OutBuffer& blockInfo, const ::nn::sf::OutBuffer& pageInfo, ::nn::svc::Handle debug, ::std::int64_t addr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessMemoryDetails, (::nn::sf::Out<::std::int32_t> pNumMemoryBlocks, const ::nn::sf::OutBuffer& outData, ::nn::svc::Handle debug))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachByProgramId, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachOnLaunch, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugMonitorProcessId, (::nn::sf::Out<::nn::Bit64> outPid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetJitDebugProcessList, (::nn::sf::Out<::std::int32_t> pNumProcesses, const ::nn::sf::OutBuffer& outData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateCoreDump, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAllDebugThreadInfo, (::nn::svc::Handle debug, const ::nn::sf::OutBuffer& outData, const ::nn::sf::InBuffer& threadInfo, ::nn::Bit32 arraySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileOpen, (const ::nn::sf::InBuffer& FileName, ::std::uint32_t OpenMode, ::std::int32_t CreationDisposition, const ::nn::sf::OutBuffer& pHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileClose, (const ::nn::sf::InBuffer& Handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileRead, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesRead, ::std::int64_t Offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileWrite, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::InBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesWritten, ::std::int64_t Offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetAttributes, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& pAttribs))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileGetInformation, (const ::nn::sf::InBuffer& FileName, ::nn::sf::Out<::std::int32_t> pIsDirectory, const ::nn::sf::OutBuffer& pData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetTime, (const ::nn::sf::InBuffer& FileName, ::std::uint64_t CreateTime, ::std::uint64_t AccessTime, ::std::uint64_t ModifyTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetSize, (const ::nn::sf::InBuffer& FileName, ::std::int64_t Size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileDelete, (const ::nn::sf::InBuffer& FileName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileMove, (const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryCreate, (const ::nn::sf::InBuffer& FileName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryDelete, (const ::nn::sf::InBuffer& FileName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryRename, (const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetCount, (const ::nn::sf::InBuffer& DirectoryName, ::nn::sf::Out<::std::int32_t> pNumberOfEntries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryOpen, (const ::nn::sf::InBuffer& DirectoryName, const ::nn::sf::OutBuffer& pHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetNext, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pEntry))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryClose, (const ::nn::sf::InBuffer& Handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_GetFreeSpace, (const ::nn::sf::OutBuffer& pFreeSpace))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_GetVolumeInformation, (const ::nn::sf::OutBuffer& pVolumeName, const ::nn::sf::OutBuffer& pFileSystemName, ::nn::sf::Out<::std::int32_t> pVolumeSerialNumber, ::nn::sf::Out<::std::int32_t> pMaximumComponentLength, ::nn::sf::Out<::std::int32_t> pFileSystemFlags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitiateCoreDump, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle, ::nn::sf::Out<::std::uint64_t> pDumpHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ContinueCoreDump, (::std::uint64_t DumpHandle, ::nn::sf::Out<::std::int32_t> pProgress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddTTYToCoreDump, (const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddImageToCoreDump, (const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseCoreDump, (::std::uint64_t DumpHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IInterface)

        ::nn::Result BreakDebugProcess(::nn::svc::Handle debug) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BreakDebugProcess, (debug));
        }

        ::nn::Result TerminateDebugProcess(::nn::svc::Handle debug) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateDebugProcess, (debug));
        }

        ::nn::Result CloseHandle(::nn::svc::Handle debug) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseHandle, (debug));
        }

        ::nn::Result LoadImage(::nn::sf::Out<::std::uint32_t> pOutHandle, const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Args) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadImage, (pOutHandle, FileName, Args));
        }

        ::nn::Result GetProcessId(::nn::sf::Out<::nn::Bit64> outPid, ::nn::svc::Handle process) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProcessId, (outPid, process));
        }

        ::nn::Result GetProcessHandle(::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProcessHandle, (pOutHandle, pid));
        }

        ::nn::Result WaitSynchronization(::nn::svc::Handle handle, ::nn::Bit64 ns) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WaitSynchronization, (handle, ns));
        }

        ::nn::Result GetDebugEvent(const ::nn::sf::OutBuffer& pEvent, ::nn::svc::Handle process) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDebugEvent, (pEvent, process));
        }

        ::nn::Result GetProcessModuleInfo(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutBuffer& pOutModules, ::std::int32_t num, ::nn::os::ProcessId pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProcessModuleInfo, (pOutCount, pOutModules, num, pid));
        }

        ::nn::Result GetProcessList(::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outProcessIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProcessList, (pNumThreads, outProcessIds));
        }

        ::nn::Result GetThreadList(::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outThreads, ::nn::svc::Handle domain) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetThreadList, (pNumThreads, outThreads, domain));
        }

        ::nn::Result GetDebugThreadContext(const ::nn::sf::OutBuffer& outContext, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::nn::Bit32 controlFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDebugThreadContext, (outContext, debug, threadId, controlFlags));
        }

        ::nn::Result ContinueDebugEvent(::nn::svc::Handle debug, ::nn::Bit32 flags, const ::nn::sf::InBuffer& threadIds, ::nn::Bit32 size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ContinueDebugEvent, (debug, flags, threadIds, size));
        }

        ::nn::Result ReadDebugProcessMemory(const ::nn::sf::OutBuffer& buf, ::nn::svc::Handle debug, ::std::int64_t addr, ::std::int64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadDebugProcessMemory, (buf, debug, addr, size));
        }

        ::nn::Result WriteDebugProcessMemory(::nn::svc::Handle debug, const ::nn::sf::InBuffer& buf, ::std::int64_t addr, ::std::int64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteDebugProcessMemory, (debug, buf, addr, size));
        }

        ::nn::Result SetDebugThreadContext(::nn::svc::Handle debug, ::nn::Bit64 threadId, const ::nn::sf::InBuffer& context, ::nn::Bit32 controlFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDebugThreadContext, (debug, threadId, context, controlFlags));
        }

        ::nn::Result GetDebugThreadParam(::nn::sf::Out<::nn::Bit64> pOut1, ::nn::sf::Out<::nn::Bit32> pOut2, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::std::uint32_t select) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDebugThreadParam, (pOut1, pOut2, debug, threadId, select));
        }

        ::nn::Result InitializeThreadInfo(const ::nn::sf::OutBuffer& threadInfo, ::nn::svc::Handle debug, const ::nn::sf::InBuffer& createProcess, const ::nn::sf::InBuffer& createThread) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeThreadInfo, (threadInfo, debug, createProcess, createThread));
        }

        ::nn::Result SetHardwareBreakPoint(::std::uint32_t regNo, ::nn::Bit64 control, ::nn::Bit64 value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetHardwareBreakPoint, (regNo, control, value));
        }

        ::nn::Result QueryDebugProcessMemory(const ::nn::sf::OutBuffer& blockInfo, const ::nn::sf::OutBuffer& pageInfo, ::nn::svc::Handle debug, ::std::int64_t addr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryDebugProcessMemory, (blockInfo, pageInfo, debug, addr));
        }

        ::nn::Result GetProcessMemoryDetails(::nn::sf::Out<::std::int32_t> pNumMemoryBlocks, const ::nn::sf::OutBuffer& outData, ::nn::svc::Handle debug) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProcessMemoryDetails, (pNumMemoryBlocks, outData, debug));
        }

        ::nn::Result AttachByProgramId(::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachByProgramId, (pOutHandle, pPID, processId));
        }

        ::nn::Result AttachOnLaunch(::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachOnLaunch, (pOutHandle, pPID, processId));
        }

        ::nn::Result GetDebugMonitorProcessId(::nn::sf::Out<::nn::Bit64> outPid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDebugMonitorProcessId, (outPid));
        }

        ::nn::Result GetJitDebugProcessList(::nn::sf::Out<::std::int32_t> pNumProcesses, const ::nn::sf::OutBuffer& outData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetJitDebugProcessList, (pNumProcesses, outData));
        }

        ::nn::Result CreateCoreDump(const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateCoreDump, (FileName, Details, Modules, Threads, Handle));
        }

        ::nn::Result GetAllDebugThreadInfo(::nn::svc::Handle debug, const ::nn::sf::OutBuffer& outData, const ::nn::sf::InBuffer& threadInfo, ::nn::Bit32 arraySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAllDebugThreadInfo, (debug, outData, threadInfo, arraySize));
        }

        ::nn::Result TargetIO_FileOpen(const ::nn::sf::InBuffer& FileName, ::std::uint32_t OpenMode, ::std::int32_t CreationDisposition, const ::nn::sf::OutBuffer& pHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileOpen, (FileName, OpenMode, CreationDisposition, pHandle));
        }

        ::nn::Result TargetIO_FileClose(const ::nn::sf::InBuffer& Handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileClose, (Handle));
        }

        ::nn::Result TargetIO_FileRead(const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesRead, ::std::int64_t Offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileRead, (Handle, pBuffer, pNumberOfBytesRead, Offset));
        }

        ::nn::Result TargetIO_FileWrite(const ::nn::sf::InBuffer& Handle, const ::nn::sf::InBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesWritten, ::std::int64_t Offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileWrite, (Handle, pBuffer, pNumberOfBytesWritten, Offset));
        }

        ::nn::Result TargetIO_FileSetAttributes(const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& pAttribs) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileSetAttributes, (FileName, pAttribs));
        }

        ::nn::Result TargetIO_FileGetInformation(const ::nn::sf::InBuffer& FileName, ::nn::sf::Out<::std::int32_t> pIsDirectory, const ::nn::sf::OutBuffer& pData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileGetInformation, (FileName, pIsDirectory, pData));
        }

        ::nn::Result TargetIO_FileSetTime(const ::nn::sf::InBuffer& FileName, ::std::uint64_t CreateTime, ::std::uint64_t AccessTime, ::std::uint64_t ModifyTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileSetTime, (FileName, CreateTime, AccessTime, ModifyTime));
        }

        ::nn::Result TargetIO_FileSetSize(const ::nn::sf::InBuffer& FileName, ::std::int64_t Size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileSetSize, (FileName, Size));
        }

        ::nn::Result TargetIO_FileDelete(const ::nn::sf::InBuffer& FileName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileDelete, (FileName));
        }

        ::nn::Result TargetIO_FileMove(const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_FileMove, (FromName, ToName));
        }

        ::nn::Result TargetIO_DirectoryCreate(const ::nn::sf::InBuffer& FileName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryCreate, (FileName));
        }

        ::nn::Result TargetIO_DirectoryDelete(const ::nn::sf::InBuffer& FileName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryDelete, (FileName));
        }

        ::nn::Result TargetIO_DirectoryRename(const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryRename, (FromName, ToName));
        }

        ::nn::Result TargetIO_DirectoryGetCount(const ::nn::sf::InBuffer& DirectoryName, ::nn::sf::Out<::std::int32_t> pNumberOfEntries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetCount, (DirectoryName, pNumberOfEntries));
        }

        ::nn::Result TargetIO_DirectoryOpen(const ::nn::sf::InBuffer& DirectoryName, const ::nn::sf::OutBuffer& pHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryOpen, (DirectoryName, pHandle));
        }

        ::nn::Result TargetIO_DirectoryGetNext(const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pEntry) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetNext, (Handle, pEntry));
        }

        ::nn::Result TargetIO_DirectoryClose(const ::nn::sf::InBuffer& Handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_DirectoryClose, (Handle));
        }

        ::nn::Result TargetIO_GetFreeSpace(const ::nn::sf::OutBuffer& pFreeSpace) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_GetFreeSpace, (pFreeSpace));
        }

        ::nn::Result TargetIO_GetVolumeInformation(const ::nn::sf::OutBuffer& pVolumeName, const ::nn::sf::OutBuffer& pFileSystemName, ::nn::sf::Out<::std::int32_t> pVolumeSerialNumber, ::nn::sf::Out<::std::int32_t> pMaximumComponentLength, ::nn::sf::Out<::std::int32_t> pFileSystemFlags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TargetIO_GetVolumeInformation, (pVolumeName, pFileSystemName, pVolumeSerialNumber, pMaximumComponentLength, pFileSystemFlags));
        }

        ::nn::Result InitiateCoreDump(const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle, ::nn::sf::Out<::std::uint64_t> pDumpHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitiateCoreDump, (FileName, Details, Modules, Threads, Handle, pDumpHandle));
        }

        ::nn::Result ContinueCoreDump(::std::uint64_t DumpHandle, ::nn::sf::Out<::std::int32_t> pProgress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ContinueCoreDump, (DumpHandle, pProgress));
        }

        ::nn::Result AddTTYToCoreDump(const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddTTYToCoreDump, (Data, DumpHandle));
        }

        ::nn::Result AddImageToCoreDump(const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddImageToCoreDump, (Data, DumpHandle));
        }

        ::nn::Result CloseCoreDump(::std::uint64_t DumpHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseCoreDump, (DumpHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IInterface
    {
    public:
        nn::Result BreakDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT;
        nn::Result TerminateDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT;
        nn::Result CloseHandle(nn::svc::Handle debug) NN_NOEXCEPT;
        nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutHandle, const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Args) NN_NOEXCEPT;
        nn::Result GetProcessId(nn::sf::Out<nn::Bit64> outPid, nn::svc::Handle process) NN_NOEXCEPT;
        nn::Result GetProcessHandle(nn::sf::Out<std::uint32_t> pOutHandle, nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result WaitSynchronization(nn::svc::Handle handle, nn::Bit64 ns) NN_NOEXCEPT;
        nn::Result GetDebugEvent(const nn::sf::OutBuffer& pEvent, nn::svc::Handle process) NN_NOEXCEPT;
        nn::Result GetProcessModuleInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutBuffer& pOutModules, std::int32_t num, nn::os::ProcessId pid) NN_NOEXCEPT;
        nn::Result GetProcessList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outProcessIds) NN_NOEXCEPT;
        nn::Result GetThreadList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outThreads, nn::svc::Handle domain) NN_NOEXCEPT;
        nn::Result GetDebugThreadContext(const nn::sf::OutBuffer& outContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags) NN_NOEXCEPT;
        nn::Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::sf::InBuffer& threadIds, nn::Bit32 size) NN_NOEXCEPT;
        nn::Result ReadDebugProcessMemory(const nn::sf::OutBuffer& buf, nn::svc::Handle debug, std::int64_t addr, std::int64_t size) NN_NOEXCEPT;
        nn::Result WriteDebugProcessMemory(nn::svc::Handle debug, const nn::sf::InBuffer& buf, std::int64_t addr, std::int64_t size) NN_NOEXCEPT;
        nn::Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::sf::InBuffer& context, nn::Bit32 controlFlags) NN_NOEXCEPT;
        nn::Result GetDebugThreadParam(nn::sf::Out<nn::Bit64> pOut1, nn::sf::Out<nn::Bit32> pOut2, nn::svc::Handle debug, nn::Bit64 threadId, std::uint32_t select) NN_NOEXCEPT;
        nn::Result InitializeThreadInfo(const nn::sf::OutBuffer& threadInfo, nn::svc::Handle debug, const nn::sf::InBuffer& createProcess, const nn::sf::InBuffer& createThread) NN_NOEXCEPT;
        nn::Result SetHardwareBreakPoint(std::uint32_t regNo, nn::Bit64 control, nn::Bit64 value) NN_NOEXCEPT;
        nn::Result QueryDebugProcessMemory(const nn::sf::OutBuffer& blockInfo, const nn::sf::OutBuffer& pageInfo, nn::svc::Handle debug, std::int64_t addr) NN_NOEXCEPT;
        nn::Result GetProcessMemoryDetails(nn::sf::Out<std::int32_t> pNumMemoryBlocks, const nn::sf::OutBuffer& outData, nn::svc::Handle debug) NN_NOEXCEPT;
        nn::Result AttachByProgramId(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result AttachOnLaunch(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetDebugMonitorProcessId(nn::sf::Out<nn::Bit64> outPid) NN_NOEXCEPT;
        nn::Result GetJitDebugProcessList(nn::sf::Out<std::int32_t> pNumProcesses, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
        nn::Result CreateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle) NN_NOEXCEPT;
        nn::Result GetAllDebugThreadInfo(nn::svc::Handle debug, const nn::sf::OutBuffer& outData, const nn::sf::InBuffer& threadInfo, nn::Bit32 arraySize) NN_NOEXCEPT;
        nn::Result TargetIO_FileOpen(const nn::sf::InBuffer& FileName, std::uint32_t OpenMode, std::int32_t CreationDisposition, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT;
        nn::Result TargetIO_FileClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT;
        nn::Result TargetIO_FileRead(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesRead, std::int64_t Offset) NN_NOEXCEPT;
        nn::Result TargetIO_FileWrite(const nn::sf::InBuffer& Handle, const nn::sf::InBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesWritten, std::int64_t Offset) NN_NOEXCEPT;
        nn::Result TargetIO_FileSetAttributes(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& pAttribs) NN_NOEXCEPT;
        nn::Result TargetIO_FileGetInformation(const nn::sf::InBuffer& FileName, nn::sf::Out<std::int32_t> pIsDirectory, const nn::sf::OutBuffer& pData) NN_NOEXCEPT;
        nn::Result TargetIO_FileSetTime(const nn::sf::InBuffer& FileName, std::uint64_t CreateTime, std::uint64_t AccessTime, std::uint64_t ModifyTime) NN_NOEXCEPT;
        nn::Result TargetIO_FileSetSize(const nn::sf::InBuffer& FileName, std::int64_t Size) NN_NOEXCEPT;
        nn::Result TargetIO_FileDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT;
        nn::Result TargetIO_FileMove(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryCreate(const nn::sf::InBuffer& FileName) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryRename(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryGetCount(const nn::sf::InBuffer& DirectoryName, nn::sf::Out<std::int32_t> pNumberOfEntries) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryOpen(const nn::sf::InBuffer& DirectoryName, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryGetNext(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pEntry) NN_NOEXCEPT;
        nn::Result TargetIO_DirectoryClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT;
        nn::Result TargetIO_GetFreeSpace(const nn::sf::OutBuffer& pFreeSpace) NN_NOEXCEPT;
        nn::Result TargetIO_GetVolumeInformation(const nn::sf::OutBuffer& pVolumeName, const nn::sf::OutBuffer& pFileSystemName, nn::sf::Out<std::int32_t> pVolumeSerialNumber, nn::sf::Out<std::int32_t> pMaximumComponentLength, nn::sf::Out<std::int32_t> pFileSystemFlags) NN_NOEXCEPT;
        nn::Result InitiateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle, nn::sf::Out<std::uint64_t> pDumpHandle) NN_NOEXCEPT;
        nn::Result ContinueCoreDump(std::uint64_t DumpHandle, nn::sf::Out<std::int32_t> pProgress) NN_NOEXCEPT;
        nn::Result AddTTYToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT;
        nn::Result AddImageToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT;
        nn::Result CloseCoreDump(std::uint64_t DumpHandle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result BreakDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT;
    nn::Result TerminateDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT;
    nn::Result CloseHandle(nn::svc::Handle debug) NN_NOEXCEPT;
    nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutHandle, const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Args) NN_NOEXCEPT;
    nn::Result GetProcessId(nn::sf::Out<nn::Bit64> outPid, nn::svc::Handle process) NN_NOEXCEPT;
    nn::Result GetProcessHandle(nn::sf::Out<std::uint32_t> pOutHandle, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result WaitSynchronization(nn::svc::Handle handle, nn::Bit64 ns) NN_NOEXCEPT;
    nn::Result GetDebugEvent(const nn::sf::OutBuffer& pEvent, nn::svc::Handle process) NN_NOEXCEPT;
    nn::Result GetProcessModuleInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutBuffer& pOutModules, std::int32_t num, nn::os::ProcessId pid) NN_NOEXCEPT;
    nn::Result GetProcessList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outProcessIds) NN_NOEXCEPT;
    nn::Result GetThreadList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outThreads, nn::svc::Handle domain) NN_NOEXCEPT;
    nn::Result GetDebugThreadContext(const nn::sf::OutBuffer& outContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags) NN_NOEXCEPT;
    nn::Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::sf::InBuffer& threadIds, nn::Bit32 size) NN_NOEXCEPT;
    nn::Result ReadDebugProcessMemory(const nn::sf::OutBuffer& buf, nn::svc::Handle debug, std::int64_t addr, std::int64_t size) NN_NOEXCEPT;
    nn::Result WriteDebugProcessMemory(nn::svc::Handle debug, const nn::sf::InBuffer& buf, std::int64_t addr, std::int64_t size) NN_NOEXCEPT;
    nn::Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::sf::InBuffer& context, nn::Bit32 controlFlags) NN_NOEXCEPT;
    nn::Result GetDebugThreadParam(nn::sf::Out<nn::Bit64> pOut1, nn::sf::Out<nn::Bit32> pOut2, nn::svc::Handle debug, nn::Bit64 threadId, std::uint32_t select) NN_NOEXCEPT;
    nn::Result InitializeThreadInfo(const nn::sf::OutBuffer& threadInfo, nn::svc::Handle debug, const nn::sf::InBuffer& createProcess, const nn::sf::InBuffer& createThread) NN_NOEXCEPT;
    nn::Result SetHardwareBreakPoint(std::uint32_t regNo, nn::Bit64 control, nn::Bit64 value) NN_NOEXCEPT;
    nn::Result QueryDebugProcessMemory(const nn::sf::OutBuffer& blockInfo, const nn::sf::OutBuffer& pageInfo, nn::svc::Handle debug, std::int64_t addr) NN_NOEXCEPT;
    nn::Result GetProcessMemoryDetails(nn::sf::Out<std::int32_t> pNumMemoryBlocks, const nn::sf::OutBuffer& outData, nn::svc::Handle debug) NN_NOEXCEPT;
    nn::Result AttachByProgramId(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result AttachOnLaunch(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetDebugMonitorProcessId(nn::sf::Out<nn::Bit64> outPid) NN_NOEXCEPT;
    nn::Result GetJitDebugProcessList(nn::sf::Out<std::int32_t> pNumProcesses, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
    nn::Result CreateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle) NN_NOEXCEPT;
    nn::Result GetAllDebugThreadInfo(nn::svc::Handle debug, const nn::sf::OutBuffer& outData, const nn::sf::InBuffer& threadInfo, nn::Bit32 arraySize) NN_NOEXCEPT;
    nn::Result TargetIO_FileOpen(const nn::sf::InBuffer& FileName, std::uint32_t OpenMode, std::int32_t CreationDisposition, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT;
    nn::Result TargetIO_FileClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT;
    nn::Result TargetIO_FileRead(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesRead, std::int64_t Offset) NN_NOEXCEPT;
    nn::Result TargetIO_FileWrite(const nn::sf::InBuffer& Handle, const nn::sf::InBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesWritten, std::int64_t Offset) NN_NOEXCEPT;
    nn::Result TargetIO_FileSetAttributes(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& pAttribs) NN_NOEXCEPT;
    nn::Result TargetIO_FileGetInformation(const nn::sf::InBuffer& FileName, nn::sf::Out<std::int32_t> pIsDirectory, const nn::sf::OutBuffer& pData) NN_NOEXCEPT;
    nn::Result TargetIO_FileSetTime(const nn::sf::InBuffer& FileName, std::uint64_t CreateTime, std::uint64_t AccessTime, std::uint64_t ModifyTime) NN_NOEXCEPT;
    nn::Result TargetIO_FileSetSize(const nn::sf::InBuffer& FileName, std::int64_t Size) NN_NOEXCEPT;
    nn::Result TargetIO_FileDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT;
    nn::Result TargetIO_FileMove(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryCreate(const nn::sf::InBuffer& FileName) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryRename(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryGetCount(const nn::sf::InBuffer& DirectoryName, nn::sf::Out<std::int32_t> pNumberOfEntries) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryOpen(const nn::sf::InBuffer& DirectoryName, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryGetNext(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pEntry) NN_NOEXCEPT;
    nn::Result TargetIO_DirectoryClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT;
    nn::Result TargetIO_GetFreeSpace(const nn::sf::OutBuffer& pFreeSpace) NN_NOEXCEPT;
    nn::Result TargetIO_GetVolumeInformation(const nn::sf::OutBuffer& pVolumeName, const nn::sf::OutBuffer& pFileSystemName, nn::sf::Out<std::int32_t> pVolumeSerialNumber, nn::sf::Out<std::int32_t> pMaximumComponentLength, nn::sf::Out<std::int32_t> pFileSystemFlags) NN_NOEXCEPT;
    nn::Result InitiateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle, nn::sf::Out<std::uint64_t> pDumpHandle) NN_NOEXCEPT;
    nn::Result ContinueCoreDump(std::uint64_t DumpHandle, nn::sf::Out<std::int32_t> pProgress) NN_NOEXCEPT;
    nn::Result AddTTYToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT;
    nn::Result AddImageToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT;
    nn::Result CloseCoreDump(std::uint64_t DumpHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::dmnt::detail::IInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BreakDebugProcess, (::nn::svc::Handle debug))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BreakDebugProcess, (debug));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateDebugProcess, (::nn::svc::Handle debug))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateDebugProcess, (debug));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseHandle, (::nn::svc::Handle debug))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseHandle, (debug));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadImage, (::nn::sf::Out<::std::uint32_t> pOutHandle, const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Args))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadImage, (pOutHandle, FileName, Args));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessId, (::nn::sf::Out<::nn::Bit64> outPid, ::nn::svc::Handle process))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProcessId, (outPid, process));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessHandle, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProcessHandle, (pOutHandle, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WaitSynchronization, (::nn::svc::Handle handle, ::nn::Bit64 ns))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WaitSynchronization, (handle, ns));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugEvent, (const ::nn::sf::OutBuffer& pEvent, ::nn::svc::Handle process))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDebugEvent, (pEvent, process));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessModuleInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutBuffer& pOutModules, ::std::int32_t num, ::nn::os::ProcessId pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProcessModuleInfo, (pOutCount, pOutModules, num, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessList, (::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outProcessIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProcessList, (pNumThreads, outProcessIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetThreadList, (::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outThreads, ::nn::svc::Handle domain))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetThreadList, (pNumThreads, outThreads, domain));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugThreadContext, (const ::nn::sf::OutBuffer& outContext, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::nn::Bit32 controlFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDebugThreadContext, (outContext, debug, threadId, controlFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContinueDebugEvent, (::nn::svc::Handle debug, ::nn::Bit32 flags, const ::nn::sf::InBuffer& threadIds, ::nn::Bit32 size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ContinueDebugEvent, (debug, flags, threadIds, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadDebugProcessMemory, (const ::nn::sf::OutBuffer& buf, ::nn::svc::Handle debug, ::std::int64_t addr, ::std::int64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadDebugProcessMemory, (buf, debug, addr, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteDebugProcessMemory, (::nn::svc::Handle debug, const ::nn::sf::InBuffer& buf, ::std::int64_t addr, ::std::int64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteDebugProcessMemory, (debug, buf, addr, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebugThreadContext, (::nn::svc::Handle debug, ::nn::Bit64 threadId, const ::nn::sf::InBuffer& context, ::nn::Bit32 controlFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDebugThreadContext, (debug, threadId, context, controlFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugThreadParam, (::nn::sf::Out<::nn::Bit64> pOut1, ::nn::sf::Out<::nn::Bit32> pOut2, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::std::uint32_t select))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDebugThreadParam, (pOut1, pOut2, debug, threadId, select));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeThreadInfo, (const ::nn::sf::OutBuffer& threadInfo, ::nn::svc::Handle debug, const ::nn::sf::InBuffer& createProcess, const ::nn::sf::InBuffer& createThread))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeThreadInfo, (threadInfo, debug, createProcess, createThread));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHardwareBreakPoint, (::std::uint32_t regNo, ::nn::Bit64 control, ::nn::Bit64 value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetHardwareBreakPoint, (regNo, control, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryDebugProcessMemory, (const ::nn::sf::OutBuffer& blockInfo, const ::nn::sf::OutBuffer& pageInfo, ::nn::svc::Handle debug, ::std::int64_t addr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryDebugProcessMemory, (blockInfo, pageInfo, debug, addr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessMemoryDetails, (::nn::sf::Out<::std::int32_t> pNumMemoryBlocks, const ::nn::sf::OutBuffer& outData, ::nn::svc::Handle debug))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProcessMemoryDetails, (pNumMemoryBlocks, outData, debug));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachByProgramId, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachByProgramId, (pOutHandle, pPID, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachOnLaunch, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachOnLaunch, (pOutHandle, pPID, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugMonitorProcessId, (::nn::sf::Out<::nn::Bit64> outPid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDebugMonitorProcessId, (outPid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJitDebugProcessList, (::nn::sf::Out<::std::int32_t> pNumProcesses, const ::nn::sf::OutBuffer& outData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetJitDebugProcessList, (pNumProcesses, outData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateCoreDump, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateCoreDump, (FileName, Details, Modules, Threads, Handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllDebugThreadInfo, (::nn::svc::Handle debug, const ::nn::sf::OutBuffer& outData, const ::nn::sf::InBuffer& threadInfo, ::nn::Bit32 arraySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAllDebugThreadInfo, (debug, outData, threadInfo, arraySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileOpen, (const ::nn::sf::InBuffer& FileName, ::std::uint32_t OpenMode, ::std::int32_t CreationDisposition, const ::nn::sf::OutBuffer& pHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileOpen, (FileName, OpenMode, CreationDisposition, pHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileClose, (const ::nn::sf::InBuffer& Handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileClose, (Handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileRead, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesRead, ::std::int64_t Offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileRead, (Handle, pBuffer, pNumberOfBytesRead, Offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileWrite, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::InBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesWritten, ::std::int64_t Offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileWrite, (Handle, pBuffer, pNumberOfBytesWritten, Offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetAttributes, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& pAttribs))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileSetAttributes, (FileName, pAttribs));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileGetInformation, (const ::nn::sf::InBuffer& FileName, ::nn::sf::Out<::std::int32_t> pIsDirectory, const ::nn::sf::OutBuffer& pData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileGetInformation, (FileName, pIsDirectory, pData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetTime, (const ::nn::sf::InBuffer& FileName, ::std::uint64_t CreateTime, ::std::uint64_t AccessTime, ::std::uint64_t ModifyTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileSetTime, (FileName, CreateTime, AccessTime, ModifyTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetSize, (const ::nn::sf::InBuffer& FileName, ::std::int64_t Size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileSetSize, (FileName, Size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileDelete, (const ::nn::sf::InBuffer& FileName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileDelete, (FileName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileMove, (const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_FileMove, (FromName, ToName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryCreate, (const ::nn::sf::InBuffer& FileName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryCreate, (FileName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryDelete, (const ::nn::sf::InBuffer& FileName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryDelete, (FileName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryRename, (const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryRename, (FromName, ToName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetCount, (const ::nn::sf::InBuffer& DirectoryName, ::nn::sf::Out<::std::int32_t> pNumberOfEntries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryGetCount, (DirectoryName, pNumberOfEntries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryOpen, (const ::nn::sf::InBuffer& DirectoryName, const ::nn::sf::OutBuffer& pHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryOpen, (DirectoryName, pHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetNext, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pEntry))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryGetNext, (Handle, pEntry));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryClose, (const ::nn::sf::InBuffer& Handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_DirectoryClose, (Handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_GetFreeSpace, (const ::nn::sf::OutBuffer& pFreeSpace))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_GetFreeSpace, (pFreeSpace));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_GetVolumeInformation, (const ::nn::sf::OutBuffer& pVolumeName, const ::nn::sf::OutBuffer& pFileSystemName, ::nn::sf::Out<::std::int32_t> pVolumeSerialNumber, ::nn::sf::Out<::std::int32_t> pMaximumComponentLength, ::nn::sf::Out<::std::int32_t> pFileSystemFlags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TargetIO_GetVolumeInformation, (pVolumeName, pFileSystemName, pVolumeSerialNumber, pMaximumComponentLength, pFileSystemFlags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitiateCoreDump, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle, ::nn::sf::Out<::std::uint64_t> pDumpHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitiateCoreDump, (FileName, Details, Modules, Threads, Handle, pDumpHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContinueCoreDump, (::std::uint64_t DumpHandle, ::nn::sf::Out<::std::int32_t> pProgress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ContinueCoreDump, (DumpHandle, pProgress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddTTYToCoreDump, (const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddTTYToCoreDump, (Data, DumpHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddImageToCoreDump, (const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddImageToCoreDump, (Data, DumpHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseCoreDump, (::std::uint64_t DumpHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseCoreDump, (DumpHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::dmnt::detail::IInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::dmnt::detail::IInterface))

    // nn::Result BreakDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BreakDebugProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (debug))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BreakDebugProcess)

    // nn::Result TerminateDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateDebugProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (debug))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateDebugProcess)

    // nn::Result CloseHandle(nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (debug))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseHandle)

    // nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutHandle, const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Args) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Args, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (FileName, Args))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Args)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadImage)

    // nn::Result GetProcessId(nn::sf::Out<nn::Bit64> outPid, nn::svc::Handle process) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProcessId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(process, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (process))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outPid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outPid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(process)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProcessId)

    // nn::Result GetProcessHandle(nn::sf::Out<std::uint32_t> pOutHandle, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProcessHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProcessHandle)

    // nn::Result WaitSynchronization(nn::svc::Handle handle, nn::Bit64 ns) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WaitSynchronization)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ns, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, ns))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ns)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WaitSynchronization)

    // nn::Result GetDebugEvent(const nn::sf::OutBuffer& pEvent, nn::svc::Handle process) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDebugEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pEvent, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pEvent))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(process, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (process))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(process)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDebugEvent)

    // nn::Result GetProcessModuleInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutBuffer& pOutModules, std::int32_t num, nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProcessModuleInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutModules, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutModules))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(num, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::os::ProcessId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (num, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutModules), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(num), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProcessModuleInfo)

    // nn::Result GetProcessList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outProcessIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProcessList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outProcessIds, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outProcessIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumThreads, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumThreads))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumThreads), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProcessIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProcessList)

    // nn::Result GetThreadList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outThreads, nn::svc::Handle domain) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetThreadList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outThreads, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outThreads))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(domain, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (domain))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumThreads, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumThreads))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumThreads), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outThreads), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(domain)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetThreadList)

    // nn::Result GetDebugThreadContext(const nn::sf::OutBuffer& outContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDebugThreadContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outContext, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(controlFlags, (::nn::Bit32), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(threadId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (debug, controlFlags, threadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(controlFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDebugThreadContext)

    // nn::Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::sf::InBuffer& threadIds, nn::Bit32 size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ContinueDebugEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(threadIds, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (threadIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::nn::Bit32), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::nn::Bit32), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (debug, flags, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threadIds), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ContinueDebugEvent)

    // nn::Result ReadDebugProcessMemory(const nn::sf::OutBuffer& buf, nn::svc::Handle debug, std::int64_t addr, std::int64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadDebugProcessMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buf, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buf))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addr, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (debug, addr, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadDebugProcessMemory)

    // nn::Result WriteDebugProcessMemory(nn::svc::Handle debug, const nn::sf::InBuffer& buf, std::int64_t addr, std::int64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteDebugProcessMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buf, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buf))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addr, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (debug, addr, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteDebugProcessMemory)

    // nn::Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::sf::InBuffer& context, nn::Bit32 controlFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDebugThreadContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(context, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (context))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(controlFlags, (::nn::Bit32), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(threadId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (debug, controlFlags, threadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(context), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(controlFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDebugThreadContext)

    // nn::Result GetDebugThreadParam(nn::sf::Out<nn::Bit64> pOut1, nn::sf::Out<nn::Bit32> pOut2, nn::svc::Handle debug, nn::Bit64 threadId, std::uint32_t select) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDebugThreadParam)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(select, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(threadId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (debug, select, threadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut2, (::nn::Bit32), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut1, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOut2, pOut1))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut2), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(select)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDebugThreadParam)

    // nn::Result InitializeThreadInfo(const nn::sf::OutBuffer& threadInfo, nn::svc::Handle debug, const nn::sf::InBuffer& createProcess, const nn::sf::InBuffer& createThread) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeThreadInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(threadInfo, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(createProcess, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(createThread, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (threadInfo, createProcess, createThread))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (debug))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threadInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(createProcess), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(createThread)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeThreadInfo)

    // nn::Result SetHardwareBreakPoint(std::uint32_t regNo, nn::Bit64 control, nn::Bit64 value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetHardwareBreakPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(regNo, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(control, (::nn::Bit64), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (regNo, control, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(regNo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(control), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetHardwareBreakPoint)

    // nn::Result QueryDebugProcessMemory(const nn::sf::OutBuffer& blockInfo, const nn::sf::OutBuffer& pageInfo, nn::svc::Handle debug, std::int64_t addr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryDebugProcessMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockInfo, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pageInfo, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (blockInfo, pageInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addr, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (debug, addr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pageInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryDebugProcessMemory)

    // nn::Result GetProcessMemoryDetails(nn::sf::Out<std::int32_t> pNumMemoryBlocks, const nn::sf::OutBuffer& outData, nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProcessMemoryDetails)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (debug))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumMemoryBlocks, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumMemoryBlocks))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumMemoryBlocks), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProcessMemoryDetails)

    // nn::Result AttachByProgramId(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachByProgramId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pPID, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutHandle, pPID))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pPID), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachByProgramId)

    // nn::Result AttachOnLaunch(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachOnLaunch)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pPID, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutHandle, pPID))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pPID), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachOnLaunch)

    // nn::Result GetDebugMonitorProcessId(nn::sf::Out<nn::Bit64> outPid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDebugMonitorProcessId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outPid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outPid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDebugMonitorProcessId)

    // nn::Result GetJitDebugProcessList(nn::sf::Out<std::int32_t> pNumProcesses, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetJitDebugProcessList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumProcesses, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumProcesses))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumProcesses), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetJitDebugProcessList)

    // nn::Result CreateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateCoreDump)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Details, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Modules, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Threads, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (FileName, Details, Modules, Threads))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(Handle, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (Handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Details), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Modules), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Threads), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateCoreDump)

    // nn::Result GetAllDebugThreadInfo(nn::svc::Handle debug, const nn::sf::OutBuffer& outData, const nn::sf::InBuffer& threadInfo, nn::Bit32 arraySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAllDebugThreadInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(threadInfo, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outData, threadInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(debug, (::nn::svc::Handle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(arraySize, (::nn::Bit32), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (debug, arraySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(debug), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(threadInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(arraySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAllDebugThreadInfo)

    // nn::Result TargetIO_FileOpen(const nn::sf::InBuffer& FileName, std::uint32_t OpenMode, std::int32_t CreationDisposition, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileOpen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pHandle, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (FileName, pHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(OpenMode, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(CreationDisposition, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (OpenMode, CreationDisposition))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(OpenMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(CreationDisposition), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileOpen)

    // nn::Result TargetIO_FileClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileClose)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Handle, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (Handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileClose)

    // nn::Result TargetIO_FileRead(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesRead, std::int64_t Offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileRead)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Handle, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (Handle, pBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(Offset, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (Offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumberOfBytesRead, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumberOfBytesRead))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumberOfBytesRead), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileRead)

    // nn::Result TargetIO_FileWrite(const nn::sf::InBuffer& Handle, const nn::sf::InBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesWritten, std::int64_t Offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileWrite)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Handle, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (Handle, pBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(Offset, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (Offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumberOfBytesWritten, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumberOfBytesWritten))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumberOfBytesWritten), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileWrite)

    // nn::Result TargetIO_FileSetAttributes(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& pAttribs) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileSetAttributes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pAttribs, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (FileName, pAttribs))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAttribs)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileSetAttributes)

    // nn::Result TargetIO_FileGetInformation(const nn::sf::InBuffer& FileName, nn::sf::Out<std::int32_t> pIsDirectory, const nn::sf::OutBuffer& pData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileGetInformation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (FileName, pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pIsDirectory, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pIsDirectory))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pIsDirectory), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileGetInformation)

    // nn::Result TargetIO_FileSetTime(const nn::sf::InBuffer& FileName, std::uint64_t CreateTime, std::uint64_t AccessTime, std::uint64_t ModifyTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileSetTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (FileName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(CreateTime, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(AccessTime, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ModifyTime, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (CreateTime, AccessTime, ModifyTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(CreateTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(AccessTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ModifyTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileSetTime)

    // nn::Result TargetIO_FileSetSize(const nn::sf::InBuffer& FileName, std::int64_t Size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileSetSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (FileName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(Size, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (Size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileSetSize)

    // nn::Result TargetIO_FileDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileDelete)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (FileName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileDelete)

    // nn::Result TargetIO_FileMove(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_FileMove)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FromName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ToName, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (FromName, ToName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FromName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ToName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_FileMove)

    // nn::Result TargetIO_DirectoryCreate(const nn::sf::InBuffer& FileName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryCreate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (FileName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryCreate)

    // nn::Result TargetIO_DirectoryDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryDelete)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (FileName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryDelete)

    // nn::Result TargetIO_DirectoryRename(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryRename)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FromName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ToName, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (FromName, ToName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FromName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ToName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryRename)

    // nn::Result TargetIO_DirectoryGetCount(const nn::sf::InBuffer& DirectoryName, nn::sf::Out<std::int32_t> pNumberOfEntries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryGetCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(DirectoryName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (DirectoryName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pNumberOfEntries, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pNumberOfEntries))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(DirectoryName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pNumberOfEntries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryGetCount)

    // nn::Result TargetIO_DirectoryOpen(const nn::sf::InBuffer& DirectoryName, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryOpen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(DirectoryName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pHandle, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (DirectoryName, pHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(DirectoryName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryOpen)

    // nn::Result TargetIO_DirectoryGetNext(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pEntry) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryGetNext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(44)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Handle, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pEntry, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (Handle, pEntry))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEntry)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryGetNext)

    // nn::Result TargetIO_DirectoryClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_DirectoryClose)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(45)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Handle, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (Handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_DirectoryClose)

    // nn::Result TargetIO_GetFreeSpace(const nn::sf::OutBuffer& pFreeSpace) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_GetFreeSpace)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(46)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pFreeSpace, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pFreeSpace))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFreeSpace)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_GetFreeSpace)

    // nn::Result TargetIO_GetVolumeInformation(const nn::sf::OutBuffer& pVolumeName, const nn::sf::OutBuffer& pFileSystemName, nn::sf::Out<std::int32_t> pVolumeSerialNumber, nn::sf::Out<std::int32_t> pMaximumComponentLength, nn::sf::Out<std::int32_t> pFileSystemFlags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TargetIO_GetVolumeInformation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pVolumeName, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pFileSystemName, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pVolumeName, pFileSystemName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pVolumeSerialNumber, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pMaximumComponentLength, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pFileSystemFlags, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pVolumeSerialNumber, pMaximumComponentLength, pFileSystemFlags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pVolumeName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFileSystemName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pVolumeSerialNumber), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pMaximumComponentLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pFileSystemFlags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TargetIO_GetVolumeInformation)

    // nn::Result InitiateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle, nn::sf::Out<std::uint64_t> pDumpHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitiateCoreDump)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(FileName, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Details, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Modules, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Threads, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (FileName, Details, Modules, Threads))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(Handle, (::nn::svc::Handle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (Handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pDumpHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pDumpHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FileName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Details), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Modules), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Threads), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDumpHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitiateCoreDump)

    // nn::Result ContinueCoreDump(std::uint64_t DumpHandle, nn::sf::Out<std::int32_t> pProgress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ContinueCoreDump)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(DumpHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (DumpHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pProgress, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pProgress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(DumpHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pProgress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ContinueCoreDump)

    // nn::Result AddTTYToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddTTYToCoreDump)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Data, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (Data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(DumpHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (DumpHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(DumpHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddTTYToCoreDump)

    // nn::Result AddImageToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddImageToCoreDump)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(Data, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (Data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(DumpHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (DumpHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(Data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(DumpHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddImageToCoreDump)

    // nn::Result CloseCoreDump(std::uint64_t DumpHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseCoreDump)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(DumpHandle, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (DumpHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(DumpHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseCoreDump)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::dmnt::detail::IInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::dmnt::detail::IInterface))

    // nn::Result BreakDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BreakDebugProcess, (::nn::svc::Handle debug))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BreakDebugProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BreakDebugProcess)
    }

    // nn::Result TerminateDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateDebugProcess, (::nn::svc::Handle debug))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateDebugProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateDebugProcess)
    }

    // nn::Result CloseHandle(nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseHandle, (::nn::svc::Handle debug))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseHandle)
    }

    // nn::Result LoadImage(nn::sf::Out<std::uint32_t> pOutHandle, const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Args) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadImage, (::nn::sf::Out<::std::uint32_t> pOutHandle, const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Args))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Args)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadImage)
    }

    // nn::Result GetProcessId(nn::sf::Out<nn::Bit64> outPid, nn::svc::Handle process) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessId, (::nn::sf::Out<::nn::Bit64> outPid, ::nn::svc::Handle process))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(process)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProcessId)
    }

    // nn::Result GetProcessHandle(nn::sf::Out<std::uint32_t> pOutHandle, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessHandle, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProcessHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProcessHandle)
    }

    // nn::Result WaitSynchronization(nn::svc::Handle handle, nn::Bit64 ns) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WaitSynchronization, (::nn::svc::Handle handle, ::nn::Bit64 ns))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WaitSynchronization)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ns)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WaitSynchronization)
    }

    // nn::Result GetDebugEvent(const nn::sf::OutBuffer& pEvent, nn::svc::Handle process) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugEvent, (const ::nn::sf::OutBuffer& pEvent, ::nn::svc::Handle process))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDebugEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(process)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDebugEvent)
    }

    // nn::Result GetProcessModuleInfo(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutBuffer& pOutModules, std::int32_t num, nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessModuleInfo, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutBuffer& pOutModules, ::std::int32_t num, ::nn::os::ProcessId pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProcessModuleInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutModules)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(num)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProcessModuleInfo)
    }

    // nn::Result GetProcessList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outProcessIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessList, (::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outProcessIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProcessList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumThreads)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProcessIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProcessList)
    }

    // nn::Result GetThreadList(nn::sf::Out<std::int32_t> pNumThreads, const nn::sf::OutBuffer& outThreads, nn::svc::Handle domain) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetThreadList, (::nn::sf::Out<::std::int32_t> pNumThreads, const ::nn::sf::OutBuffer& outThreads, ::nn::svc::Handle domain))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetThreadList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumThreads)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outThreads)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(domain)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetThreadList)
    }

    // nn::Result GetDebugThreadContext(const nn::sf::OutBuffer& outContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugThreadContext, (const ::nn::sf::OutBuffer& outContext, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::nn::Bit32 controlFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDebugThreadContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(controlFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDebugThreadContext)
    }

    // nn::Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::sf::InBuffer& threadIds, nn::Bit32 size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContinueDebugEvent, (::nn::svc::Handle debug, ::nn::Bit32 flags, const ::nn::sf::InBuffer& threadIds, ::nn::Bit32 size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ContinueDebugEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threadIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ContinueDebugEvent)
    }

    // nn::Result ReadDebugProcessMemory(const nn::sf::OutBuffer& buf, nn::svc::Handle debug, std::int64_t addr, std::int64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadDebugProcessMemory, (const ::nn::sf::OutBuffer& buf, ::nn::svc::Handle debug, ::std::int64_t addr, ::std::int64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadDebugProcessMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadDebugProcessMemory)
    }

    // nn::Result WriteDebugProcessMemory(nn::svc::Handle debug, const nn::sf::InBuffer& buf, std::int64_t addr, std::int64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteDebugProcessMemory, (::nn::svc::Handle debug, const ::nn::sf::InBuffer& buf, ::std::int64_t addr, ::std::int64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteDebugProcessMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteDebugProcessMemory)
    }

    // nn::Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::sf::InBuffer& context, nn::Bit32 controlFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebugThreadContext, (::nn::svc::Handle debug, ::nn::Bit64 threadId, const ::nn::sf::InBuffer& context, ::nn::Bit32 controlFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDebugThreadContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(context)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(controlFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDebugThreadContext)
    }

    // nn::Result GetDebugThreadParam(nn::sf::Out<nn::Bit64> pOut1, nn::sf::Out<nn::Bit32> pOut2, nn::svc::Handle debug, nn::Bit64 threadId, std::uint32_t select) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugThreadParam, (::nn::sf::Out<::nn::Bit64> pOut1, ::nn::sf::Out<::nn::Bit32> pOut2, ::nn::svc::Handle debug, ::nn::Bit64 threadId, ::std::uint32_t select))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDebugThreadParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(select)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDebugThreadParam)
    }

    // nn::Result InitializeThreadInfo(const nn::sf::OutBuffer& threadInfo, nn::svc::Handle debug, const nn::sf::InBuffer& createProcess, const nn::sf::InBuffer& createThread) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeThreadInfo, (const ::nn::sf::OutBuffer& threadInfo, ::nn::svc::Handle debug, const ::nn::sf::InBuffer& createProcess, const ::nn::sf::InBuffer& createThread))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeThreadInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threadInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(createProcess)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(createThread)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeThreadInfo)
    }

    // nn::Result SetHardwareBreakPoint(std::uint32_t regNo, nn::Bit64 control, nn::Bit64 value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHardwareBreakPoint, (::std::uint32_t regNo, ::nn::Bit64 control, ::nn::Bit64 value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetHardwareBreakPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(regNo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(control)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetHardwareBreakPoint)
    }

    // nn::Result QueryDebugProcessMemory(const nn::sf::OutBuffer& blockInfo, const nn::sf::OutBuffer& pageInfo, nn::svc::Handle debug, std::int64_t addr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryDebugProcessMemory, (const ::nn::sf::OutBuffer& blockInfo, const ::nn::sf::OutBuffer& pageInfo, ::nn::svc::Handle debug, ::std::int64_t addr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryDebugProcessMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pageInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryDebugProcessMemory)
    }

    // nn::Result GetProcessMemoryDetails(nn::sf::Out<std::int32_t> pNumMemoryBlocks, const nn::sf::OutBuffer& outData, nn::svc::Handle debug) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProcessMemoryDetails, (::nn::sf::Out<::std::int32_t> pNumMemoryBlocks, const ::nn::sf::OutBuffer& outData, ::nn::svc::Handle debug))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProcessMemoryDetails)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumMemoryBlocks)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProcessMemoryDetails)
    }

    // nn::Result AttachByProgramId(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachByProgramId, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachByProgramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pPID)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachByProgramId)
    }

    // nn::Result AttachOnLaunch(nn::sf::Out<std::uint32_t> pOutHandle, nn::sf::Out<nn::Bit64> pPID, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachOnLaunch, (::nn::sf::Out<::std::uint32_t> pOutHandle, ::nn::sf::Out<::nn::Bit64> pPID, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachOnLaunch)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pPID)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachOnLaunch)
    }

    // nn::Result GetDebugMonitorProcessId(nn::sf::Out<nn::Bit64> outPid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDebugMonitorProcessId, (::nn::sf::Out<::nn::Bit64> outPid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDebugMonitorProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDebugMonitorProcessId)
    }

    // nn::Result GetJitDebugProcessList(nn::sf::Out<std::int32_t> pNumProcesses, const nn::sf::OutBuffer& outData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJitDebugProcessList, (::nn::sf::Out<::std::int32_t> pNumProcesses, const ::nn::sf::OutBuffer& outData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetJitDebugProcessList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumProcesses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetJitDebugProcessList)
    }

    // nn::Result CreateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateCoreDump, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateCoreDump)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Details)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Modules)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Threads)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateCoreDump)
    }

    // nn::Result GetAllDebugThreadInfo(nn::svc::Handle debug, const nn::sf::OutBuffer& outData, const nn::sf::InBuffer& threadInfo, nn::Bit32 arraySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllDebugThreadInfo, (::nn::svc::Handle debug, const ::nn::sf::OutBuffer& outData, const ::nn::sf::InBuffer& threadInfo, ::nn::Bit32 arraySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAllDebugThreadInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(debug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(threadInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(arraySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAllDebugThreadInfo)
    }

    // nn::Result TargetIO_FileOpen(const nn::sf::InBuffer& FileName, std::uint32_t OpenMode, std::int32_t CreationDisposition, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileOpen, (const ::nn::sf::InBuffer& FileName, ::std::uint32_t OpenMode, ::std::int32_t CreationDisposition, const ::nn::sf::OutBuffer& pHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileOpen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(OpenMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(CreationDisposition)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileOpen)
    }

    // nn::Result TargetIO_FileClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileClose, (const ::nn::sf::InBuffer& Handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileClose)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileClose)
    }

    // nn::Result TargetIO_FileRead(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesRead, std::int64_t Offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileRead, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesRead, ::std::int64_t Offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileRead)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumberOfBytesRead)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileRead)
    }

    // nn::Result TargetIO_FileWrite(const nn::sf::InBuffer& Handle, const nn::sf::InBuffer& pBuffer, nn::sf::Out<std::int32_t> pNumberOfBytesWritten, std::int64_t Offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileWrite, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::InBuffer& pBuffer, ::nn::sf::Out<::std::int32_t> pNumberOfBytesWritten, ::std::int64_t Offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileWrite)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumberOfBytesWritten)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileWrite)
    }

    // nn::Result TargetIO_FileSetAttributes(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& pAttribs) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetAttributes, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& pAttribs))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileSetAttributes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAttribs)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileSetAttributes)
    }

    // nn::Result TargetIO_FileGetInformation(const nn::sf::InBuffer& FileName, nn::sf::Out<std::int32_t> pIsDirectory, const nn::sf::OutBuffer& pData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileGetInformation, (const ::nn::sf::InBuffer& FileName, ::nn::sf::Out<::std::int32_t> pIsDirectory, const ::nn::sf::OutBuffer& pData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileGetInformation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pIsDirectory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileGetInformation)
    }

    // nn::Result TargetIO_FileSetTime(const nn::sf::InBuffer& FileName, std::uint64_t CreateTime, std::uint64_t AccessTime, std::uint64_t ModifyTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetTime, (const ::nn::sf::InBuffer& FileName, ::std::uint64_t CreateTime, ::std::uint64_t AccessTime, ::std::uint64_t ModifyTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileSetTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(CreateTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(AccessTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ModifyTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileSetTime)
    }

    // nn::Result TargetIO_FileSetSize(const nn::sf::InBuffer& FileName, std::int64_t Size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileSetSize, (const ::nn::sf::InBuffer& FileName, ::std::int64_t Size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileSetSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileSetSize)
    }

    // nn::Result TargetIO_FileDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileDelete, (const ::nn::sf::InBuffer& FileName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileDelete)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileDelete)
    }

    // nn::Result TargetIO_FileMove(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_FileMove, (const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_FileMove)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FromName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ToName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_FileMove)
    }

    // nn::Result TargetIO_DirectoryCreate(const nn::sf::InBuffer& FileName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryCreate, (const ::nn::sf::InBuffer& FileName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryCreate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryCreate)
    }

    // nn::Result TargetIO_DirectoryDelete(const nn::sf::InBuffer& FileName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryDelete, (const ::nn::sf::InBuffer& FileName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryDelete)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryDelete)
    }

    // nn::Result TargetIO_DirectoryRename(const nn::sf::InBuffer& FromName, const nn::sf::InBuffer& ToName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryRename, (const ::nn::sf::InBuffer& FromName, const ::nn::sf::InBuffer& ToName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryRename)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FromName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ToName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryRename)
    }

    // nn::Result TargetIO_DirectoryGetCount(const nn::sf::InBuffer& DirectoryName, nn::sf::Out<std::int32_t> pNumberOfEntries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetCount, (const ::nn::sf::InBuffer& DirectoryName, ::nn::sf::Out<::std::int32_t> pNumberOfEntries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryGetCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(DirectoryName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pNumberOfEntries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryGetCount)
    }

    // nn::Result TargetIO_DirectoryOpen(const nn::sf::InBuffer& DirectoryName, const nn::sf::OutBuffer& pHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryOpen, (const ::nn::sf::InBuffer& DirectoryName, const ::nn::sf::OutBuffer& pHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryOpen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(DirectoryName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryOpen)
    }

    // nn::Result TargetIO_DirectoryGetNext(const nn::sf::InBuffer& Handle, const nn::sf::OutBuffer& pEntry) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryGetNext, (const ::nn::sf::InBuffer& Handle, const ::nn::sf::OutBuffer& pEntry))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryGetNext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEntry)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryGetNext)
    }

    // nn::Result TargetIO_DirectoryClose(const nn::sf::InBuffer& Handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_DirectoryClose, (const ::nn::sf::InBuffer& Handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_DirectoryClose)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_DirectoryClose)
    }

    // nn::Result TargetIO_GetFreeSpace(const nn::sf::OutBuffer& pFreeSpace) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_GetFreeSpace, (const ::nn::sf::OutBuffer& pFreeSpace))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_GetFreeSpace)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFreeSpace)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_GetFreeSpace)
    }

    // nn::Result TargetIO_GetVolumeInformation(const nn::sf::OutBuffer& pVolumeName, const nn::sf::OutBuffer& pFileSystemName, nn::sf::Out<std::int32_t> pVolumeSerialNumber, nn::sf::Out<std::int32_t> pMaximumComponentLength, nn::sf::Out<std::int32_t> pFileSystemFlags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TargetIO_GetVolumeInformation, (const ::nn::sf::OutBuffer& pVolumeName, const ::nn::sf::OutBuffer& pFileSystemName, ::nn::sf::Out<::std::int32_t> pVolumeSerialNumber, ::nn::sf::Out<::std::int32_t> pMaximumComponentLength, ::nn::sf::Out<::std::int32_t> pFileSystemFlags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TargetIO_GetVolumeInformation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pVolumeName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFileSystemName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pVolumeSerialNumber)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pMaximumComponentLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pFileSystemFlags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TargetIO_GetVolumeInformation)
    }

    // nn::Result InitiateCoreDump(const nn::sf::InBuffer& FileName, const nn::sf::InBuffer& Details, const nn::sf::InBuffer& Modules, const nn::sf::InBuffer& Threads, nn::svc::Handle Handle, nn::sf::Out<std::uint64_t> pDumpHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitiateCoreDump, (const ::nn::sf::InBuffer& FileName, const ::nn::sf::InBuffer& Details, const ::nn::sf::InBuffer& Modules, const ::nn::sf::InBuffer& Threads, ::nn::svc::Handle Handle, ::nn::sf::Out<::std::uint64_t> pDumpHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitiateCoreDump)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FileName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Details)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Modules)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Threads)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDumpHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitiateCoreDump)
    }

    // nn::Result ContinueCoreDump(std::uint64_t DumpHandle, nn::sf::Out<std::int32_t> pProgress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ContinueCoreDump, (::std::uint64_t DumpHandle, ::nn::sf::Out<::std::int32_t> pProgress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ContinueCoreDump)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(DumpHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pProgress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ContinueCoreDump)
    }

    // nn::Result AddTTYToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddTTYToCoreDump, (const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddTTYToCoreDump)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(DumpHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddTTYToCoreDump)
    }

    // nn::Result AddImageToCoreDump(const nn::sf::InBuffer& Data, std::uint64_t DumpHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddImageToCoreDump, (const ::nn::sf::InBuffer& Data, ::std::uint64_t DumpHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddImageToCoreDump)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(Data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(DumpHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddImageToCoreDump)
    }

    // nn::Result CloseCoreDump(std::uint64_t DumpHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseCoreDump, (::std::uint64_t DumpHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseCoreDump)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(DumpHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseCoreDump)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::dmnt::detail::IInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::dmnt::detail::IInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BreakDebugProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BreakDebugProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateDebugProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateDebugProcess)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Args)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Args)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProcessId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outPid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(process)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProcessHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProcessHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WaitSynchronization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WaitSynchronization)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ns)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDebugEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDebugEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(process)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProcessModuleInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutModules)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProcessModuleInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutModules),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(num),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProcessList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outProcessIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProcessList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumThreads),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outProcessIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetThreadList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outThreads)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetThreadList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumThreads),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outThreads),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(domain)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDebugThreadContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDebugThreadContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(threadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(controlFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ContinueDebugEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(threadIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ContinueDebugEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(threadIds),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadDebugProcessMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadDebugProcessMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteDebugProcessMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteDebugProcessMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDebugThreadContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(context)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDebugThreadContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(threadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(context),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(controlFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDebugThreadParam)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDebugThreadParam)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut2),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(threadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(select)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeThreadInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(threadInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(createProcess)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(createThread)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeThreadInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(threadInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(createProcess),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(createThread)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetHardwareBreakPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetHardwareBreakPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(regNo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(control),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryDebugProcessMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pageInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryDebugProcessMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pageInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProcessMemoryDetails)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProcessMemoryDetails)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumMemoryBlocks),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachByProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachByProgramId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pPID),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachOnLaunch)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachOnLaunch)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pPID),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDebugMonitorProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDebugMonitorProcessId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outPid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetJitDebugProcessList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetJitDebugProcessList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumProcesses),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Details)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Modules)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Threads)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateCoreDump)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Details),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Modules),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Threads),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(Handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAllDebugThreadInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(threadInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAllDebugThreadInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(debug),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(threadInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(arraySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileOpen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(OpenMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(CreationDisposition),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileClose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileClose)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Handle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileRead)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumberOfBytesRead),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(Offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Handle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileWrite)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumberOfBytesWritten),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(Offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileSetAttributes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pAttribs)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileSetAttributes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pAttribs)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileGetInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileGetInformation)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pIsDirectory),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileSetTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileSetTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(CreateTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(AccessTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ModifyTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileSetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileSetSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(Size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileDelete)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_FileMove)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FromName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ToName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_FileMove)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FromName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ToName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryCreate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryCreate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryDelete)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryRename)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FromName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ToName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryRename)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FromName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ToName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryGetCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(DirectoryName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryGetCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(DirectoryName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pNumberOfEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(DirectoryName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryOpen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(DirectoryName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryGetNext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Handle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryGetNext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_DirectoryClose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_DirectoryClose)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_GetFreeSpace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pFreeSpace)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_GetFreeSpace)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pFreeSpace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TargetIO_GetVolumeInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pVolumeName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pFileSystemName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TargetIO_GetVolumeInformation)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pVolumeName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pFileSystemName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pVolumeSerialNumber),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pMaximumComponentLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pFileSystemFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitiateCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(FileName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Details)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Modules)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Threads)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitiateCoreDump)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(FileName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Details),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Modules),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Threads),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(Handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pDumpHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ContinueCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ContinueCoreDump)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(DumpHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddTTYToCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddTTYToCoreDump)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(DumpHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddImageToCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(Data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddImageToCoreDump)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(Data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(DumpHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseCoreDump)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(DumpHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BreakDebugProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateDebugProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProcessHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WaitSynchronization)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDebugEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProcessModuleInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProcessList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetThreadList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDebugThreadContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ContinueDebugEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadDebugProcessMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteDebugProcessMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDebugThreadContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDebugThreadParam)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeThreadInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetHardwareBreakPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryDebugProcessMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProcessMemoryDetails)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachByProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachOnLaunch)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDebugMonitorProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetJitDebugProcessList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAllDebugThreadInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileClose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileSetAttributes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileGetInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileSetTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileSetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_FileMove)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryCreate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryRename)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryGetCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryOpen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryGetNext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_DirectoryClose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_GetFreeSpace)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TargetIO_GetVolumeInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitiateCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ContinueCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddTTYToCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddImageToCoreDump)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseCoreDump)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::dmnt::detail::IInterface))
