﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Cpad ライブラリの型や定数の定義。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_BitPack.h>

namespace nn {
namespace cpad {

/**
 * @brief       Cpad のスティックの最大座標値
 */
const int CpadStickMax    =  72;

/**
 * @brief       Cpad のスティックの最小座標値
 */
const int CpadStickMin    = -72;

/**
 * @brief       Cpad のスティックの原点座標値
 *
 * @invariant
 *              - CpadStickMax - CpadStickOrigin == CpadStickOrigin - CpadStickMin
 */
const int CpadStickOrigin =  0;

/**
 * @brief       Cpad のデジタルボタンの定義です。
 */
struct CpadButton
{
    typedef nn::util::BitPack32::Field< 0, 1, bool> A;        //!< Cpad の A ボタン
    typedef nn::util::BitPack32::Field< 1, 1, bool> B;        //!< Cpad の B ボタン
    typedef nn::util::BitPack32::Field< 2, 1, bool> X;        //!< Cpad の X ボタン
    typedef nn::util::BitPack32::Field< 3, 1, bool> Y;        //!< Cpad の Y ボタン
    typedef nn::util::BitPack32::Field< 4, 1, bool> L;        //!< Cpad の L ボタン
    typedef nn::util::BitPack32::Field< 5, 1, bool> R;        //!< Cpad の R ボタン
    typedef nn::util::BitPack32::Field< 6, 1, bool> ZL;       //!< Cpad の ZL ボタン
    typedef nn::util::BitPack32::Field< 7, 1, bool> ZR;       //!< Cpad の ZR ボタン
    typedef nn::util::BitPack32::Field< 8, 1, bool> Start;    //!< Cpad の Start ボタン
    typedef nn::util::BitPack32::Field< 9, 1, bool> Select;   //!< Cpad の Select ボタン
    typedef nn::util::BitPack32::Field<10, 1, bool> Home;     //!< Cpad の Home ボタン
    typedef nn::util::BitPack32::Field<11, 1, bool> Left;     //!< Cpad の十字ボタン 左
    typedef nn::util::BitPack32::Field<12, 1, bool> Up;       //!< Cpad の十字ボタン 上
    typedef nn::util::BitPack32::Field<13, 1, bool> Right;    //!< Cpad の十字ボタン 右
    typedef nn::util::BitPack32::Field<14, 1, bool> Down;     //!< Cpad の十字ボタン 下
};

/**
 * @brief       Cpad のスティックの入力座標を表す構造体です。
 */
struct CpadStickState
{
    int32_t x;  //!< Cpad のスティックの x 座標
    int32_t y;  //!< Cpad のスティックの y 座標
};

/**
 * @brief       Cpad の入力状態を表す構造体です。
 */
struct CpadState
{
    nn::util::BitPack32   buttons;  //!< Cpad のデジタルボタンの押下状態
    CpadStickState        stickL;   //!< Cpad の L スティックの入力座標
    CpadStickState        stickR;   //!< Cpad の R スティックの入力座標
};

} // cpad
} // nn
