﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*
 * @file
 * @brief       Opus エンコーダに関するデータ型を定義します。
 */

namespace nn {
namespace codec {

/**
 * @internal
 * @brief       Opus エンコーダが扱うバンド幅を表す列挙型です。
 */
enum OpusBandwidth
{
    OpusBandwidth_Auto = 1,             //!< @internal 自動判別
    OpusBandwidth_NarrowBand,           //!< @internal カットオフ周波数  4kHz
    OpusBandwidth_MediumBand,           //!< @internal カットオフ周波数  6kHz
    OpusBandwidth_WideBand,             //!< @internal カットオフ周波数  8kHz
    OpusBandwidth_SuperWideBand,        //!< @internal カットオフ周波数 12kHz
    OpusBandwidth_FullBand,             //!< @internal カットオフ周波数 20kHz
    OpusBandwidth_Invalid               //!< @internal 無効値
};

/**
 * @internal
 * @brief       Opus エンコーダが扱うフレームサイズを表す列挙型です。
 */
enum OpusFrameSize
{
    OpusFrameSize_Argument = 1,         //!< @internal 引数指定
    OpusFrameSize_2500Us,               //!< @internal 2.5ms 固定
    OpusFrameSize_5000Us,               //!< @internal 5ms 固定
    OpusFrameSize_10000Us,              //!< @internal 10ms 固定
    OpusFrameSize_20000Us,              //!< @internal 20ms 固定
    OpusFrameSize_40000Us,              //!< @internal 40ms 固定
    OpusFrameSize_60000Us,              //!< @internal 60ms 固定
    OpusFrameSize_Variable,             //!< @internal 可変フレームサイズ
    OpusFrameSize_Invalid,              //!< @internal 無効値
};

}  // namespace codec
}  // namespace nn
