﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace codec { namespace detail { // NOLINT(whitespace/braces)

class IHardwareOpusDecoder;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IHardwareOpusDecoder, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IHardwareOpusDecoder)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetContext, (const ::nn::sf::InBuffer& pContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetContextForMultiStream, (const ::nn::sf::InBuffer& pContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedWithPerfOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamWithPerfOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleaved, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStream, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IHardwareOpusDecoder)

        ::nn::Result DecodeInterleavedOld(::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeInterleavedOld, (pOutConsumed, pOutSampleCount, outputBuffer, inputBuffer));
        }

        ::nn::Result SetContext(const ::nn::sf::InBuffer& pContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetContext, (pContext));
        }

        ::nn::Result DecodeInterleavedForMultiStreamOld(::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamOld, (pOutConsumed, pOutSampleCount, outputBuffer, inputBuffer));
        }

        ::nn::Result SetContextForMultiStream(const ::nn::sf::InBuffer& pContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetContextForMultiStream, (pContext));
        }

        ::nn::Result DecodeInterleavedWithPerfOld(::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeInterleavedWithPerfOld, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer));
        }

        ::nn::Result DecodeInterleavedForMultiStreamWithPerfOld(::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamWithPerfOld, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer));
        }

        ::nn::Result DecodeInterleaved(::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeInterleaved, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer, isResetRequested));
        }

        ::nn::Result DecodeInterleavedForMultiStream(::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStream, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer, isResetRequested));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IHardwareOpusDecoder
    {
    public:
        nn::Result DecodeInterleavedOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
        nn::Result SetContext(const nn::sf::InBuffer& pContext) NN_NOEXCEPT;
        nn::Result DecodeInterleavedForMultiStreamOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
        nn::Result SetContextForMultiStream(const nn::sf::InBuffer& pContext) NN_NOEXCEPT;
        nn::Result DecodeInterleavedWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
        nn::Result DecodeInterleavedForMultiStreamWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
        nn::Result DecodeInterleaved(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT;
        nn::Result DecodeInterleavedForMultiStream(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result DecodeInterleavedOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
    nn::Result SetContext(const nn::sf::InBuffer& pContext) NN_NOEXCEPT;
    nn::Result DecodeInterleavedForMultiStreamOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
    nn::Result SetContextForMultiStream(const nn::sf::InBuffer& pContext) NN_NOEXCEPT;
    nn::Result DecodeInterleavedWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
    nn::Result DecodeInterleavedForMultiStreamWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT;
    nn::Result DecodeInterleaved(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT;
    nn::Result DecodeInterleavedForMultiStream(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::codec::detail::IHardwareOpusDecoder))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeInterleavedOld, (pOutConsumed, pOutSampleCount, outputBuffer, inputBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetContext, (const ::nn::sf::InBuffer& pContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetContext, (pContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeInterleavedForMultiStreamOld, (pOutConsumed, pOutSampleCount, outputBuffer, inputBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetContextForMultiStream, (const ::nn::sf::InBuffer& pContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetContextForMultiStream, (pContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedWithPerfOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeInterleavedWithPerfOld, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamWithPerfOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeInterleavedForMultiStreamWithPerfOld, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleaved, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeInterleaved, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer, isResetRequested));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStream, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeInterleavedForMultiStream, (pOutConsumed, pOutPerf, pOutSampleCount, outputBuffer, inputBuffer, isResetRequested));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::codec::detail::IHardwareOpusDecoder>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::codec::detail::IHardwareOpusDecoder))

    // nn::Result DecodeInterleavedOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeInterleavedOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outputBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inputBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outputBuffer, inputBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutConsumed, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSampleCount, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutConsumed, pOutSampleCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutConsumed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSampleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inputBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeInterleavedOld)

    // nn::Result SetContext(const nn::sf::InBuffer& pContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pContext, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetContext)

    // nn::Result DecodeInterleavedForMultiStreamOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeInterleavedForMultiStreamOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outputBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inputBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outputBuffer, inputBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutConsumed, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSampleCount, (int), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutConsumed, pOutSampleCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutConsumed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSampleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inputBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeInterleavedForMultiStreamOld)

    // nn::Result SetContextForMultiStream(const nn::sf::InBuffer& pContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetContextForMultiStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pContext, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetContextForMultiStream)

    // nn::Result DecodeInterleavedWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeInterleavedWithPerfOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outputBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inputBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outputBuffer, inputBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutConsumed, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSampleCount, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutPerf, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutConsumed, pOutSampleCount, pOutPerf))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutConsumed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutPerf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSampleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inputBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeInterleavedWithPerfOld)

    // nn::Result DecodeInterleavedForMultiStreamWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeInterleavedForMultiStreamWithPerfOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outputBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inputBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outputBuffer, inputBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutConsumed, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSampleCount, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutPerf, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutConsumed, pOutSampleCount, pOutPerf))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutConsumed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutPerf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSampleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inputBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeInterleavedForMultiStreamWithPerfOld)

    // nn::Result DecodeInterleaved(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeInterleaved)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outputBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inputBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outputBuffer, inputBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isResetRequested, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isResetRequested))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutConsumed, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSampleCount, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutPerf, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutConsumed, pOutSampleCount, pOutPerf))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutConsumed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutPerf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSampleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isResetRequested)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeInterleaved)

    // nn::Result DecodeInterleavedForMultiStream(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeInterleavedForMultiStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outputBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inputBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outputBuffer, inputBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isResetRequested, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isResetRequested))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutConsumed, (int), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSampleCount, (int), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutPerf, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutConsumed, pOutSampleCount, pOutPerf))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutConsumed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutPerf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSampleCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inputBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isResetRequested)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeInterleavedForMultiStream)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::codec::detail::IHardwareOpusDecoder, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::codec::detail::IHardwareOpusDecoder))

    // nn::Result DecodeInterleavedOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeInterleavedOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutConsumed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSampleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inputBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeInterleavedOld)
    }

    // nn::Result SetContext(const nn::sf::InBuffer& pContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetContext, (const ::nn::sf::InBuffer& pContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetContext)
    }

    // nn::Result DecodeInterleavedForMultiStreamOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeInterleavedForMultiStreamOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutConsumed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSampleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inputBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeInterleavedForMultiStreamOld)
    }

    // nn::Result SetContextForMultiStream(const nn::sf::InBuffer& pContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetContextForMultiStream, (const ::nn::sf::InBuffer& pContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetContextForMultiStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetContextForMultiStream)
    }

    // nn::Result DecodeInterleavedWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedWithPerfOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeInterleavedWithPerfOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutConsumed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutPerf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSampleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inputBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeInterleavedWithPerfOld)
    }

    // nn::Result DecodeInterleavedForMultiStreamWithPerfOld(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStreamWithPerfOld, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeInterleavedForMultiStreamWithPerfOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutConsumed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutPerf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSampleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inputBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeInterleavedForMultiStreamWithPerfOld)
    }

    // nn::Result DecodeInterleaved(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleaved, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeInterleaved)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutConsumed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutPerf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSampleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isResetRequested)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeInterleaved)
    }

    // nn::Result DecodeInterleavedForMultiStream(nn::sf::Out<int> pOutConsumed, nn::sf::Out<std::int64_t> pOutPerf, nn::sf::Out<int> pOutSampleCount, const nn::sf::OutBuffer& outputBuffer, const nn::sf::InBuffer& inputBuffer, bool isResetRequested) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeInterleavedForMultiStream, (::nn::sf::Out<int> pOutConsumed, ::nn::sf::Out<::std::int64_t> pOutPerf, ::nn::sf::Out<int> pOutSampleCount, const ::nn::sf::OutBuffer& outputBuffer, const ::nn::sf::InBuffer& inputBuffer, bool isResetRequested))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeInterleavedForMultiStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutConsumed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutPerf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSampleCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inputBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isResetRequested)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeInterleavedForMultiStream)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::codec::detail::IHardwareOpusDecoder>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::codec::detail::IHardwareOpusDecoder))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeInterleavedOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outputBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inputBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeInterleavedOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutConsumed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSampleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inputBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeInterleavedForMultiStreamOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outputBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inputBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeInterleavedForMultiStreamOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutConsumed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSampleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inputBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetContextForMultiStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetContextForMultiStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeInterleavedWithPerfOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outputBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inputBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeInterleavedWithPerfOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutConsumed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutPerf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSampleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inputBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeInterleavedForMultiStreamWithPerfOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outputBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inputBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeInterleavedForMultiStreamWithPerfOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutConsumed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutPerf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSampleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inputBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeInterleaved)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outputBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inputBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeInterleaved)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutConsumed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutPerf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSampleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isResetRequested)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeInterleavedForMultiStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outputBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inputBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeInterleavedForMultiStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutConsumed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutPerf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSampleCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inputBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isResetRequested)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeInterleavedOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeInterleavedForMultiStreamOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetContextForMultiStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeInterleavedWithPerfOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeInterleavedForMultiStreamWithPerfOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeInterleaved)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeInterleavedForMultiStream)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::codec::detail::IHardwareOpusDecoder))
