﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief       HardwareOpus に関するデータ型を定義します。
 */

// TODO: スペックではなく SoC で実装分岐出来ないか検討
#include <nn/codec/detail/codec_HardwareOpusCommon-spec.NX.h>

namespace nn {
namespace codec {
namespace detail {

/**
 * @brief       Opus マネージャに対する命令を表す列挙型です。
 */
enum OpusManagerCommand
{
    OpusManagerCommand_Start = 1,                //!< スレッドの起動
    OpusManagerCommand_Exit,                     //!< スレッドの終了
};

/**
 * @brief       Opus マネージャからの応答を表す列挙型です。
 */
enum OpusManagerResponse
{
    OpusManagerResponse_Start = 11,               //!< スレッドの起動に対する応答
    OpusManagerResponse_Exit,                     //!< スレッドの終了に対する応答
};

/**
 * @brief       Opus マネージャに関する処理結果を表す列挙型です。
 */
enum OpusManagerResult
{
    OpusManagerResult_Success = 0,                //!< 成功
    OpusManagerResult_ThreadCreationFailure = 1,  //!< スレッド生成に失敗
    OpusManagerResult_UnexpectedExit = 2          //!< 予期しないスレッド終了ステータス
};

/**
 * @brief       Opus デコーダに対する命令を表す列挙型です。
 */
enum OpusDecoderCommand
{
    OpusDecoderCommand_GetWorkSize = 21,             //!< 必要なワークメモリサイズの取得
    OpusDecoderCommand_Initialize,                   //!< 初期化処理
    OpusDecoderCommand_Finalize,                     //!< 終了処理
    OpusDecoderCommand_DecodeOneFrame,               //!< 1 フレーム分のデコード
    OpusDecoderCommand_MapMemory,                    //!< メモリのマップ
    OpusDecoderCommand_UnmapMemory,                  //!< メモリのアンマップ
    OpusDecoderCommand_GetWorkSizeForMultiStream,    //!<  必要なワークメモリサイズの取得 (MultiStream)
    OpusDecoderCommand_InitializeForMultiStream,     //!< 初期化処理 (MultiStream)
    OpusDecoderCommand_FinalizeForMultiStream,       //!< 終了処理 (MultiStream)
    OpusDecoderCommand_DecodeOneFrameForMultiStream, //!< 1 フレーム分のデコード (MultiStream)
};

/**
 * @brief       Opus デコーダからの応答を表す列挙型です。
 */
enum OpusDecoderResponse
{
    OpusDecoderResponse_GetWorkSize = 41,             //!< 必要なワークメモリサイズの取得に対する応答
    OpusDecoderResponse_Initialize,                   //!< 初期化処理に対する応答
    OpusDecoderResponse_Finalize,                     //!< 終了処理に対する応答
    OpusDecoderResponse_DecodeOneFrame,               //!< 1 フレーム分のデコードに対する応答
    OpusDecoderResponse_MapMemory,                    //!< メモリのマップに対する応答
    OpusDecoderResponse_UnmapMemory,                  //!< メモリのアンマップに対する応答
    OpusDecoderResponse_GetWorkSizeForMultiStream,    //!< 必要なワークメモリサイズの取得に対する応答 (MultiStream)
    OpusDecoderResponse_InitializeForMultiStream,     //!< 初期化処理に対する応答 (MultiStream)
    OpusDecoderResponse_FinalizeForMultiStream,       //!< 終了処理に対する応答 (MultiStream)
    OpusDecoderResponse_DecodeOneFrameForMultiStream, //!<  1 フレーム分のデコードに対する応答 (MultiStream)
};

}  // namespace detail
}  // namespace codec
}  // namespace nn

