﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      btm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_BTM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(btm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_BTM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_BTM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_BTM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_BTM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(btm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_BTM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(btm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_BTM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(btm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_BTM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(btm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_BTM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(btm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_BTM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(btm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_BTM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(btm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_BTM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(btm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_BTM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(btm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_BTM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_BTM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_BTM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_BTM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(btm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_BTM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_BTM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_BTM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(btm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_BTM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Trace, 0, format, args)
#define NN_DETAIL_BTM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Trace, 1, format, args)
#define NN_DETAIL_BTM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Trace, 2, format, args)
#define NN_DETAIL_BTM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Trace, 3, format, args)

#define NN_DETAIL_BTM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Info, 0, format, args)
#define NN_DETAIL_BTM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Info, 1, format, args)
#define NN_DETAIL_BTM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Info, 2, format, args)
#define NN_DETAIL_BTM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Info, 3, format, args)

#define NN_DETAIL_BTM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Warn, 0, format, args)
#define NN_DETAIL_BTM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Warn, 1, format, args)
#define NN_DETAIL_BTM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Warn, 2, format, args)
#define NN_DETAIL_BTM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Warn, 3, format, args)

#define NN_DETAIL_BTM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Error, 0, format, args)
#define NN_DETAIL_BTM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Error, 1, format, args)
#define NN_DETAIL_BTM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Error, 2, format, args)
#define NN_DETAIL_BTM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Error, 3, format, args)

#define NN_DETAIL_BTM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Fatal, 0, format, args)
#define NN_DETAIL_BTM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Fatal, 1, format, args)
#define NN_DETAIL_BTM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Fatal, 2, format, args)
#define NN_DETAIL_BTM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(btm, Fatal, 3, format, args)

#define NN_DETAIL_BTM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(btm, Trace, 0, text, length)
#define NN_DETAIL_BTM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Trace, 1, text, length)
#define NN_DETAIL_BTM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Trace, 2, text, length)
#define NN_DETAIL_BTM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Trace, 3, text, length)

#define NN_DETAIL_BTM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(btm, Info, 0, text, length)
#define NN_DETAIL_BTM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(btm, Info, 1, text, length)
#define NN_DETAIL_BTM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(btm, Info, 2, text, length)
#define NN_DETAIL_BTM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(btm, Info, 3, text, length)

#define NN_DETAIL_BTM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(btm, Warn, 0, text, length)
#define NN_DETAIL_BTM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(btm, Warn, 1, text, length)
#define NN_DETAIL_BTM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(btm, Warn, 2, text, length)
#define NN_DETAIL_BTM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(btm, Warn, 3, text, length)

#define NN_DETAIL_BTM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(btm, Error, 0, text, length)
#define NN_DETAIL_BTM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Error, 1, text, length)
#define NN_DETAIL_BTM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Error, 2, text, length)
#define NN_DETAIL_BTM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Error, 3, text, length)

#define NN_DETAIL_BTM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(btm, Fatal, 0, text, length)
#define NN_DETAIL_BTM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Fatal, 1, text, length)
#define NN_DETAIL_BTM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Fatal, 2, text, length)
#define NN_DETAIL_BTM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(btm, Fatal, 3, text, length)
