﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      bluetooth モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_BLUETOOTH_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_BLUETOOTH_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_BLUETOOTH_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_BLUETOOTH_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_BLUETOOTH_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_BLUETOOTH_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(bluetooth, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_BLUETOOTH_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Trace, 0, format, args)
#define NN_DETAIL_BLUETOOTH_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Trace, 1, format, args)
#define NN_DETAIL_BLUETOOTH_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Trace, 2, format, args)
#define NN_DETAIL_BLUETOOTH_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Trace, 3, format, args)

#define NN_DETAIL_BLUETOOTH_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Info, 0, format, args)
#define NN_DETAIL_BLUETOOTH_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Info, 1, format, args)
#define NN_DETAIL_BLUETOOTH_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Info, 2, format, args)
#define NN_DETAIL_BLUETOOTH_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Info, 3, format, args)

#define NN_DETAIL_BLUETOOTH_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Warn, 0, format, args)
#define NN_DETAIL_BLUETOOTH_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Warn, 1, format, args)
#define NN_DETAIL_BLUETOOTH_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Warn, 2, format, args)
#define NN_DETAIL_BLUETOOTH_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Warn, 3, format, args)

#define NN_DETAIL_BLUETOOTH_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Error, 0, format, args)
#define NN_DETAIL_BLUETOOTH_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Error, 1, format, args)
#define NN_DETAIL_BLUETOOTH_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Error, 2, format, args)
#define NN_DETAIL_BLUETOOTH_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Error, 3, format, args)

#define NN_DETAIL_BLUETOOTH_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Fatal, 0, format, args)
#define NN_DETAIL_BLUETOOTH_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Fatal, 1, format, args)
#define NN_DETAIL_BLUETOOTH_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Fatal, 2, format, args)
#define NN_DETAIL_BLUETOOTH_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(bluetooth, Fatal, 3, format, args)

#define NN_DETAIL_BLUETOOTH_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Trace, 0, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Trace, 1, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Trace, 2, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Trace, 3, text, length)

#define NN_DETAIL_BLUETOOTH_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Info, 0, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Info, 1, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Info, 2, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Info, 3, text, length)

#define NN_DETAIL_BLUETOOTH_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Warn, 0, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Warn, 1, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Warn, 2, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Warn, 3, text, length)

#define NN_DETAIL_BLUETOOTH_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Error, 0, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Error, 1, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Error, 2, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Error, 3, text, length)

#define NN_DETAIL_BLUETOOTH_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Fatal, 0, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Fatal, 1, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Fatal, 2, text, length)
#define NN_DETAIL_BLUETOOTH_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(bluetooth, Fatal, 3, text, length)
