﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/service/bcat_TypesService.h>
#include <nn/nn_ApplicationId.h>

namespace nn { namespace bcat { namespace service {

/*!
    @brief      BCAT アーカイブ復号鍵の生成器です。
*/
class ArchiveDecryptionKeyGenerator
{
public:
    /*!
        @brief      ソルトインデックスの最小値です。
    */
    static const int SaltIndexMin = 0;

    /*!
        @brief      ソルトインデックスの最大値です。
    */
    static const int SaltIndexMax = 31;

public:
    /*!
        @brief      BCAT アーカイブ復号鍵を生成します。

        @param[out] outKey      復号鍵。
        @param[in]  passphrase  パスフレーズ。
        @param[in]  appId       アプリケーション ID。
        @param[in]  saltIndex   ソルトインデックス。

        @return     処理結果。

        @pre
            - outKey != nullptr
            - passphrase != nullptr
            - SaltIndexMin <= saltIndex <= SaltIndexMax

        @details
                    本関数は、BCAT データ配信サーバーと同じアルゴリズム・ソルトで復号鍵を生成します。
    */
    static void Generate(ArchiveDecryptionKey* outKey,
        const char* passphrase, const nn::ApplicationId& appId, int saltIndex) NN_NOEXCEPT;

    /*!
        @brief      BCAT アーカイブ復号鍵を生成します。

        @param[out] outKey      復号鍵。
        @param[in]  passphrase  パスフレーズ。
        @param[in]  salt        ソルト。

        @return     処理結果。

        @pre
            - outKey != nullptr
            - passphrase != nullptr
            - salt != nullptr

        @details
                    ソルトに任意の文字列を設定することが可能です。
    */
    static void Generate(ArchiveDecryptionKey* outKey,
        const char* passphrase, const char* salt) NN_NOEXCEPT;
};

}}}
