﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/crypto.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace util {

/*!
    @brief      RSA-PKCS1-SHA1 を使用した署名検証器です。
*/
typedef nn::crypto::RsaPkcs1Verifier<256, nn::crypto::Sha1Generator> SignatureVerifierRsaPkcs1Sha1;

/*!
    @brief      RSA-PKCS1-SHA256 を使用した署名検証器です。
*/
typedef nn::crypto::RsaPkcs1Verifier<256, nn::crypto::Sha256Generator> SignatureVerifierRsaPkcs1Sha256;

/*!
    @brief      RSA-PSS-SHA1 を使用した署名検証器です。
*/
typedef nn::crypto::RsaPssVerifier<256, nn::crypto::Sha1Generator> SignatureVerifierRsaPssSha1;

/*!
    @brief      RSA-PSS-SHA256 を使用した署名検証器です。
*/
typedef nn::crypto::RsaPssVerifier<256, nn::crypto::Sha256Generator> SignatureVerifierRsaPssSha256;

}}}}}
