﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/service/bcat_Common.h>
#include <nn/bcat/service/bcat_ArchiveDownloader.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      配信リストのダウンロードを行うモジュールです。
*/
class DeliveryListDownloader
{
public:
    /*!
        @brief      コンストラクタです。
    */
    DeliveryListDownloader() NN_NOEXCEPT;

    /*!
        @brief      キャンセルイベントを設定します。

        @param[in]  pCancelEvent    キャンセルイベント。

        @pre
            - pCancelEvent != nullptr
    */
    void SetCancelEvent(nn::os::Event* pCancelEvent) NN_NOEXCEPT;

    /*!
        @brief      ダウンロード処理を行います。

        @param[in]  appId                           アプリケーション ID。
        @param[in]  passphrase                      パスフレーズ。
        @param[in]  pConnection                     ネットワーク接続要求オブジェクト。
        @param[in]  enableProviderSpecificDelivery  事業者別配信が有効かどうか。
        @param[in]  buffer                          ワークバッファ。
        @param[in]  bufferSize                      ワークバッファのサイズ。

        @return     処理結果。

        @pre
            - appId != nn::ApplicationId::GetInvalidId()
            - passphrase != nullptr
            - pConnection != nullptr
            - buffer != nullptr
            - bufferSize > 0
    */
    nn::Result Download(nn::ApplicationId appId, const char* passphrase, nn::nifm::NetworkConnection* pConnection,
        bool enableProviderSpecificDelivery, void* buffer, size_t bufferSize) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::ApplicationId m_AppId;
    char m_Passphrase[PassphraseLengthMax + 1];
    //
    nn::os::Event* m_pCancelEvent;
    //
    nn::bcat::service::ArchiveDownloader m_ArchiveDownloader;

private:
    //
    nn::Result StepDownload(nn::nifm::NetworkConnection* pConnection,
        bool enableProviderSpecificDelivery, void* buffer, size_t bufferSize) NN_NOEXCEPT;
    //
    nn::Result LoadETag(nn::bcat::service::ETag* out) NN_NOEXCEPT;
    nn::Result SaveListAndETag(void* buffer, size_t bufferSize) NN_NOEXCEPT;
    //
    bool IsCanceled() NN_NOEXCEPT;
};

}}}}}
