﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheProgressService.sfdl.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      データ配信の進捗のサービスです。
*/
class DeliveryCacheProgressServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    DeliveryCacheProgressServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DeliveryCacheProgressServiceForGeneric() NN_NOEXCEPT;

public:
    // IDeliveryCacheProgressService
    nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> outEvent) NN_NOEXCEPT;
    nn::Result GetImpl(nn::sf::Out<nn::bcat::detail::DeliveryCacheProgressImpl> outImpl) NN_NOEXCEPT;

private:
    //
    nn::os::SystemEvent m_Event;
};

NN_STATIC_ASSERT(sizeof (DeliveryCacheProgressServiceForGeneric) <= detail::service::ServiceMemoryManager::DeliveryCacheProgressServiceSize);

}}}}
