﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheFileService.sfdl.h>
#include <nn/bcat/detail/service/bcat_Capability.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

class DeliveryCacheStorageService;

/*!
    @brief      データ配信キャッシュファイルのサービスです。
*/
class DeliveryCacheFileService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  parent      親となるストレージサービス。
        @param[in]  appId       アプリケーション ID。
        @param[in]  capability  ケイパビリティ。
    */
    DeliveryCacheFileService(nn::sf::SharedPointer<DeliveryCacheStorageService>&& parent,
        nn::ApplicationId appId, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DeliveryCacheFileService() NN_NOEXCEPT;

public:
    // IDeliveryCacheFileService
    nn::Result Open(const nn::bcat::DirectoryName& dirName, const nn::bcat::FileName& fileName) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT;
    nn::Result GetDigest(nn::sf::Out<nn::bcat::Digest> outDigest) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::sf::SharedPointer<DeliveryCacheStorageService> m_Parent;
    //
    Capability m_Capability;
    //
    nn::ApplicationId m_AppId;
    //
    nn::fs::FileHandle m_Handle;
    FileMeta m_Meta;
    bool m_IsOpened;
};

NN_STATIC_ASSERT(sizeof (DeliveryCacheFileService) <= detail::service::ServiceMemoryManager::DeliveryCacheFileServiceSize);

}}}}
