﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheDirectoryService.sfdl.h>
#include <nn/bcat/detail/service/bcat_Capability.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>

namespace nn { namespace bcat { namespace detail { namespace service {

class DeliveryCacheStorageService;

/*!
    @brief      データ配信キャッシュディレクトリのサービスです。
*/
class DeliveryCacheDirectoryService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  parent      親となるストレージサービス。
        @param[in]  appId       アプリケーション ID。
        @param[in]  capability  ケイパビリティ。
    */
    DeliveryCacheDirectoryService(nn::sf::SharedPointer<DeliveryCacheStorageService>&& parent,
        nn::ApplicationId appId, const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~DeliveryCacheDirectoryService() NN_NOEXCEPT;

public:
    // IDeliveryCacheDirectoryService
    nn::Result Open(const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::DeliveryCacheDirectoryEntry>& outEntries) NN_NOEXCEPT;
    nn::Result GetCount(nn::sf::Out<std::int32_t> outCount) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::sf::SharedPointer<DeliveryCacheStorageService> m_Parent;
    //
    Capability m_Capability;
    //
    nn::ApplicationId m_AppId;
    DirectoryName m_DirName;
    bool m_IsOpened;
    //
    int m_EntryCount;
};

NN_STATIC_ASSERT(sizeof (DeliveryCacheDirectoryService) <= detail::service::ServiceMemoryManager::DeliveryCacheDirectoryServiceSize);

}}}}
