﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/bcat/bcat_Types.h>
#include <nn/bcat/bcat_TypesDebug.h>
#include <nn/bcat/detail/ipc/bcat_IDeliveryCacheProgressService.sfdl.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace bcat { namespace detail { namespace ipc { // NOLINT(whitespace/braces)

class IBcatService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBcatService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBcatService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCache, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithDirectoryName, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const ::nn::bcat::DirectoryName& dirName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelSyncDeliveryCacheRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion, const ::nn::bcat::DirectoryName& dirName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPassphrase, (::nn::ApplicationId appId, const ::nn::sf::InArray<char>& passphrase))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBackgroundDeliveryTask, (::nn::ApplicationId appId, ::std::uint32_t appVersion))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBackgroundDeliveryTask, (::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BlockDeliveryTask, (::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnblockDeliveryTask, (::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateBackgroundDeliveryTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::TaskInfo>& outInfos))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeliveryList, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& buffer, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearDeliveryCacheStorage, (::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPushNotificationLog, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::PushNotificationLog>& outLogs))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBcatService)

        ::nn::Result RequestSyncDeliveryCache(::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCache, (outService));
        }

        ::nn::Result RequestSyncDeliveryCacheWithDirectoryName(::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const ::nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithDirectoryName, (outService, dirName));
        }

        ::nn::Result CancelSyncDeliveryCacheRequest() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelSyncDeliveryCacheRequest);
        }

        ::nn::Result RequestSyncDeliveryCacheWithApplicationId(::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationId, (outService, appId, appVersion));
        }

        ::nn::Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion, const ::nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName, (outService, appId, appVersion, dirName));
        }

        ::nn::Result SetPassphrase(::nn::ApplicationId appId, const ::nn::sf::InArray<char>& passphrase) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPassphrase, (appId, passphrase));
        }

        ::nn::Result RegisterBackgroundDeliveryTask(::nn::ApplicationId appId, ::std::uint32_t appVersion) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBackgroundDeliveryTask, (appId, appVersion));
        }

        ::nn::Result UnregisterBackgroundDeliveryTask(::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterBackgroundDeliveryTask, (appId));
        }

        ::nn::Result BlockDeliveryTask(::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BlockDeliveryTask, (appId));
        }

        ::nn::Result UnblockDeliveryTask(::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnblockDeliveryTask, (appId));
        }

        ::nn::Result EnumerateBackgroundDeliveryTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnumerateBackgroundDeliveryTask, (outCount, outInfos));
        }

        ::nn::Result GetDeliveryList(::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& buffer, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeliveryList, (outSize, buffer, appId));
        }

        ::nn::Result ClearDeliveryCacheStorage(::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearDeliveryCacheStorage, (appId));
        }

        ::nn::Result GetPushNotificationLog(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPushNotificationLog, (outCount, outLogs));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBcatService
    {
    public:
        nn::Result RequestSyncDeliveryCache(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT;
        nn::Result RequestSyncDeliveryCacheWithDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
        nn::Result CancelSyncDeliveryCacheRequest() NN_NOEXCEPT;
        nn::Result RequestSyncDeliveryCacheWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT;
        nn::Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
        nn::Result SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT;
        nn::Result RegisterBackgroundDeliveryTask(nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT;
        nn::Result UnregisterBackgroundDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result EnumerateBackgroundDeliveryTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT;
        nn::Result GetDeliveryList(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result GetPushNotificationLog(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RequestSyncDeliveryCache(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT;
    nn::Result RequestSyncDeliveryCacheWithDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
    nn::Result CancelSyncDeliveryCacheRequest() NN_NOEXCEPT;
    nn::Result RequestSyncDeliveryCacheWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT;
    nn::Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT;
    nn::Result SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT;
    nn::Result RegisterBackgroundDeliveryTask(nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT;
    nn::Result UnregisterBackgroundDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result EnumerateBackgroundDeliveryTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT;
    nn::Result GetDeliveryList(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetPushNotificationLog(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::bcat::detail::ipc::IBcatService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCache, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncDeliveryCache, (outService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithDirectoryName, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const ::nn::bcat::DirectoryName& dirName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncDeliveryCacheWithDirectoryName, (outService, dirName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelSyncDeliveryCacheRequest)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelSyncDeliveryCacheRequest);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationId, (outService, appId, appVersion));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion, const ::nn::bcat::DirectoryName& dirName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName, (outService, appId, appVersion, dirName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPassphrase, (::nn::ApplicationId appId, const ::nn::sf::InArray<char>& passphrase))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPassphrase, (appId, passphrase));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBackgroundDeliveryTask, (::nn::ApplicationId appId, ::std::uint32_t appVersion))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBackgroundDeliveryTask, (appId, appVersion));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBackgroundDeliveryTask, (::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterBackgroundDeliveryTask, (appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlockDeliveryTask, (::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BlockDeliveryTask, (appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnblockDeliveryTask, (::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnblockDeliveryTask, (appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateBackgroundDeliveryTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::TaskInfo>& outInfos))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnumerateBackgroundDeliveryTask, (outCount, outInfos));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeliveryList, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& buffer, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeliveryList, (outSize, buffer, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearDeliveryCacheStorage, (::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearDeliveryCacheStorage, (appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPushNotificationLog, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::PushNotificationLog>& outLogs))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPushNotificationLog, (outCount, outLogs));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::bcat::detail::ipc::IBcatService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::bcat::detail::ipc::IBcatService))

    // nn::Result RequestSyncDeliveryCache(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncDeliveryCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncDeliveryCache)

    // nn::Result RequestSyncDeliveryCacheWithDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncDeliveryCacheWithDirectoryName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dirName, (::nn::bcat::DirectoryName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (dirName))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dirName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncDeliveryCacheWithDirectoryName)

    // nn::Result CancelSyncDeliveryCacheRequest() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelSyncDeliveryCacheRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelSyncDeliveryCacheRequest)

    // nn::Result RequestSyncDeliveryCacheWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncDeliveryCacheWithApplicationId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (appVersion, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appVersion)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncDeliveryCacheWithApplicationId)

    // nn::Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dirName, (::nn::bcat::DirectoryName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appVersion, (::std::uint32_t), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (dirName, appVersion, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dirName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)

    // nn::Result SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPassphrase)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(passphrase, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (passphrase))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(passphrase)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPassphrase)

    // nn::Result RegisterBackgroundDeliveryTask(nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBackgroundDeliveryTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (appVersion, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appVersion)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBackgroundDeliveryTask)

    // nn::Result UnregisterBackgroundDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterBackgroundDeliveryTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterBackgroundDeliveryTask)

    // nn::Result BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BlockDeliveryTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BlockDeliveryTask)

    // nn::Result UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnblockDeliveryTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnblockDeliveryTask)

    // nn::Result EnumerateBackgroundDeliveryTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnumerateBackgroundDeliveryTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outInfos, 0, (const ::nn::sf::OutArray<::nn::bcat::TaskInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outInfos))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfos)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnumerateBackgroundDeliveryTask)

    // nn::Result GetDeliveryList(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeliveryList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeliveryList)

    // nn::Result ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearDeliveryCacheStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearDeliveryCacheStorage)

    // nn::Result GetPushNotificationLog(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPushNotificationLog)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outLogs, 0, (const ::nn::sf::OutArray<::nn::bcat::PushNotificationLog>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outLogs))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLogs)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPushNotificationLog)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bcat::DirectoryName), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bcat::TaskInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bcat::PushNotificationLog), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::bcat::detail::ipc::IBcatService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::bcat::detail::ipc::IBcatService))

    // nn::Result RequestSyncDeliveryCache(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCache, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncDeliveryCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncDeliveryCache)
    }

    // nn::Result RequestSyncDeliveryCacheWithDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithDirectoryName, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const ::nn::bcat::DirectoryName& dirName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncDeliveryCacheWithDirectoryName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dirName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncDeliveryCacheWithDirectoryName)
    }

    // nn::Result CancelSyncDeliveryCacheRequest() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelSyncDeliveryCacheRequest)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelSyncDeliveryCacheRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelSyncDeliveryCacheRequest)
    }

    // nn::Result RequestSyncDeliveryCacheWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationId, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncDeliveryCacheWithApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appVersion)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncDeliveryCacheWithApplicationId)
    }

    // nn::Result RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, ::nn::ApplicationId appId, ::std::uint32_t appVersion, const ::nn::bcat::DirectoryName& dirName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dirName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)
    }

    // nn::Result SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPassphrase, (::nn::ApplicationId appId, const ::nn::sf::InArray<char>& passphrase))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPassphrase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(passphrase)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPassphrase)
    }

    // nn::Result RegisterBackgroundDeliveryTask(nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBackgroundDeliveryTask, (::nn::ApplicationId appId, ::std::uint32_t appVersion))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBackgroundDeliveryTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appVersion)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBackgroundDeliveryTask)
    }

    // nn::Result UnregisterBackgroundDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterBackgroundDeliveryTask, (::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterBackgroundDeliveryTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterBackgroundDeliveryTask)
    }

    // nn::Result BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlockDeliveryTask, (::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BlockDeliveryTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BlockDeliveryTask)
    }

    // nn::Result UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnblockDeliveryTask, (::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnblockDeliveryTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnblockDeliveryTask)
    }

    // nn::Result EnumerateBackgroundDeliveryTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnumerateBackgroundDeliveryTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::TaskInfo>& outInfos))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnumerateBackgroundDeliveryTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfos)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnumerateBackgroundDeliveryTask)
    }

    // nn::Result GetDeliveryList(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeliveryList, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& buffer, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeliveryList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeliveryList)
    }

    // nn::Result ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearDeliveryCacheStorage, (::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearDeliveryCacheStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearDeliveryCacheStorage)
    }

    // nn::Result GetPushNotificationLog(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPushNotificationLog, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::bcat::PushNotificationLog>& outLogs))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPushNotificationLog)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLogs)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPushNotificationLog)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::bcat::detail::ipc::IBcatService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::bcat::detail::ipc::IBcatService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncDeliveryCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncDeliveryCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncDeliveryCacheWithDirectoryName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncDeliveryCacheWithDirectoryName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dirName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelSyncDeliveryCacheRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelSyncDeliveryCacheRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncDeliveryCacheWithApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncDeliveryCacheWithApplicationId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::bcat::detail::ipc::IDeliveryCacheProgressService>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dirName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPassphrase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(passphrase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPassphrase)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(passphrase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBackgroundDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBackgroundDeliveryTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterBackgroundDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterBackgroundDeliveryTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BlockDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BlockDeliveryTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnblockDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnblockDeliveryTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnumerateBackgroundDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outInfos)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnumerateBackgroundDeliveryTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outInfos)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeliveryList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeliveryList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearDeliveryCacheStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearDeliveryCacheStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPushNotificationLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outLogs)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPushNotificationLog)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outLogs)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncDeliveryCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncDeliveryCacheWithDirectoryName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelSyncDeliveryCacheRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncDeliveryCacheWithApplicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPassphrase)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBackgroundDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterBackgroundDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BlockDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnblockDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnumerateBackgroundDeliveryTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeliveryList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearDeliveryCacheStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPushNotificationLog)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::bcat::detail::ipc::IBcatService))
