﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace bcat { namespace detail {

/*!
    @brief      IPC のエラーハンドリングを行います。

    @param[in]  result  処理結果。

    @return     引数に指定した処理結果。

    @details
                本関数は、ファイル壊れを検知した時 ABORT します。@n
                ABORT しなかった場合、本関数は引数に指定した処理結果をそのまま返します。
*/
nn::Result HandleError(nn::Result result) NN_NOEXCEPT;

}}}

/*!
    @brief      IPC 用の NN_RESULT_DO です。
*/
#define NN_DETAIL_BCAT_IPC_RESULT_DO(exp) NN_RESULT_DO(detail::HandleError(exp))
