﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/bcat_Types.h>

namespace nn { namespace bcat {

/*!
    @brief      システムが管理するタスクの最大数です。
*/
const int TaskCountMax = 16;

/*!
    @brief      タスクの状態です。
*/
enum TaskStatus : char
{
    TaskStatus_Empty    = 0,   //!< 状態なし。
    TaskStatus_Runnable = 'U', //!< 実行可能状態。
    TaskStatus_Running  = 'R', //!< 実行状態。
    TaskStatus_Wait     = 'W', //!< 待機状態。
    TaskStatus_Done     = 'D', //!< 完了状態。
    TaskStatus_Error    = 'E'  //!< エラーによる一時停止状態。
};

/*!
    @brief      NPNS トピックの購読状態です。
*/
enum SubscriptionStatus : char
{
    SubscriptionStatus_Empty      = 0,   //!< 状態なし。（未購読）
    SubscriptionStatus_Subscribed = 'S', //!< 購読済み。
    SubscriptionStatus_Error      = 'E'  //!< 購読に失敗した状態。
};

}}
