﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace audio { namespace detail { // NOLINT(whitespace/braces)

class IAudioDevice;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAudioDevice, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAudioDevice)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioDeviceName, (const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolume, (const ::nn::sf::InBuffer& nameIn, float volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolume, (const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceName, (const ::nn::sf::OutBuffer& outDeviceName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveChannelCount, (::nn::sf::Out<::std::int32_t> channelCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioDeviceNameAuto, (const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolumeAuto, (const ::nn::sf::InBuffer& nameIn, float volume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolumeAuto, (const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceNameAuto, (const ::nn::sf::OutBuffer& outDeviceName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceInputEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceOutputEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioSystemMasterVolumeSetting, (::nn::sf::Out<float> volume, const ::nn::sf::InBuffer& name))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAudioDevice)

        ::nn::Result ListAudioDeviceName(const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAudioDeviceName, (outDeviceNames, amountRet));
        }

        ::nn::Result SetAudioDeviceOutputVolume(const ::nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolume, (nameIn, volume));
        }

        ::nn::Result GetAudioDeviceOutputVolume(const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolume, (nameIn, pOutVolume));
        }

        ::nn::Result GetActiveAudioDeviceName(const ::nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceName, (outDeviceName));
        }

        ::nn::Result QueryAudioDeviceSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAudioDeviceSystemEvent, (handle));
        }

        ::nn::Result GetActiveChannelCount(::nn::sf::Out<::std::int32_t> channelCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActiveChannelCount, (channelCount));
        }

        ::nn::Result ListAudioDeviceNameAuto(const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAudioDeviceNameAuto, (outDeviceNames, amountRet));
        }

        ::nn::Result SetAudioDeviceOutputVolumeAuto(const ::nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolumeAuto, (nameIn, volume));
        }

        ::nn::Result GetAudioDeviceOutputVolumeAuto(const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolumeAuto, (nameIn, pOutVolume));
        }

        ::nn::Result GetActiveAudioDeviceNameAuto(const ::nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceNameAuto, (outDeviceName));
        }

        ::nn::Result QueryAudioDeviceInputEvent(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAudioDeviceInputEvent, (handle));
        }

        ::nn::Result QueryAudioDeviceOutputEvent(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryAudioDeviceOutputEvent, (handle));
        }

        ::nn::Result GetAudioSystemMasterVolumeSetting(::nn::sf::Out<float> volume, const ::nn::sf::InBuffer& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAudioSystemMasterVolumeSetting, (volume, name));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAudioDevice
    {
    public:
        nn::Result ListAudioDeviceName(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
        nn::Result SetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT;
        nn::Result GetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT;
        nn::Result GetActiveAudioDeviceName(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT;
        nn::Result QueryAudioDeviceSystemEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result GetActiveChannelCount(nn::sf::Out<std::int32_t> channelCount) NN_NOEXCEPT;
        nn::Result ListAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
        nn::Result SetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT;
        nn::Result GetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT;
        nn::Result GetActiveAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT;
        nn::Result QueryAudioDeviceInputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result QueryAudioDeviceOutputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result GetAudioSystemMasterVolumeSetting(nn::sf::Out<float> volume, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ListAudioDeviceName(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
    nn::Result SetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT;
    nn::Result GetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT;
    nn::Result GetActiveAudioDeviceName(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT;
    nn::Result QueryAudioDeviceSystemEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetActiveChannelCount(nn::sf::Out<std::int32_t> channelCount) NN_NOEXCEPT;
    nn::Result ListAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT;
    nn::Result SetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT;
    nn::Result GetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT;
    nn::Result GetActiveAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT;
    nn::Result QueryAudioDeviceInputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result QueryAudioDeviceOutputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result GetAudioSystemMasterVolumeSetting(nn::sf::Out<float> volume, const nn::sf::InBuffer& name) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::audio::detail::IAudioDevice))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioDeviceName, (const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAudioDeviceName, (outDeviceNames, amountRet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolume, (const ::nn::sf::InBuffer& nameIn, float volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAudioDeviceOutputVolume, (nameIn, volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolume, (const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioDeviceOutputVolume, (nameIn, pOutVolume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceName, (const ::nn::sf::OutBuffer& outDeviceName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActiveAudioDeviceName, (outDeviceName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAudioDeviceSystemEvent, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveChannelCount, (::nn::sf::Out<::std::int32_t> channelCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActiveChannelCount, (channelCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioDeviceNameAuto, (const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAudioDeviceNameAuto, (outDeviceNames, amountRet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolumeAuto, (const ::nn::sf::InBuffer& nameIn, float volume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAudioDeviceOutputVolumeAuto, (nameIn, volume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolumeAuto, (const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioDeviceOutputVolumeAuto, (nameIn, pOutVolume));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceNameAuto, (const ::nn::sf::OutBuffer& outDeviceName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActiveAudioDeviceNameAuto, (outDeviceName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceInputEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAudioDeviceInputEvent, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceOutputEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryAudioDeviceOutputEvent, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioSystemMasterVolumeSetting, (::nn::sf::Out<float> volume, const ::nn::sf::InBuffer& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAudioSystemMasterVolumeSetting, (volume, name));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::audio::detail::IAudioDevice>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::audio::detail::IAudioDevice))

    // nn::Result ListAudioDeviceName(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAudioDeviceName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDeviceNames, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outDeviceNames))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(amountRet, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (amountRet))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDeviceNames), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(amountRet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAudioDeviceName)

    // nn::Result SetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAudioDeviceOutputVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (nameIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(volume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAudioDeviceOutputVolume)

    // nn::Result GetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioDeviceOutputVolume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (nameIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutVolume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutVolume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutVolume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioDeviceOutputVolume)

    // nn::Result GetActiveAudioDeviceName(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActiveAudioDeviceName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDeviceName, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outDeviceName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDeviceName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActiveAudioDeviceName)

    // nn::Result QueryAudioDeviceSystemEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAudioDeviceSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAudioDeviceSystemEvent)

    // nn::Result GetActiveChannelCount(nn::sf::Out<std::int32_t> channelCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActiveChannelCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(channelCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (channelCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channelCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActiveChannelCount)

    // nn::Result ListAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAudioDeviceNameAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDeviceNames, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outDeviceNames))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(amountRet, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (amountRet))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDeviceNames), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(amountRet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAudioDeviceNameAuto)

    // nn::Result SetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAudioDeviceOutputVolumeAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (nameIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(volume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAudioDeviceOutputVolumeAuto)

    // nn::Result GetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioDeviceOutputVolumeAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (nameIn))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutVolume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutVolume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutVolume)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioDeviceOutputVolumeAuto)

    // nn::Result GetActiveAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActiveAudioDeviceNameAuto)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDeviceName, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outDeviceName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDeviceName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActiveAudioDeviceNameAuto)

    // nn::Result QueryAudioDeviceInputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAudioDeviceInputEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAudioDeviceInputEvent)

    // nn::Result QueryAudioDeviceOutputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryAudioDeviceOutputEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryAudioDeviceOutputEvent)

    // nn::Result GetAudioSystemMasterVolumeSetting(nn::sf::Out<float> volume, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAudioSystemMasterVolumeSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(volume, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (volume))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(volume), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAudioSystemMasterVolumeSetting)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::audio::detail::IAudioDevice, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::audio::detail::IAudioDevice))

    // nn::Result ListAudioDeviceName(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioDeviceName, (const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAudioDeviceName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDeviceNames)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(amountRet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAudioDeviceName)
    }

    // nn::Result SetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolume, (const ::nn::sf::InBuffer& nameIn, float volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAudioDeviceOutputVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAudioDeviceOutputVolume)
    }

    // nn::Result GetAudioDeviceOutputVolume(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolume, (const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioDeviceOutputVolume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutVolume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioDeviceOutputVolume)
    }

    // nn::Result GetActiveAudioDeviceName(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceName, (const ::nn::sf::OutBuffer& outDeviceName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActiveAudioDeviceName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDeviceName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActiveAudioDeviceName)
    }

    // nn::Result QueryAudioDeviceSystemEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAudioDeviceSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAudioDeviceSystemEvent)
    }

    // nn::Result GetActiveChannelCount(nn::sf::Out<std::int32_t> channelCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveChannelCount, (::nn::sf::Out<::std::int32_t> channelCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActiveChannelCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channelCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActiveChannelCount)
    }

    // nn::Result ListAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceNames, nn::sf::Out<std::int32_t> amountRet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAudioDeviceNameAuto, (const ::nn::sf::OutBuffer& outDeviceNames, ::nn::sf::Out<::std::int32_t> amountRet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAudioDeviceNameAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDeviceNames)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(amountRet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAudioDeviceNameAuto)
    }

    // nn::Result SetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, float volume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAudioDeviceOutputVolumeAuto, (const ::nn::sf::InBuffer& nameIn, float volume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAudioDeviceOutputVolumeAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAudioDeviceOutputVolumeAuto)
    }

    // nn::Result GetAudioDeviceOutputVolumeAuto(const nn::sf::InBuffer& nameIn, nn::sf::Out<float> pOutVolume) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioDeviceOutputVolumeAuto, (const ::nn::sf::InBuffer& nameIn, ::nn::sf::Out<float> pOutVolume))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioDeviceOutputVolumeAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutVolume)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioDeviceOutputVolumeAuto)
    }

    // nn::Result GetActiveAudioDeviceNameAuto(const nn::sf::OutBuffer& outDeviceName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActiveAudioDeviceNameAuto, (const ::nn::sf::OutBuffer& outDeviceName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActiveAudioDeviceNameAuto)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDeviceName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActiveAudioDeviceNameAuto)
    }

    // nn::Result QueryAudioDeviceInputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceInputEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAudioDeviceInputEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAudioDeviceInputEvent)
    }

    // nn::Result QueryAudioDeviceOutputEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryAudioDeviceOutputEvent, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryAudioDeviceOutputEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryAudioDeviceOutputEvent)
    }

    // nn::Result GetAudioSystemMasterVolumeSetting(nn::sf::Out<float> volume, const nn::sf::InBuffer& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAudioSystemMasterVolumeSetting, (::nn::sf::Out<float> volume, const ::nn::sf::InBuffer& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAudioSystemMasterVolumeSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(volume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAudioSystemMasterVolumeSetting)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::audio::detail::IAudioDevice>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::audio::detail::IAudioDevice))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAudioDeviceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDeviceNames)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAudioDeviceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDeviceNames),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(amountRet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAudioDeviceOutputVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAudioDeviceOutputVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioDeviceOutputVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioDeviceOutputVolume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActiveAudioDeviceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDeviceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActiveAudioDeviceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDeviceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAudioDeviceSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAudioDeviceSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActiveChannelCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActiveChannelCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(channelCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAudioDeviceNameAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDeviceNames)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAudioDeviceNameAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDeviceNames),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(amountRet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAudioDeviceOutputVolumeAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAudioDeviceOutputVolumeAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(volume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioDeviceOutputVolumeAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameIn)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioDeviceOutputVolumeAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActiveAudioDeviceNameAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDeviceName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActiveAudioDeviceNameAuto)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDeviceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAudioDeviceInputEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAudioDeviceInputEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryAudioDeviceOutputEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryAudioDeviceOutputEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAudioSystemMasterVolumeSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAudioSystemMasterVolumeSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(volume),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAudioDeviceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAudioDeviceOutputVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioDeviceOutputVolume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActiveAudioDeviceName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAudioDeviceSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActiveChannelCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAudioDeviceNameAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAudioDeviceOutputVolumeAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioDeviceOutputVolumeAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActiveAudioDeviceNameAuto)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAudioDeviceInputEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryAudioDeviceOutputEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAudioSystemMasterVolumeSetting)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::audio::detail::IAudioDevice))
