﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      applet モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_APPLET_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(applet, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_APPLET_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(applet, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(applet, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(applet, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(applet, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_APPLET_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(applet, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(applet, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(applet, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(applet, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_APPLET_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(applet, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_APPLET_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(applet, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_APPLET_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(applet, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_APPLET_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Trace, 0, format, args)
#define NN_DETAIL_APPLET_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Trace, 1, format, args)
#define NN_DETAIL_APPLET_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Trace, 2, format, args)
#define NN_DETAIL_APPLET_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Trace, 3, format, args)

#define NN_DETAIL_APPLET_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Info, 0, format, args)
#define NN_DETAIL_APPLET_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Info, 1, format, args)
#define NN_DETAIL_APPLET_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Info, 2, format, args)
#define NN_DETAIL_APPLET_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Info, 3, format, args)

#define NN_DETAIL_APPLET_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Warn, 0, format, args)
#define NN_DETAIL_APPLET_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Warn, 1, format, args)
#define NN_DETAIL_APPLET_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Warn, 2, format, args)
#define NN_DETAIL_APPLET_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Warn, 3, format, args)

#define NN_DETAIL_APPLET_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Error, 0, format, args)
#define NN_DETAIL_APPLET_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Error, 1, format, args)
#define NN_DETAIL_APPLET_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Error, 2, format, args)
#define NN_DETAIL_APPLET_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Error, 3, format, args)

#define NN_DETAIL_APPLET_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Fatal, 0, format, args)
#define NN_DETAIL_APPLET_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Fatal, 1, format, args)
#define NN_DETAIL_APPLET_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Fatal, 2, format, args)
#define NN_DETAIL_APPLET_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(applet, Fatal, 3, format, args)

#define NN_DETAIL_APPLET_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(applet, Trace, 0, text, length)
#define NN_DETAIL_APPLET_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Trace, 1, text, length)
#define NN_DETAIL_APPLET_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Trace, 2, text, length)
#define NN_DETAIL_APPLET_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Trace, 3, text, length)

#define NN_DETAIL_APPLET_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(applet, Info, 0, text, length)
#define NN_DETAIL_APPLET_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(applet, Info, 1, text, length)
#define NN_DETAIL_APPLET_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(applet, Info, 2, text, length)
#define NN_DETAIL_APPLET_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(applet, Info, 3, text, length)

#define NN_DETAIL_APPLET_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(applet, Warn, 0, text, length)
#define NN_DETAIL_APPLET_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(applet, Warn, 1, text, length)
#define NN_DETAIL_APPLET_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(applet, Warn, 2, text, length)
#define NN_DETAIL_APPLET_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(applet, Warn, 3, text, length)

#define NN_DETAIL_APPLET_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(applet, Error, 0, text, length)
#define NN_DETAIL_APPLET_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Error, 1, text, length)
#define NN_DETAIL_APPLET_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Error, 2, text, length)
#define NN_DETAIL_APPLET_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Error, 3, text, length)

#define NN_DETAIL_APPLET_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(applet, Fatal, 0, text, length)
#define NN_DETAIL_APPLET_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Fatal, 1, text, length)
#define NN_DETAIL_APPLET_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Fatal, 2, text, length)
#define NN_DETAIL_APPLET_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(applet, Fatal, 3, text, length)
