﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Storage.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/am/am_Shim.h>
#include <nn/applet/applet_LibraryApplet.h>
#include <nn/vi/vi_IndirectProducer.private.h>

namespace nn { namespace applet {

struct LibraryAppletSelfHandle
{
    void* _p;

    friend bool operator==(const LibraryAppletSelfHandle& lhs, const LibraryAppletSelfHandle& rhs) NN_NOEXCEPT
    {
        return lhs._p == rhs._p;
    }

    friend bool operator!=(const LibraryAppletSelfHandle& lhs, const LibraryAppletSelfHandle& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }
};

const LibraryAppletSelfHandle InvalidLibraryAppletSelfHandle = {};

LibraryAppletSelfHandle CreateLibraryAppletSelf(sf::SharedPointer<am::service::ILibraryAppletSelfAccessor> p, sf::SharedPointer<am::service::IProcessWindingController> pWindingController) NN_NOEXCEPT;
void CloseLibraryAppletSelf(LibraryAppletSelfHandle selfHandle) NN_NOEXCEPT;

bool TryPopFromInChannel(StorageHandle* pOut, LibraryAppletSelfHandle selfHandle) NN_NOEXCEPT;
bool TryPopFromInteractiveInChannel(StorageHandle* pOut, LibraryAppletSelfHandle selfHandle) NN_NOEXCEPT;
os::SystemEventType* GetPopFromInteractiveInChannelEvent(LibraryAppletSelfHandle selfHandle) NN_NOEXCEPT;
void PushToOutChannel(LibraryAppletSelfHandle selfHandle, StorageHandle storageHandle) NN_NOEXCEPT;
void PushToInteractiveOutChannel(LibraryAppletSelfHandle selfHandle, StorageHandle storageHandle) NN_NOEXCEPT;
void PushToContextStack(LibraryAppletSelfHandle selfHandle, StorageHandle storageHandle) NN_NOEXCEPT;
bool TryPopFromContextStack(StorageHandle* pOut, LibraryAppletSelfHandle selfHandle) NN_NOEXCEPT;
void UnpopToInChannel(LibraryAppletSelfHandle selfHandle, StorageHandle storageHandle) NN_NOEXCEPT;
Result MapHandleStorage(void** pOutAddress, size_t* pOutSize, StorageHandle storageHandle) NN_NOEXCEPT;
void UnmapHandleStorage(StorageHandle storageHandle) NN_NOEXCEPT;

typedef bool (*StartLibraryAppletHook)(sf::SharedPointer<am::service::ILibraryAppletAccessor> p, AppletId appletId, applet::LibraryAppletMode libraryAppletMode, void* userArgument);
void SetStartLibraryAppletHook(StartLibraryAppletHook hook) NN_NOEXCEPT;

LibraryAppletHandle CreateLibraryAppletHandleOnUnwinding(sf::SharedPointer<am::service::ILibraryAppletAccessor> p) NN_NOEXCEPT;

void SetCreatingSelfLibraryApplet(bool isCreatingSelfLibraryApplet) NN_NOEXCEPT;

vi::IndirectProducerHandleType GetIndirectLayerProducerHandle(LibraryAppletSelfHandle selfHandle) NN_NOEXCEPT;

}}
