﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_Types.h>

namespace nn { namespace applet {

//! @name   キーボード配列に関する機能
//! @{

/**
    @brief  自プログラムが要望するキーボード配列を指定します。

    @param[in] layout   キーボード配列を示す値

    @details
     自プログラムが要望するキーボード配列を指定します。
     この指定がどう影響するかは本体機能の仕様に依存します。

     layout の具体的な値に関しては、本 API では関与しません。

*/
void SetDesirableKeyboardLayout(Bit32 layout) NN_NOEXCEPT;


/**
    @brief  自プログラムに要望されているキーボード配列を取得します。

    @param[out] pOutLayout  取得したキーボード配列を示す値の格納先アドレス

    @return 取得できたか否かを bool で返します。

    @details
     自プログラムに要望されているキーボード配列を取得します。
     具体的にどの設定が反映されるかは、システムの実装に依存します。

     本 API が true を返した場合、pOutLayout が指す場所にキーボード配列情報が
     格納されます。false を返した場合は、要望されているキーボード配列情報は
     未定であり、pOutLayout が指す場所には何も格納されません。

*/
bool GetDesirableKeyboardLayout(Bit32* pOutLayout) NN_NOEXCEPT;


//! @}

}}
