﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      apm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_APM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(apm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_APM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_APM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_APM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_APM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(apm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_APM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(apm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_APM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(apm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_APM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(apm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_APM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(apm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_APM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(apm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_APM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(apm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_APM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(apm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_APM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(apm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_APM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_APM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_APM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_APM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(apm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_APM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_APM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_APM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(apm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_APM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Trace, 0, format, args)
#define NN_DETAIL_APM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Trace, 1, format, args)
#define NN_DETAIL_APM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Trace, 2, format, args)
#define NN_DETAIL_APM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Trace, 3, format, args)

#define NN_DETAIL_APM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Info, 0, format, args)
#define NN_DETAIL_APM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Info, 1, format, args)
#define NN_DETAIL_APM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Info, 2, format, args)
#define NN_DETAIL_APM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Info, 3, format, args)

#define NN_DETAIL_APM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Warn, 0, format, args)
#define NN_DETAIL_APM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Warn, 1, format, args)
#define NN_DETAIL_APM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Warn, 2, format, args)
#define NN_DETAIL_APM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Warn, 3, format, args)

#define NN_DETAIL_APM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Error, 0, format, args)
#define NN_DETAIL_APM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Error, 1, format, args)
#define NN_DETAIL_APM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Error, 2, format, args)
#define NN_DETAIL_APM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Error, 3, format, args)

#define NN_DETAIL_APM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Fatal, 0, format, args)
#define NN_DETAIL_APM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Fatal, 1, format, args)
#define NN_DETAIL_APM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Fatal, 2, format, args)
#define NN_DETAIL_APM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(apm, Fatal, 3, format, args)

#define NN_DETAIL_APM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(apm, Trace, 0, text, length)
#define NN_DETAIL_APM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Trace, 1, text, length)
#define NN_DETAIL_APM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Trace, 2, text, length)
#define NN_DETAIL_APM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Trace, 3, text, length)

#define NN_DETAIL_APM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(apm, Info, 0, text, length)
#define NN_DETAIL_APM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(apm, Info, 1, text, length)
#define NN_DETAIL_APM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(apm, Info, 2, text, length)
#define NN_DETAIL_APM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(apm, Info, 3, text, length)

#define NN_DETAIL_APM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(apm, Warn, 0, text, length)
#define NN_DETAIL_APM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(apm, Warn, 1, text, length)
#define NN_DETAIL_APM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(apm, Warn, 2, text, length)
#define NN_DETAIL_APM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(apm, Warn, 3, text, length)

#define NN_DETAIL_APM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(apm, Error, 0, text, length)
#define NN_DETAIL_APM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Error, 1, text, length)
#define NN_DETAIL_APM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Error, 2, text, length)
#define NN_DETAIL_APM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Error, 3, text, length)

#define NN_DETAIL_APM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(apm, Fatal, 0, text, length)
#define NN_DETAIL_APM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Fatal, 1, text, length)
#define NN_DETAIL_APM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Fatal, 2, text, length)
#define NN_DETAIL_APM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(apm, Fatal, 3, text, length)
