﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>

namespace nn{ namespace am{ namespace service{ namespace display{
    namespace detail{

        class SystemSharedLowLayer
        {
        public:
            SystemSharedLowLayer() NN_NOEXCEPT;

            bool IsInitialized() const NN_NOEXCEPT;

            nn::Result Initialize(nn::vi::fbshare::SharedBufferHandle hBuffer, bool isOpaque, uint32_t zOrder) NN_NOEXCEPT;
            void Finalize() NN_NOEXCEPT;

            nn::vi::LayerId GetLayerId() const NN_NOEXCEPT;
            nn::os::SystemEventType* GetSynchronizedEvent() NN_NOEXCEPT;

        private:
            nn::vi::LayerId m_LayerId;
            nn::os::SystemEventType m_SynchronizedEvent;
            nn::vi::fbshare::SharedBufferHandle m_BufferHandle;
        };

    }
}}}}
