﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/am/service/display/am_IntegratedDisplayManager.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    class DisplayWorker
    {
    public:
        static const size_t StackSize = 8 * 1024;
        static const uintptr_t MultiWaitSlotReserved = 2;
        static const uintptr_t MultiWaitSlotCount = 32;

    private:
        struct MultiWaitSlot
        {
            nn::os::MultiWaitHolderType* pHolder;
            void (*function)(nn::os::MultiWaitHolderType*, void*);
            void* userPtr;
        };

    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void Start() NN_NOEXCEPT;
        void Stop() NN_NOEXCEPT;

        // void function(nn::os::MultiWaitHolderType* pHolder, void* userPtr)
        nn::os::MultiWaitHolderType* LinkMultiWait(nn::os::MultiWaitHolderType* pHolder, void (*function)(nn::os::MultiWaitHolderType*, void*), void* userPtr) NN_NOEXCEPT;
        void UnlinkMultiWait(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;

    private:
        void UnlinkMultiWaitImpl(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;
        static void ThreadFunctionImpl(void* arg) NN_NOEXCEPT;
        void ThreadFunction() NN_NOEXCEPT;

    private:
        NN_ALIGNAS(nn::os::ThreadStackAlignment) char m_ThreadStack[StackSize];
        nn::os::ThreadType m_Thread;

        nn::os::MultiWaitType m_MultiWait;

        // reserved
        nn::os::EventType m_ExitRequestEvent;
        nn::os::MultiWaitHolderType m_ExitRequestHolder;

        MultiWaitSlot m_SlotList[MultiWaitSlotCount];
    };

}}}}
