﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/am/service/display/am_IntegratedDisplayParameter.h>
#include <nn/am/service/am_CaptureBufferIndex.h>
#include <nn/vi/vi_LayerStack.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>

namespace nn{ namespace am{ namespace service{ namespace display{

    class DisplayCaptureBufferOperation
    {
    public:
        static void Initialize(const IntegratedDisplayParameter& param, nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT;
        static void Finalize() NN_NOEXCEPT;

        // 指定したバッファに画面キャプチャする。
        static void CaptureDisplay(CaptureBufferIndex dst, nn::vi::LayerStack layerStack, bool isScreenshotPermitted, bool isCopyrightRequired, nn::TimeSpan timeout) NN_NOEXCEPT;

        // 指定したバッファに共有バッファの画像をコピーする。
        static void CaptureSharedTexture(CaptureBufferIndex dst, int srcTextureIndex, bool isScreenshotPermitted, bool isCopyrightRequired, nn::TimeSpan timeout) NN_NOEXCEPT;

        // バッファ間で画像をコピーする。
        static void CopyBuffer(CaptureBufferIndex dst, CaptureBufferIndex src, nn::TimeSpan timeout) NN_NOEXCEPT;

        // バッファを塗りつぶす
        static void FillBuffer(CaptureBufferIndex dst, uint32_t color, bool isScreenshotPermitted, bool isCopyrightRequired) NN_NOEXCEPT;

        static nn::Result ReadBuffer(void* buffer, size_t bufferSize, CaptureBufferIndex src) NN_NOEXCEPT;

        // フェードイン・アウト中に撮影を許可するか
        // SA, LA がキャプチャバッファを取得する際にはこの値が渡される。
        static bool IsBufferScreenshotPermittedForFader(CaptureBufferIndex index) NN_NOEXCEPT;
    };



}}}}
