﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace am { namespace service {

enum StuckCheckKind
{
    #define NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(value, kind) StuckCheckKind_##kind = value,

    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(  0, am_Unknown)

    // 001-099: am
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(  1, am)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 11, am_WindowSystem_Run)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 12, am_WindowSystem_ChangeWindowTransiter)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 13, am_WindowSystem_NotifyEvent)

    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 30, am_Event_Loop)

    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 40, am_Ipc_Loop)

    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 90, am_SystemReport)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 91, am_SystemReport_ReportControllerUsage)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 92, am_SystemReport_ReportControllerRegistration)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 93, am_SystemReport_ReportAudioVolumeUpdate)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 94, am_SystemReport_ReportAudioOutputTargetUpdate)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND( 95, am_SystemReport_UpdateErrorReportControllerUsage)

    // 100-119: audio
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(100, audio)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(101, audio_SuspendAudio)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(102, audio_ResumeAudio)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(103, audio_SetVolume)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(104, audio_RegisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(105, audio_UnregisterAruid)

    // 120-159: hid
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(120, hid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(121, hid_RegisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(122, hid_UnregisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(123, hid_EnableAppletToGetInput)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(124, hid_SetAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(125, hid_SetAruidValidForVibration)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(126, hid_EnableAppletToGetSixAxisSensor)

    // 160-199: vi_layer
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(160, vi_layer)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(161, vi_layer_Initialize)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(162, vi_layer_AddToLayerStack)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(163, vi_layer_RemoveFromLayerStack)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(164, vi_layer_SetLayerZ)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(165, vi_layer_CreateDisplayLayer)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(166, vi_layer_DestroyDisplayLayer)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(167, vi_layer_SetDisplayLayerVisibility)

    // 200-219: capsrv
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(200, capsrv)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(201, capsrv_CaptureRawImage)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(202, capsrv_RegisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(203, capsrv_UnregisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(204, capsrv_RequestTakingScreenShot)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(205, capsrv_NotifyTakingScreenShotRefused)

    // 220-259: omm
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(220, omm)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(221, omm_Get)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(222, omm_FadeOutDisplay)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(223, omm_DisableAudioVisual)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(224, omm_EnableAudioVisual)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(225, omm_FadeInDisplay)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(226, omm_NotifyCecSettingsChanged)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(227, omm_NotifyHdcpApplicationExecutionStarted)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(228, omm_NotifyHdcpApplicationExecutionFinished)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(229, omm_NotifyHdcpApplicationDrawingStarted)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(230, omm_NotifyHdcpApplicationDrawingFinished)

    // 260-289: ns
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(260, ns)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(261, ns_Get)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(262, ns_PrepareShutdown)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(263, ns_TerminateApplication)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(264, ns_TerminateLibraryApplet)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(265, ns_LaunchLibraryApplet)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(266, ns_LaunchSystemApplet)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(267, ns_LaunchOverlayApplet)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(268, ns_LaunchApplication)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(269, ns_PrepareShutdownForSystemUpdate)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(270, ns_BoostSystemMemoryResourceLimit)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(271, ns_EnableApplicationCrashReport)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(272, ns_GetApplicationMainProgramIndex)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(273, ns_GetApplicationLaunchInfo)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(274, ns_GetAcquireApplicationLaunchInfo)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(275, ns_GetApplicationControlProperty)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(276, ns_GetApplicationTerminateResult)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(277, ns_EnableApplicationAllThreadDumpOnCrash)

    // 290-299: arp
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(290, arp)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(291, arp_GetApplicationProperty)

    // 300-320: application
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(300, application)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(301, application_EnsureSaveData)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(302, application_GetDesiredLanguage)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(303, application_SetTerminateResult)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(304, application_GetDisplayVersion)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(305, application_GetPseudoDeviceId)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(306, application_ExtendSaveData)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(307, application_GetSaveDataSize)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(308, application_EnsureCacheStorage)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(309, application_QueryApplicationPlayStatistics)

    // 320-339: gpu_error
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(320, gpu_error)

    // 340-359: gpu_scheduler
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(340, gpu_scheduler)

    // 360-379: spsm
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(360, spsm)

    // 380-399: irsensor
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(380, irsensor)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(381, irsensor_RegisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(382, irsensor_UnregisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(383, irsensor_EnableAppletToGetInput)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(384, irsensor_SetAruid)

    // 400-420: grc
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(400, grc)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(401, grc_CreateContinuousRecorder)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(402, grc_StartRecording)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(403, grc_StopRecording)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(404, grc_StartFlush)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(405, grc_CancelFlush)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(406, grc_ResetFlushTime)

    // 420-429: btm
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(420, btm)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(421, btm_EnableSlotSaving)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(422, btm_RegisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(423, btm_UnregisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(424, btm_SetAruid)

    // 430-449: lbl
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(430, lbl)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(431, lbl_EnableVrMode)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(432, lbl_DisableVrMode)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(433, lbl_GetAmbientLightSensorValue)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(434, lbl_IsAmbientLightSensorAvailable)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(435, lbl_SwitchBacklightOff)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(436, lbl_SwitchBacklightOn)

    // 450-469: hidbus
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(450, hidbus)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(451, hidbus_RegisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(452, hidbus_UnregisterAruid)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(453, hidbus_SetAruid)

    // 470-479: account
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(470, account)
    NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND(471, account_ListOpenUsers)

    #undef NN_AM_SERVICE_DETAIL_DEFINE_STUCK_CHECK_KIND
};

}}}

#define NN_AM_SERVICE_DETAIL_GET_STUCK_CHECK_KIND(kind) ::nn::am::service::StuckCheckKind_##kind
