﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Tick.h>

namespace nn { namespace am { namespace service {

struct MonitorHolder;

class MonitorHandler
{
public:
    virtual void OnExpired() NN_NOEXCEPT = 0;
protected:
    ~MonitorHandler() NN_NOEXCEPT
    {
    }
};

void RunMonitor() NN_NOEXCEPT;
void SuspendMonitoring() NN_NOEXCEPT;
void ResumeMonitoring(TimeSpan extraTime = 0) NN_NOEXCEPT;

MonitorHolder* BeginMonitoring(os::Tick expireTime, MonitorHandler* pHandler) NN_NOEXCEPT;
MonitorHolder* BeginMonitoring(TimeSpan expireTime, MonitorHandler* pHandler) NN_NOEXCEPT;
bool EndMonitoring(MonitorHolder* pHolder) NN_NOEXCEPT;

inline MonitorHolder* BeginMonitoring(TimeSpan expireTime, MonitorHandler* pHandler) NN_NOEXCEPT
{
    return BeginMonitoring(os::Tick(expireTime), pHandler);
}

}}}
