﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <mutex>
#include <memory>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Mutex.h>

#include <nn/am/service/am_Foundation.sfdl.h>

namespace nn { namespace am { namespace service {

class LockAccessorBody
{
public:

    virtual ~LockAccessorBody() NN_NOEXCEPT {}

    virtual bool TryLock() NN_NOEXCEPT = 0;
    virtual void Unlock() NN_NOEXCEPT = 0;
    virtual os::SystemEventType* GetEventForLockable() NN_NOEXCEPT = 0;

};

sf::SharedPointer<ILockAccessor> MakeSfLock(std::shared_ptr<LockAccessorBody> pBody) NN_NOEXCEPT;

class ReaderWriterLock
    : public std::enable_shared_from_this<ReaderWriterLock>
{
public:

    ReaderWriterLock() NN_NOEXCEPT;

    std::shared_ptr<LockAccessorBody> GetReaderLockAccessor() NN_NOEXCEPT;
    std::shared_ptr<LockAccessorBody> GetWriterLockAccessor() NN_NOEXCEPT;

private:

    os::Mutex m_Mutex{false};
    int32_t m_LockState{0}; // -1: writer locked, 0: not locked, 0<: reader locked
    os::SystemEvent m_ReaderLockable{os::EventClearMode_ManualClear, true};
    os::SystemEvent m_WriterLockable{os::EventClearMode_ManualClear, true};

    class ReaderLock;
    class WriterLock;

};

}}}
