﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/am/service/am_Functions.sfdl.h>
#include <nn/am/service/am_Proxies.sfdl.h>
#include <nn/am/service/am_CommonTypes.h>
#include <nn/applet/applet_Types.h>

namespace nn { namespace am {

//-----------------------------------------------------------------------------

struct ApplicationServiceInterfaces
{
    // for Application
    sf::ShimLibraryObjectHolder<service::IApplicationProxy>         applicationProxy;
    sf::ShimLibraryObjectHolder<service::IApplicationFunctions>     applicationFunctions;
};

struct SystemServiceInterfaces
{
    // for SystemApplet
    sf::ShimLibraryObjectHolder<service::ISystemAppletProxy>        systemAppletProxy;
    sf::ShimLibraryObjectHolder<service::IHomeMenuFunctions>        homeMenuFunctions;
    sf::ShimLibraryObjectHolder<service::IGlobalStateController>    globalStateController;
    sf::ShimLibraryObjectHolder<service::IApplicationCreator>       applicationCreator;

    // for LibraryApplet
    sf::ShimLibraryObjectHolder<service::ILibraryAppletProxy>       libraryAppletProxy;
    sf::ShimLibraryObjectHolder<service::ILibraryAppletSelfAccessor> libraryAppletSelfAccessor;
    sf::ShimLibraryObjectHolder<service::IProcessWindingController> processWindingController;

    // for OverlayApplet
    sf::ShimLibraryObjectHolder<service::IOverlayAppletProxy>       overlayAppletProxy;
    sf::ShimLibraryObjectHolder<service::IOverlayFunctions>         overlayFunctions;
};

struct CommonInterfaces
{
    sf::ShimLibraryObjectHolder<service::ILibraryAppletCreator>     libraryAppletCreator;
    sf::ShimLibraryObjectHolder<service::ICommonStateGetter>        commonStateGetter;
    sf::ShimLibraryObjectHolder<service::ISelfController>           selfController;
    sf::ShimLibraryObjectHolder<service::IAudioController>          audioController;
    sf::ShimLibraryObjectHolder<service::IDisplayController>        displayController;
    sf::ShimLibraryObjectHolder<service::IWindowController>         windowController;
    sf::ShimLibraryObjectHolder<service::IDebugFunctions>           debugFunctions;
};

//-----

struct Interfaces
{
    ApplicationServiceInterfaces    application;
    SystemServiceInterfaces         system;
    CommonInterfaces                common;
};

extern Interfaces g_Interfaces;

//-----------------------------------------------------------------------------

void InitializeSystemAppletInterfaces() NN_NOEXCEPT;
void FinalizeSystemAppletInterfaces() NN_NOEXCEPT;

void InitializeLibraryAppletInterfaces(const AppletAttribute* p) NN_NOEXCEPT;
void FinalizeLibraryAppletInterfaces() NN_NOEXCEPT;

void InitializeOverlayAppletInterfaces() NN_NOEXCEPT;
void FinalizeOverlayAppletInterfaces() NN_NOEXCEPT;

bool InitializeApplicationInterfaces() NN_NOEXCEPT;
void FinalizeApplicationInterfaces() NN_NOEXCEPT;

void InitializeSystemApplicationInterfaces() NN_NOEXCEPT;
void FinalizeSystemApplicationInterfaces() NN_NOEXCEPT;

void SetLibraryAppletResolver(void (*resolver)()) NN_NOEXCEPT;
void InvokeWithSelfLibraryCreatorEnabled(void (*f)()) NN_NOEXCEPT;

//-----------------------------------------------------------------------------

service::IApplicationFunctions* GetApplicationFunctions() NN_NOEXCEPT;

//-----------------------------------------------------------------------------

service::ISystemAppletProxy* GetSystemAppletProxy() NN_NOEXCEPT;
service::IHomeMenuFunctions* GetHomeMenuFunctions() NN_NOEXCEPT;
service::IGlobalStateController* GetGlobalStateController() NN_NOEXCEPT;
service::IApplicationCreator* GetApplicationCreator() NN_NOEXCEPT;
service::ILibraryAppletProxy* GetLibraryAppletProxy() NN_NOEXCEPT;
service::ILibraryAppletSelfAccessor* GetLibraryAppletSelfAccessor() NN_NOEXCEPT;
service::IProcessWindingController* GetProcessWindingController() NN_NOEXCEPT;
service::IOverlayAppletProxy* GetOverlayAppletProxy() NN_NOEXCEPT;
service::IOverlayFunctions* GetOverlayFunctions() NN_NOEXCEPT;
service::IApplicationProxy* GetApplicationProxy() NN_NOEXCEPT;

//-----------------------------------------------------------------------------

service::ILibraryAppletCreator* GetLibraryAppletCreator() NN_NOEXCEPT;
service::ICommonStateGetter* GetCommonStateGetter() NN_NOEXCEPT;
service::ISelfController* GetSelfController() NN_NOEXCEPT;
service::IAudioController* GetAudioController() NN_NOEXCEPT;
service::IDisplayController* GetDisplayController() NN_NOEXCEPT;
service::IWindowController* GetWindowController() NN_NOEXCEPT;
service::IDebugFunctions* GetDebugFunctions() NN_NOEXCEPT;

//-----------------------------------------------------------------------------

applet::AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT;

bool IsInitializedAsApplication() NN_NOEXCEPT;
bool IsInitializedAsSystemApplet() NN_NOEXCEPT;
bool IsInitializedAsLibraryApplet() NN_NOEXCEPT;
bool IsInitializedAsOverlayApplet() NN_NOEXCEPT;

//-----------------------------------------------------------------------------

sf::SharedPointer<service::ISystemAppletControllerForDebug> CreateSystemAppletControllerForDebug() NN_NOEXCEPT;

}}  // namespace nn::am

