﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ディスプレイの解像度に関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>

namespace nn { namespace ae {

//-----------------------------------------------------------------------------

//! @name ディスプレイの解像度に関する API
//! @{

/**
 * @brief   デフォルトディスプレイの解像度情報を更新します。
 *
 * @details
 *  デフォルトディスプレイの解像度情報を更新します。
 */
void UpdateDefaultDisplayResolution() NN_NOEXCEPT;

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::ae
