﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief このファイルは SDK パッケージに含まれますが、直接参照されることを想定しません。
 */

#include <nn/account/account_Config.h>
#include <nn/account/account_ConfigForSystemServices.h>
#include <nn/account/account_Types.h>

#include <nn/nn_Common.h>

namespace nn { namespace account { namespace profile {

struct ProfileBase
{
    Uid author;                     // 作者のユーザー ID
    uint64_t timeStamp;             // 最終更新時点のタイムスタンプ
    char nickname[NicknameBytesMax];// ニックネーム (UTF-8), '\0' で終端されない。

    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return author;
    }
};

struct UserData
{
    char data[UserDataBytesMax];    // 利用者の任意に設定できるバイナリ列
};

// ProfileBase 初期化のための定数
const ProfileBase DefaultProfileBase = {InvalidUid, 0x00ll, {}};
const UserData DefaultUserData = {};

// ニックネームの長さ (バイト単位の有効要素数) を測る
inline size_t GetNicknameLength(const char* name, size_t nameBufferBytes) NN_NOEXCEPT;

struct Profile
{
    Uid user;
    ProfileBase base;
    UserData userData;

    void Clear() NN_NOEXCEPT
    {
        user = InvalidUid;
        base = DefaultProfileBase;
        userData = DefaultUserData;
    };
    void ClearWith(const Uid& u)
    {
        user = u;
        base = DefaultProfileBase;
        base.author = u;
        userData = DefaultUserData;
    };
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return user && base;
    }
};

}}} // ~namespace nn::account::profile

/* -------------------------------------------------------------------------------------------
    実装
 */
#include <nn/nn_SdkAssert.h>

namespace nn { namespace account { namespace profile {

inline size_t GetNicknameLength(const char* name, size_t nameBufferBytes) NN_NOEXCEPT
{
    NN_SDK_ASSERT(nameBufferBytes == NicknameBytesMax);
    NN_UNUSED(nameBufferBytes);
    size_t length = 0u;
    for (; length < NicknameBytesMax && name[length] != '\0'; ++ length)
    {
    }
    return length;
}

}}}
