﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/nas/account_NasTypes.h>
#include <nn/account/nas/account_NasUserResourceCache.h>
#include <nn/account/detail/account_Execution.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/detail/account_LocalStorage.h>

#include <curl/curl.h>

namespace nn {
namespace account {
namespace nas {

class NasUserDriver
{
private:
    const detail::AbstractLocalStorage& m_Storage;

    static const size_t RequiredBufferSize;

public:
    explicit NasUserDriver(const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;

    Result AcquireUserResourceCache(
        NintendoAccountId* pOutNintendoAccountId, NasUserResourceCache& nasUserResourceCache,
        const detail::Uuid& accessTokenCache,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable) const NN_NOEXCEPT;
};

}
}
} // ~namespace nn::account::nas
