﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/account/detail/account_SharedCounter.h>

#include <nn/nn_ApplicationId.h>

namespace nn {
namespace account {
namespace detail
{

class UserOpenHistory
{
    struct
    {
        Uid user;
        struct
        {
            ApplicationId id;
            uint32_t version;
        } application;
    } m_Entries[UserCountMax];
public:
    UserOpenHistory() NN_NOEXCEPT;
    void Add(const Uid& user, const ApplicationId& appId, uint32_t appVer) NN_NOEXCEPT;
    bool Find(ApplicationId* pOutAppId, uint32_t* pOutAppVer, const Uid& user) const NN_NOEXCEPT;
};

struct Usage
{
    Counter applicationCount;
    UserOpenHistory userOpenHistory;
};

} // ~namespace nn::account::usage
}
}

namespace nn {
namespace account {
namespace detail
{

inline UserOpenHistory::UserOpenHistory() NN_NOEXCEPT
{
    for (auto& e : m_Entries)
    {
        e.user = InvalidUid;
    }
}
inline void UserOpenHistory::Add(const Uid& user, const ApplicationId& appId, uint32_t appVer) NN_NOEXCEPT
{
    NN_SDK_ASSERT(user);

    UserOpenHistory history;
    history.m_Entries[0].user = user;
    history.m_Entries[0].application.id = appId;
    history.m_Entries[0].application.version = appVer;
    int ct = 1;

    const auto Count = static_cast<int>(sizeof(m_Entries) / sizeof(m_Entries[0]));
    for (int i = 0; ct < Count && i < Count && m_Entries[i].user; ++i)
    {
        if (m_Entries[i].user != user)
        {
            history.m_Entries[ct ++] = m_Entries[i];
        }
    }
    *this = std::move(history);
}
inline bool UserOpenHistory::Find(ApplicationId* pOutAppId, uint32_t* pOutAppVer, const Uid& user) const NN_NOEXCEPT
{
    NN_SDK_ASSERT(user);

    for (const auto& e : m_Entries)
    {
        if (!e.user)
        {
            break;
        }

        if (e.user == user)
        {
            *pOutAppId = e.application.id;
            *pOutAppVer = e.application.version;
            return true;
        }
    }
    return false;
}

} // ~namespace nn::account::usage
}
}
