﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace account { namespace detail {

class FirmwareSettings
{
private:
    static os::SdkMutex s_Lock;
    static bool g_NaRequiredForNetworkService;
    static bool g_NaLicenseVerificationEnabled;

public:
    static void Refresh() NN_NOEXCEPT;

    static bool IsNaRequiredForNetworkService() NN_NOEXCEPT;
    static bool IsNaLicenseVerificationEnabled() NN_NOEXCEPT;
};

}}} // ~namespace nn::account::detail
