﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      account モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_ACCOUNT_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(account, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_ACCOUNT_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(account, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(account, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(account, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(account, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_ACCOUNT_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(account, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(account, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(account, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(account, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_ACCOUNT_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(account, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_ACCOUNT_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(account, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_ACCOUNT_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(account, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_ACCOUNT_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(account, Trace, 0, format, args)
#define NN_DETAIL_ACCOUNT_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Trace, 1, format, args)
#define NN_DETAIL_ACCOUNT_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Trace, 2, format, args)
#define NN_DETAIL_ACCOUNT_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Trace, 3, format, args)

#define NN_DETAIL_ACCOUNT_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(account, Info, 0, format, args)
#define NN_DETAIL_ACCOUNT_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(account, Info, 1, format, args)
#define NN_DETAIL_ACCOUNT_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(account, Info, 2, format, args)
#define NN_DETAIL_ACCOUNT_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(account, Info, 3, format, args)

#define NN_DETAIL_ACCOUNT_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(account, Warn, 0, format, args)
#define NN_DETAIL_ACCOUNT_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(account, Warn, 1, format, args)
#define NN_DETAIL_ACCOUNT_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(account, Warn, 2, format, args)
#define NN_DETAIL_ACCOUNT_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(account, Warn, 3, format, args)

#define NN_DETAIL_ACCOUNT_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(account, Error, 0, format, args)
#define NN_DETAIL_ACCOUNT_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Error, 1, format, args)
#define NN_DETAIL_ACCOUNT_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Error, 2, format, args)
#define NN_DETAIL_ACCOUNT_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Error, 3, format, args)

#define NN_DETAIL_ACCOUNT_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(account, Fatal, 0, format, args)
#define NN_DETAIL_ACCOUNT_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Fatal, 1, format, args)
#define NN_DETAIL_ACCOUNT_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Fatal, 2, format, args)
#define NN_DETAIL_ACCOUNT_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(account, Fatal, 3, format, args)

#define NN_DETAIL_ACCOUNT_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(account, Trace, 0, text, length)
#define NN_DETAIL_ACCOUNT_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Trace, 1, text, length)
#define NN_DETAIL_ACCOUNT_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Trace, 2, text, length)
#define NN_DETAIL_ACCOUNT_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Trace, 3, text, length)

#define NN_DETAIL_ACCOUNT_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(account, Info, 0, text, length)
#define NN_DETAIL_ACCOUNT_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(account, Info, 1, text, length)
#define NN_DETAIL_ACCOUNT_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(account, Info, 2, text, length)
#define NN_DETAIL_ACCOUNT_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(account, Info, 3, text, length)

#define NN_DETAIL_ACCOUNT_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(account, Warn, 0, text, length)
#define NN_DETAIL_ACCOUNT_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(account, Warn, 1, text, length)
#define NN_DETAIL_ACCOUNT_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(account, Warn, 2, text, length)
#define NN_DETAIL_ACCOUNT_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(account, Warn, 3, text, length)

#define NN_DETAIL_ACCOUNT_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(account, Error, 0, text, length)
#define NN_DETAIL_ACCOUNT_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Error, 1, text, length)
#define NN_DETAIL_ACCOUNT_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Error, 2, text, length)
#define NN_DETAIL_ACCOUNT_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Error, 3, text, length)

#define NN_DETAIL_ACCOUNT_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(account, Fatal, 0, text, length)
#define NN_DETAIL_ACCOUNT_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Fatal, 1, text, length)
#define NN_DETAIL_ACCOUNT_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Fatal, 2, text, length)
#define NN_DETAIL_ACCOUNT_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(account, Fatal, 3, text, length)
