﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SystemSaveData.h>

namespace nn { namespace account { namespace detail {

// 最大同時利用可能アプリケーション数
const int ApplicationCountMax = 2;

// SF オブジェクトの生成用ヒープのサイズ
const size_t FactoryHeapSizeMax = 1024 * (8 + 1);
// ユーザーレジストリが提供可能な Notifier 数
const int UserRegistryNotifierCountMax = 6;
// ユーザーレジストリが提供可能な Notifier 数
const int UserStateManagerNotifierCountMax = 6;
// プロファイルストレージが提供可能な Notifier 数
const int ProfileStorageNotifierCountMax = 4;
// BaasUserInfoHolder が提供可能な Notifier 数
const int BaasUserInfoHolderNotifierCountMax = 8;

const size_t ProfileIoBufferSize = 256u;

// Executor ひとつあたりにキューイングできるタスク数の最大
const int QueueableTaskCountMax = 128;

// ユーザー情報のストレージ。「本体初期化」で消すが、「セーブデータを残して本体初期化」では消さない。
const fs::SystemSaveDataId SaveDataId = 0x8000000000000010ull;
const char SaveDataVolumeName[] = "account";
const char SaveDataDirectoryName[] = "/su";
const int64_t SaveDataSize = 4 * 1024 * 1024;
const int64_t SaveDataJournalSize = 3 * 1024 * 1024;
const uint32_t SaveDataFlags = fs::SaveDataFlags_KeepAfterResettingSystemSaveDataWithoutUserSaveData;

// ID生成のシードのストレージ。本体初期化で消さない。
const fs::SystemSaveDataId SaveDataIdForIdGeneration = 0x8000000000000011ull;
const char SaveDataVolumeNameForIdGeneration[] = "idgen";
static const char IdGenerationContextPath[] = "idgen:/context.bin";
const int64_t SaveDataSizeForIdGeneration = 128 * 1024;
const int64_t SaveDataJournalSizeForIdGeneration = 128 * 1024;
const uint32_t SaveDataFlagsForIdGeneration = fs::SaveDataFlags_KeepAfterResettingSystemSaveData; // 暗黙的に WithoutUserSaveData を含む

// IO のためのバッファの最小サイズ
const size_t IoBufferSizeMin = 1024u;

/* ------------------------------------------------------------
    クライアント証明書
 */
const size_t DeviceCertBufferSizeMax = 4096u;

/* ------------------------------------------------------------
    NDAS
 */
// 取り扱う NDAS 由来の認証トークンの最大長 (終端を含まない)
const size_t NdasDevAuthTokenSizeMax = 1024u;
const size_t NdasAppAuthTokenSizeMax = 2048u;
// キャッシュ可能な ApplicationAuthenticationToken の最大個数
const int NdasAppAuthCacheCountMax = 4;
// バージョンチェックエラーのキャッシュ期間
const int NdasAuthenticationErrorCacheSeconds = 6 * 60 * 60;

/* ------------------------------------------------------------
    BaaS
 */
// 取り扱う BaaS 由来の認証トークンの最大長 (終端を含まない)
const size_t BaasAccessTokenSizeMax = 1536u;
const size_t BaasIdTokenSizeMax = 3072u;
// キャッシュ可能な BaaS トークン数
const int BaasAccessTokenCacheCountMax = 8; // public_user
const int BaasIdTokenCacheCountMax = 16; // id token

/* ------------------------------------------------------------
    NAS
 */
const size_t NasCallbackUriLengthMax = 255;
const size_t NasAuthorizationCodeSizeMax = 512u;
const size_t NasIdTokenSizeMax = 1536u;
const size_t NasAccessTokenSizeMax = 1536u;
const size_t NasRefreshTokenSizeMax = 2048u;
const size_t NasRedirectedUriLengthMax = 4095;

/* ------------------------------------------------------------
    セーブデータサムネイル
 */
const size_t SaveDataThumbnailSize = 147456u;

}}} // ~namespace nn::account::detail
