﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasOperator.h>

#include <nn/nn_Result.h>
#include <nn/os/os_SystemEventApi.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/sf/sf_Out.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace account { namespace baas {

class BaasUserInfoHolderNotifier
{
private:
    BaasOperator& m_BaasOp;
    os::SystemEventType* m_pEvent;

public:
    BaasUserInfoHolderNotifier(
        BaasOperator& baasOp,
        os::SystemEventType* pEvent) NN_NOEXCEPT
        : m_BaasOp(baasOp)
        , m_pEvent(pEvent)
    {
    }
    ~BaasUserInfoHolderNotifier() NN_NOEXCEPT
    {
        m_BaasOp.ReleaseBaasUserAvailabilityChangeNotifier(m_pEvent);
    }

    nn::Result GetSystemEvent(sf::Out<sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    {
        *pOutHandle = sf::NativeHandle(os::GetReadableHandleOfSystemEvent(m_pEvent), false);
        NN_RESULT_SUCCESS;
    }
};

}}} // ~namespace nn::account::impl
