﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_TypesForSystemServices.h>
#include <nn/account/detail/account_IAsyncContext.sfdl.h>
#include <nn/account/detail/account_IAsyncNetworkServiceLicenseKindContext.sfdl.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/http/account_Interface.sfdl.h>
#include <nn/account/nas/account_Interface.sfdl.h>
#include <nn/account/nas/account_NasTypes.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/time/time_PosixTime.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace account { namespace baas { // NOLINT(whitespace/braces)

class IAdministrator;

class IFloatingRegistrationRequest;

class IGuestLoginRequest;

class IManagerBase;

class IManagerForApplication;

class IManagerForSystemService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManagerBase, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManagerBase)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CheckAvailability)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManagerBase)

        ::nn::Result CheckAvailability() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CheckAvailability);
        }

        ::nn::Result GetAccountId(::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountId, (pOutId));
        }

        ::nn::Result EnsureIdTokenCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (pOutContext));
        }

        ::nn::Result LoadIdTokenCache(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOut)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOut)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (pOutActualSize, pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManagerBase
    {
    public:
        nn::Result CheckAvailability() NN_NOEXCEPT;
        nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
        nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CheckAvailability() NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::baas::IManagerBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckAvailability)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CheckAvailability);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountId, (pOutId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadIdTokenCache, (pOutActualSize, pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::baas::IManagerBase>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::baas::IManagerBase))

    // nn::Result CheckAvailability() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckAvailability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckAvailability)

    // nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutId, (::nn::account::NetworkServiceAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountId)

    // nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnsureIdTokenCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnsureIdTokenCacheAsync)

    // nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadIdTokenCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadIdTokenCache)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::baas::IManagerBase, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::baas::IManagerBase))

    // nn::Result CheckAvailability() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckAvailability)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckAvailability)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckAvailability)
    }

    // nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountId)
    }

    // nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnsureIdTokenCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnsureIdTokenCacheAsync)
    }

    // nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadIdTokenCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadIdTokenCache)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::baas::IManagerBase>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::baas::IManagerBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnsureIdTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnsureIdTokenCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadIdTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadIdTokenCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnsureIdTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadIdTokenCache)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::baas::IManagerBase))

namespace nn { namespace account { namespace baas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManagerForSystemService, (::nn::account::baas::IManagerBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManagerForSystemService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetServiceEntryRequirementCache, (::nn::sf::Out<::std::uint32_t> pOut, ::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateServiceEntryRequirementCache, (::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateTokenCache, (::nn::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCache, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBase> pOutBase, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkServiceLicenseCache, (::nn::sf::Out<::std::int32_t> pOutLicense, ::nn::sf::Out<::nn::time::PosixTime> pOutExpiration))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::nas::NasClientInfo& clientInfo, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManagerForSystemService)

        ::nn::Result SetSystemProgramIdentification(const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.id != ::nn::ApplicationId::GetInvalidId()), identification)), "_.id != ::nn::ApplicationId::GetInvalidId() (where _ = identification)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (identification, pid));
        }

        ::nn::Result GetServiceEntryRequirementCache(::nn::sf::Out<::std::uint32_t> pOut, ::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetServiceEntryRequirementCache, (pOut, appId));
        }

        ::nn::Result InvalidateServiceEntryRequirementCache(::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InvalidateServiceEntryRequirementCache, (appId));
        }

        ::nn::Result InvalidateTokenCache(::nn::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), appId)), "_ != ::nn::ApplicationId::GetInvalidId() (where _ = appId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InvalidateTokenCache, (appId));
        }

        ::nn::Result GetNintendoAccountId(::nn::sf::Out<::nn::account::NintendoAccountId> pOutId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNintendoAccountId, (pOutId));
        }

        ::nn::Result GetNintendoAccountUserResourceCache(::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBase> pOutBase, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), workBuffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = workBuffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCache, (pOutId, pOutBase, workBuffer));
        }

        ::nn::Result RefreshNintendoAccountUserResourceCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsync, (pOut));
        }

        ::nn::Result RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed(::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed, (pOutMatched, pOutContext, seconds));
        }

        ::nn::Result GetNetworkServiceLicenseCache(::nn::sf::Out<::std::int32_t> pOutLicense, ::nn::sf::Out<::nn::time::PosixTime> pOutExpiration) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkServiceLicenseCache, (pOutLicense, pOutExpiration));
        }

        ::nn::Result RefreshNetworkServiceLicenseCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsync, (pOut));
        }

        ::nn::Result RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed(::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed, (pOutMatched, pOutContext, seconds));
        }

        ::nn::Result CreateAuthorizationRequest(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::nas::NasClientInfo& clientInfo, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), clientInfo)), "static_cast<bool>(_) (where _ = clientInfo)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (pOut, clientInfo, param, ::std::move(transferMemory), size));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManagerForSystemService : public ::nn::account::baas::IManagerBase
    {
    public:
        nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result GetServiceEntryRequirementCache(nn::sf::Out<std::uint32_t> pOut, nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result InvalidateServiceEntryRequirementCache(nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result InvalidateTokenCache(nn::ApplicationId appId) NN_NOEXCEPT;
        nn::Result GetNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOutId) NN_NOEXCEPT;
        nn::Result GetNintendoAccountUserResourceCache(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBase> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result RefreshNintendoAccountUserResourceCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
        nn::Result RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
        nn::Result GetNetworkServiceLicenseCache(nn::sf::Out<std::int32_t> pOutLicense, nn::sf::Out<nn::time::PosixTime> pOutExpiration) NN_NOEXCEPT;
        nn::Result RefreshNetworkServiceLicenseCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
        nn::Result RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
        nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::nas::NasClientInfo& clientInfo, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CheckAvailability() NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result GetServiceEntryRequirementCache(nn::sf::Out<std::uint32_t> pOut, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result InvalidateServiceEntryRequirementCache(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result InvalidateTokenCache(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOutId) NN_NOEXCEPT;
    nn::Result GetNintendoAccountUserResourceCache(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBase> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result RefreshNintendoAccountUserResourceCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
    nn::Result RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
    nn::Result GetNetworkServiceLicenseCache(nn::sf::Out<std::int32_t> pOutLicense, nn::sf::Out<nn::time::PosixTime> pOutExpiration) NN_NOEXCEPT;
    nn::Result RefreshNetworkServiceLicenseCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
    nn::Result RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
    nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::nas::NasClientInfo& clientInfo, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::baas::IManagerForSystemService), (::nn::account::baas::IManagerBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSystemProgramIdentification, (identification, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetServiceEntryRequirementCache, (::nn::sf::Out<::std::uint32_t> pOut, ::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetServiceEntryRequirementCache, (pOut, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateServiceEntryRequirementCache, (::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InvalidateServiceEntryRequirementCache, (appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateTokenCache, (::nn::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InvalidateTokenCache, (appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNintendoAccountId, (pOutId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCache, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBase> pOutBase, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNintendoAccountUserResourceCache, (pOutId, pOutBase, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsync, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed, (pOutMatched, pOutContext, seconds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkServiceLicenseCache, (::nn::sf::Out<::std::int32_t> pOutLicense, ::nn::sf::Out<::nn::time::PosixTime> pOutExpiration))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkServiceLicenseCache, (pOutLicense, pOutExpiration));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsync, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed, (pOutMatched, pOutContext, seconds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::nas::NasClientInfo& clientInfo, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateAuthorizationRequest, (pOut, clientInfo, param, ::std::move(transferMemory), size));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::baas::IManagerForSystemService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::baas::IManagerForSystemService), (::nn::account::baas::IManagerBase))

    // nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSystemProgramIdentification)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(identification, 0, (const ::nn::account::SystemProgramIdentification&), 16, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (identification))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(identification), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSystemProgramIdentification)

    // nn::Result GetServiceEntryRequirementCache(nn::sf::Out<std::uint32_t> pOut, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetServiceEntryRequirementCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetServiceEntryRequirementCache)

    // nn::Result InvalidateServiceEntryRequirementCache(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InvalidateServiceEntryRequirementCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InvalidateServiceEntryRequirementCache)

    // nn::Result InvalidateTokenCache(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InvalidateTokenCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(112)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InvalidateTokenCache)

    // nn::Result GetNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOutId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNintendoAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutId, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNintendoAccountId)

    // nn::Result GetNintendoAccountUserResourceCache(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBase> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNintendoAccountUserResourceCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutBase, 0, (::nn::sf::Out<::nn::account::nas::NasUserBase>), 592, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutBase, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutId, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNintendoAccountUserResourceCache)

    // nn::Result RefreshNintendoAccountUserResourceCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RefreshNintendoAccountUserResourceCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(131)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RefreshNintendoAccountUserResourceCacheAsync)

    // nn::Result RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(132)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seconds, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (seconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMatched, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMatched))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMatched), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)

    // nn::Result GetNetworkServiceLicenseCache(nn::sf::Out<std::int32_t> pOutLicense, nn::sf::Out<nn::time::PosixTime> pOutExpiration) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkServiceLicenseCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(140)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutLicense, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutExpiration, (::nn::time::PosixTime), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutLicense, pOutExpiration))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutLicense), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutExpiration)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkServiceLicenseCache)

    // nn::Result RefreshNetworkServiceLicenseCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RefreshNetworkServiceLicenseCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(141)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RefreshNetworkServiceLicenseCacheAsync)

    // nn::Result RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(142)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seconds, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (seconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMatched, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMatched))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMatched), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)

    // nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::nas::NasClientInfo& clientInfo, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateAuthorizationRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(150)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(clientInfo, 0, (const ::nn::account::nas::NasClientInfo&), 264, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(param, 1, (const ::nn::account::NintendoAccountAuthorizationRequestParameters&), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (clientInfo, param))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemory, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemory))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(param), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemory), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateAuthorizationRequest)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::SystemProgramIdentification), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::nas::NasUserBase), 592, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::PosixTime), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::nas::NasClientInfo), 264, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountAuthorizationRequestParameters), 512, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::baas::IManagerForSystemService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::baas::IManagerForSystemService), (::nn::account::baas::IManagerBase))

    // nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSystemProgramIdentification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(identification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSystemProgramIdentification)
    }

    // nn::Result GetServiceEntryRequirementCache(nn::sf::Out<std::uint32_t> pOut, nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetServiceEntryRequirementCache, (::nn::sf::Out<::std::uint32_t> pOut, ::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetServiceEntryRequirementCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetServiceEntryRequirementCache)
    }

    // nn::Result InvalidateServiceEntryRequirementCache(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateServiceEntryRequirementCache, (::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InvalidateServiceEntryRequirementCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InvalidateServiceEntryRequirementCache)
    }

    // nn::Result InvalidateTokenCache(nn::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateTokenCache, (::nn::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InvalidateTokenCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InvalidateTokenCache)
    }

    // nn::Result GetNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOutId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNintendoAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNintendoAccountId)
    }

    // nn::Result GetNintendoAccountUserResourceCache(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBase> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCache, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBase> pOutBase, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNintendoAccountUserResourceCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNintendoAccountUserResourceCache)
    }

    // nn::Result RefreshNintendoAccountUserResourceCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RefreshNintendoAccountUserResourceCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RefreshNintendoAccountUserResourceCacheAsync)
    }

    // nn::Result RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMatched)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)
    }

    // nn::Result GetNetworkServiceLicenseCache(nn::sf::Out<std::int32_t> pOutLicense, nn::sf::Out<nn::time::PosixTime> pOutExpiration) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkServiceLicenseCache, (::nn::sf::Out<::std::int32_t> pOutLicense, ::nn::sf::Out<::nn::time::PosixTime> pOutExpiration))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkServiceLicenseCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutLicense)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutExpiration)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkServiceLicenseCache)
    }

    // nn::Result RefreshNetworkServiceLicenseCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RefreshNetworkServiceLicenseCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RefreshNetworkServiceLicenseCacheAsync)
    }

    // nn::Result RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMatched)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)
    }

    // nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::nas::NasClientInfo& clientInfo, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::nas::NasClientInfo& clientInfo, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateAuthorizationRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(param)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateAuthorizationRequest)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::baas::IManagerForSystemService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::baas::IManagerForSystemService), (::nn::account::baas::IManagerBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSystemProgramIdentification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(identification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.id != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(identification)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSystemProgramIdentification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(identification),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetServiceEntryRequirementCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetServiceEntryRequirementCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InvalidateServiceEntryRequirementCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InvalidateServiceEntryRequirementCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InvalidateTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InvalidateTokenCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNintendoAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNintendoAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNintendoAccountUserResourceCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBase)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNintendoAccountUserResourceCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RefreshNintendoAccountUserResourceCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RefreshNintendoAccountUserResourceCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMatched),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkServiceLicenseCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkServiceLicenseCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutLicense),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutExpiration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RefreshNetworkServiceLicenseCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RefreshNetworkServiceLicenseCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMatched),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateAuthorizationRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(clientInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(param)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(clientInfo)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateAuthorizationRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(clientInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(param),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemory),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSystemProgramIdentification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetServiceEntryRequirementCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InvalidateServiceEntryRequirementCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InvalidateTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNintendoAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNintendoAccountUserResourceCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RefreshNintendoAccountUserResourceCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkServiceLicenseCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RefreshNetworkServiceLicenseCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateAuthorizationRequest)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::baas::IManagerForSystemService))

namespace nn { namespace account { namespace baas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAdministrator, (::nn::account::baas::IManagerForSystemService))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAdministrator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsRegistered, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteRegistrationInfoLocally)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeProfileAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UploadProfileAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeProfileAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsLinkedWithNintendoAccount, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToLinkWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const ::nn::account::detail::Uuid& sessionId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToUpdateLinkageStateOfNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToUpdateLinkageStateOfNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToLinkNnidWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkNnidWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TryRecoverNintendoAccountUserStateAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugUnlinkNintendoAccountAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetAvailabilityErrorDetail, (::std::uint32_t detail))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAdministrator)

        ::nn::Result IsRegistered(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsRegistered, (pOut));
        }

        ::nn::Result RegisterAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterAsync, (pOutContext));
        }

        ::nn::Result UnregisterAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterAsync, (pOutContext));
        }

        ::nn::Result DeleteRegistrationInfoLocally() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteRegistrationInfoLocally);
        }

        ::nn::Result SynchronizeProfileAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SynchronizeProfileAsync, (pOutContext));
        }

        ::nn::Result UploadProfileAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UploadProfileAsync, (pOutContext));
        }

        ::nn::Result SynchronizeProfileAsyncIfSecondsElapsed(::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SynchronizeProfileAsyncIfSecondsElapsed, (pOutMatched, pOutContext, seconds));
        }

        ::nn::Result IsLinkedWithNintendoAccount(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsLinkedWithNintendoAccount, (pOut));
        }

        ::nn::Result CreateProcedureToLinkWithNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateProcedureToLinkWithNintendoAccount, (pOut));
        }

        ::nn::Result ResumeProcedureToLinkWithNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const ::nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), sessionId)), "static_cast<bool>(_) (where _ = sessionId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkWithNintendoAccount, (pOut, sessionId));
        }

        ::nn::Result CreateProcedureToUpdateLinkageStateOfNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateProcedureToUpdateLinkageStateOfNintendoAccount, (pOut));
        }

        ::nn::Result ResumeProcedureToUpdateLinkageStateOfNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), sessionId)), "static_cast<bool>(_) (where _ = sessionId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResumeProcedureToUpdateLinkageStateOfNintendoAccount, (pOut, sessionId));
        }

        ::nn::Result CreateProcedureToLinkNnidWithNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateProcedureToLinkNnidWithNintendoAccount, (pOut));
        }

        ::nn::Result ResumeProcedureToLinkNnidWithNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), sessionId)), "static_cast<bool>(_) (where _ = sessionId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkNnidWithNintendoAccount, (pOut, sessionId));
        }

        ::nn::Result ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), sessionId)), "static_cast<bool>(_) (where _ = sessionId)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount, (pOut, sessionId));
        }

        ::nn::Result TryRecoverNintendoAccountUserStateAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TryRecoverNintendoAccountUserStateAsync, (pOut));
        }

        ::nn::Result DebugUnlinkNintendoAccountAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugUnlinkNintendoAccountAsync, (pOutContext));
        }

        ::nn::Result DebugSetAvailabilityErrorDetail(::std::uint32_t detail) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DebugSetAvailabilityErrorDetail, (detail));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAdministrator : public ::nn::account::baas::IManagerForSystemService
    {
    public:
        nn::Result IsRegistered(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result RegisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result UnregisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result DeleteRegistrationInfoLocally() NN_NOEXCEPT;
        nn::Result SynchronizeProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result UploadProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result SynchronizeProfileAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
        nn::Result IsLinkedWithNintendoAccount(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result CreateProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut) NN_NOEXCEPT;
        nn::Result ResumeProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
        nn::Result CreateProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT;
        nn::Result ResumeProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
        nn::Result CreateProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT;
        nn::Result ResumeProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
        nn::Result ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
        nn::Result TryRecoverNintendoAccountUserStateAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
        nn::Result DebugUnlinkNintendoAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result DebugSetAvailabilityErrorDetail(std::uint32_t detail) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CheckAvailability() NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result GetServiceEntryRequirementCache(nn::sf::Out<std::uint32_t> pOut, nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result InvalidateServiceEntryRequirementCache(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result InvalidateTokenCache(nn::ApplicationId appId) NN_NOEXCEPT;
    nn::Result GetNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOutId) NN_NOEXCEPT;
    nn::Result GetNintendoAccountUserResourceCache(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBase> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result RefreshNintendoAccountUserResourceCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
    nn::Result RefreshNintendoAccountUserResourceCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
    nn::Result GetNetworkServiceLicenseCache(nn::sf::Out<std::int32_t> pOutLicense, nn::sf::Out<nn::time::PosixTime> pOutExpiration) NN_NOEXCEPT;
    nn::Result RefreshNetworkServiceLicenseCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
    nn::Result RefreshNetworkServiceLicenseCacheAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
    nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::nas::NasClientInfo& clientInfo, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT;
    nn::Result IsRegistered(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result RegisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result UnregisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result DeleteRegistrationInfoLocally() NN_NOEXCEPT;
    nn::Result SynchronizeProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result UploadProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result SynchronizeProfileAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT;
    nn::Result IsLinkedWithNintendoAccount(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result CreateProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut) NN_NOEXCEPT;
    nn::Result ResumeProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
    nn::Result CreateProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT;
    nn::Result ResumeProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
    nn::Result CreateProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT;
    nn::Result ResumeProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
    nn::Result ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT;
    nn::Result TryRecoverNintendoAccountUserStateAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT;
    nn::Result DebugUnlinkNintendoAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result DebugSetAvailabilityErrorDetail(std::uint32_t detail) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::baas::IAdministrator), (::nn::account::baas::IManagerForSystemService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRegistered, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsRegistered, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteRegistrationInfoLocally)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteRegistrationInfoLocally);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeProfileAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SynchronizeProfileAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UploadProfileAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UploadProfileAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeProfileAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SynchronizeProfileAsyncIfSecondsElapsed, (pOutMatched, pOutContext, seconds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsLinkedWithNintendoAccount, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsLinkedWithNintendoAccount, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToLinkWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateProcedureToLinkWithNintendoAccount, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResumeProcedureToLinkWithNintendoAccount, (pOut, sessionId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToUpdateLinkageStateOfNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateProcedureToUpdateLinkageStateOfNintendoAccount, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToUpdateLinkageStateOfNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResumeProcedureToUpdateLinkageStateOfNintendoAccount, (pOut, sessionId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToLinkNnidWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateProcedureToLinkNnidWithNintendoAccount, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkNnidWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResumeProcedureToLinkNnidWithNintendoAccount, (pOut, sessionId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount, (pOut, sessionId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TryRecoverNintendoAccountUserStateAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TryRecoverNintendoAccountUserStateAsync, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugUnlinkNintendoAccountAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugUnlinkNintendoAccountAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetAvailabilityErrorDetail, (::std::uint32_t detail))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DebugSetAvailabilityErrorDetail, (detail));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::baas::IAdministrator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::baas::IAdministrator), (::nn::account::baas::IManagerForSystemService))

    // nn::Result IsRegistered(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsRegistered)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsRegistered)

    // nn::Result RegisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterAsync)

    // nn::Result UnregisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAsync)

    // nn::Result DeleteRegistrationInfoLocally() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRegistrationInfoLocally)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRegistrationInfoLocally)

    // nn::Result SynchronizeProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SynchronizeProfileAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(220)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SynchronizeProfileAsync)

    // nn::Result UploadProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UploadProfileAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(221)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UploadProfileAsync)

    // nn::Result SynchronizeProfileAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SynchronizeProfileAsyncIfSecondsElapsed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(222)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seconds, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (seconds))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMatched, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMatched))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMatched), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seconds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SynchronizeProfileAsyncIfSecondsElapsed)

    // nn::Result IsLinkedWithNintendoAccount(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsLinkedWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(250)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsLinkedWithNintendoAccount)

    // nn::Result CreateProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateProcedureToLinkWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(251)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateProcedureToLinkWithNintendoAccount)

    // nn::Result ResumeProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeProcedureToLinkWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(252)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeProcedureToLinkWithNintendoAccount)

    // nn::Result CreateProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateProcedureToUpdateLinkageStateOfNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(255)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateProcedureToUpdateLinkageStateOfNintendoAccount)

    // nn::Result ResumeProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(256)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)

    // nn::Result CreateProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateProcedureToLinkNnidWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(260)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateProcedureToLinkNnidWithNintendoAccount)

    // nn::Result ResumeProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeProcedureToLinkNnidWithNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(261)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeProcedureToLinkNnidWithNintendoAccount)

    // nn::Result ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(280)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (sessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)

    // nn::Result TryRecoverNintendoAccountUserStateAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TryRecoverNintendoAccountUserStateAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TryRecoverNintendoAccountUserStateAsync)

    // nn::Result DebugUnlinkNintendoAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugUnlinkNintendoAccountAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(997)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugUnlinkNintendoAccountAsync)

    // nn::Result DebugSetAvailabilityErrorDetail(std::uint32_t detail) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DebugSetAvailabilityErrorDetail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(998)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(detail, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (detail))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(detail)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DebugSetAvailabilityErrorDetail)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::SystemProgramIdentification), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::nas::NasUserBase), 592, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::PosixTime), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::nas::NasClientInfo), 264, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountAuthorizationRequestParameters), 512, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::baas::IAdministrator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::baas::IAdministrator), (::nn::account::baas::IManagerForSystemService))

    // nn::Result IsRegistered(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsRegistered, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsRegistered)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsRegistered)
    }

    // nn::Result RegisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterAsync)
    }

    // nn::Result UnregisterAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAsync)
    }

    // nn::Result DeleteRegistrationInfoLocally() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteRegistrationInfoLocally)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRegistrationInfoLocally)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRegistrationInfoLocally)
    }

    // nn::Result SynchronizeProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeProfileAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SynchronizeProfileAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SynchronizeProfileAsync)
    }

    // nn::Result UploadProfileAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UploadProfileAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UploadProfileAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UploadProfileAsync)
    }

    // nn::Result SynchronizeProfileAsyncIfSecondsElapsed(nn::sf::Out<bool> pOutMatched, nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, std::uint32_t seconds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SynchronizeProfileAsyncIfSecondsElapsed, (::nn::sf::Out<bool> pOutMatched, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, ::std::uint32_t seconds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SynchronizeProfileAsyncIfSecondsElapsed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMatched)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seconds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SynchronizeProfileAsyncIfSecondsElapsed)
    }

    // nn::Result IsLinkedWithNintendoAccount(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsLinkedWithNintendoAccount, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsLinkedWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsLinkedWithNintendoAccount)
    }

    // nn::Result CreateProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToLinkWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateProcedureToLinkWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateProcedureToLinkWithNintendoAccount)
    }

    // nn::Result ResumeProcedureToLinkWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeProcedureToLinkWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeProcedureToLinkWithNintendoAccount)
    }

    // nn::Result CreateProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToUpdateLinkageStateOfNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateProcedureToUpdateLinkageStateOfNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateProcedureToUpdateLinkageStateOfNintendoAccount)
    }

    // nn::Result ResumeProcedureToUpdateLinkageStateOfNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToUpdateLinkageStateOfNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)
    }

    // nn::Result CreateProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProcedureToLinkNnidWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateProcedureToLinkNnidWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateProcedureToLinkNnidWithNintendoAccount)
    }

    // nn::Result ResumeProcedureToLinkNnidWithNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeProcedureToLinkNnidWithNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeProcedureToLinkNnidWithNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeProcedureToLinkNnidWithNintendoAccount)
    }

    // nn::Result ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount(nn::sf::Out<nn::sf::SharedPointer<nn::account::http::IOAuthProcedure>> pOut, const nn::account::detail::Uuid& sessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>> pOut, const ::nn::account::detail::Uuid& sessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)
    }

    // nn::Result TryRecoverNintendoAccountUserStateAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TryRecoverNintendoAccountUserStateAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TryRecoverNintendoAccountUserStateAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TryRecoverNintendoAccountUserStateAsync)
    }

    // nn::Result DebugUnlinkNintendoAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugUnlinkNintendoAccountAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugUnlinkNintendoAccountAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugUnlinkNintendoAccountAsync)
    }

    // nn::Result DebugSetAvailabilityErrorDetail(std::uint32_t detail) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DebugSetAvailabilityErrorDetail, (::std::uint32_t detail))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DebugSetAvailabilityErrorDetail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(detail)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DebugSetAvailabilityErrorDetail)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::baas::IAdministrator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::baas::IAdministrator), (::nn::account::baas::IManagerForSystemService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsRegistered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsRegistered)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRegistrationInfoLocally)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRegistrationInfoLocally)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SynchronizeProfileAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SynchronizeProfileAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UploadProfileAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UploadProfileAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SynchronizeProfileAsyncIfSecondsElapsed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SynchronizeProfileAsyncIfSecondsElapsed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMatched),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seconds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsLinkedWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsLinkedWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateProcedureToLinkWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateProcedureToLinkWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeProcedureToLinkWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeProcedureToLinkWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateProcedureToUpdateLinkageStateOfNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateProcedureToUpdateLinkageStateOfNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateProcedureToLinkNnidWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateProcedureToLinkNnidWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeProcedureToLinkNnidWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeProcedureToLinkNnidWithNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::http::IOAuthProcedure>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TryRecoverNintendoAccountUserStateAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TryRecoverNintendoAccountUserStateAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugUnlinkNintendoAccountAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugUnlinkNintendoAccountAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DebugSetAvailabilityErrorDetail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DebugSetAvailabilityErrorDetail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(detail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsRegistered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRegistrationInfoLocally)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SynchronizeProfileAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UploadProfileAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SynchronizeProfileAsyncIfSecondsElapsed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsLinkedWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateProcedureToLinkWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeProcedureToLinkWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateProcedureToUpdateLinkageStateOfNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeProcedureToUpdateLinkageStateOfNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateProcedureToLinkNnidWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeProcedureToLinkNnidWithNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ProxyProcedureToAcquireApplicationAuthorizationForNintendoAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TryRecoverNintendoAccountUserStateAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugUnlinkNintendoAccountAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DebugSetAvailabilityErrorDetail)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::baas::IAdministrator))

namespace nn { namespace account { namespace baas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IGuestLoginRequest, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IGuestLoginRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSessionId, (::nn::sf::Out<::nn::account::detail::Uuid> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNickname, (const ::nn::sf::OutArray<char>& nickname))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IGuestLoginRequest)

        ::nn::Result GetSessionId(::nn::sf::Out<::nn::account::detail::Uuid> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSessionId, (pOut));
        }

        ::nn::Result GetAccountId(::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountId, (pOutId));
        }

        ::nn::Result GetLinkedNintendoAccountId(::nn::sf::Out<::nn::account::NintendoAccountId> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (pOut));
        }

        ::nn::Result GetNickname(const ::nn::sf::OutArray<char>& nickname) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::NicknameBytesMax + 1), nickname)), "_.GetLength() == ::nn::account::NicknameBytesMax + 1 (where _ = nickname)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNickname, (nickname));
        }

        ::nn::Result GetProfileImage(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileImage, (pOutActualSize, pOutImage));
        }

        ::nn::Result LoadIdTokenCache(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOut)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOut)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (pOutActualSize, pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IGuestLoginRequest
    {
    public:
        nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT;
        nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
        nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT;
        nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT;
        nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
        nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT;
    nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT;
    nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
    nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::baas::IGuestLoginRequest))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSessionId, (::nn::sf::Out<::nn::account::detail::Uuid> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSessionId, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountId, (pOutId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLinkedNintendoAccountId, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNickname, (const ::nn::sf::OutArray<char>& nickname))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNickname, (nickname));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileImage, (pOutActualSize, pOutImage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadIdTokenCache, (pOutActualSize, pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::baas::IGuestLoginRequest>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::baas::IGuestLoginRequest))

    // nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSessionId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSessionId)

    // nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutId, (::nn::account::NetworkServiceAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountId)

    // nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLinkedNintendoAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLinkedNintendoAccountId)

    // nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNickname)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nickname, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (nickname))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nickname)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNickname)

    // nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutImage, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutImage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileImage)

    // nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadIdTokenCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadIdTokenCache)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::baas::IGuestLoginRequest, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::baas::IGuestLoginRequest))

    // nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSessionId, (::nn::sf::Out<::nn::account::detail::Uuid> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSessionId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSessionId)
    }

    // nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountId)
    }

    // nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLinkedNintendoAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLinkedNintendoAccountId)
    }

    // nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNickname, (const ::nn::sf::OutArray<char>& nickname))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNickname)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nickname)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNickname)
    }

    // nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutImage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileImage)
    }

    // nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadIdTokenCache, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadIdTokenCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadIdTokenCache)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::baas::IGuestLoginRequest>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::baas::IGuestLoginRequest))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSessionId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLinkedNintendoAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLinkedNintendoAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nickname)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::NicknameBytesMax + 1), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nickname)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNickname)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadIdTokenCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadIdTokenCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLinkedNintendoAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadIdTokenCache)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::baas::IGuestLoginRequest))

namespace nn { namespace account { namespace baas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFloatingRegistrationRequest, (::nn::account::baas::IGuestLoginRequest))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFloatingRegistrationRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUser, (::nn::sf::Out<::nn::account::Uid> uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUserWithUid, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountWithUidAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFloatingRegistrationRequest)

        ::nn::Result RegisterUser(::nn::sf::Out<::nn::account::Uid> uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterUser, (uid));
        }

        ::nn::Result RegisterUserWithUid(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterUserWithUid, (uid));
        }

        ::nn::Result RegisterNetworkServiceAccountAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountAsync, (pOutContext));
        }

        ::nn::Result RegisterNetworkServiceAccountWithUidAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountWithUidAsync, (pOutContext, uid));
        }

        ::nn::Result SetSystemProgramIdentification(const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.id != ::nn::ApplicationId::GetInvalidId()), identification)), "_.id != ::nn::ApplicationId::GetInvalidId() (where _ = identification)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (identification, pid));
        }

        ::nn::Result EnsureIdTokenCacheAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (pOutContext));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFloatingRegistrationRequest : public ::nn::account::baas::IGuestLoginRequest
    {
    public:
        nn::Result RegisterUser(nn::sf::Out<nn::account::Uid> uid) NN_NOEXCEPT;
        nn::Result RegisterUserWithUid(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result RegisterNetworkServiceAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result RegisterNetworkServiceAccountWithUidAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT;
    nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT;
    nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
    nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    nn::Result RegisterUser(nn::sf::Out<nn::account::Uid> uid) NN_NOEXCEPT;
    nn::Result RegisterUserWithUid(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RegisterNetworkServiceAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result RegisterNetworkServiceAccountWithUidAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::baas::IFloatingRegistrationRequest), (::nn::account::baas::IGuestLoginRequest))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUser, (::nn::sf::Out<::nn::account::Uid> uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterUser, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUserWithUid, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterUserWithUid, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterNetworkServiceAccountAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountWithUidAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterNetworkServiceAccountWithUidAsync, (pOutContext, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSystemProgramIdentification, (identification, pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (pOutContext));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::baas::IFloatingRegistrationRequest>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::baas::IFloatingRegistrationRequest), (::nn::account::baas::IGuestLoginRequest))

    // nn::Result RegisterUser(nn::sf::Out<nn::account::Uid> uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterUser)

    // nn::Result RegisterUserWithUid(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterUserWithUid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterUserWithUid)

    // nn::Result RegisterNetworkServiceAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterNetworkServiceAccountAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterNetworkServiceAccountAsync)

    // nn::Result RegisterNetworkServiceAccountWithUidAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterNetworkServiceAccountWithUidAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterNetworkServiceAccountWithUidAsync)

    // nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSystemProgramIdentification)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(identification, 0, (const ::nn::account::SystemProgramIdentification&), 16, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (identification))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(identification), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSystemProgramIdentification)

    // nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnsureIdTokenCacheAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnsureIdTokenCacheAsync)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::SystemProgramIdentification), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::baas::IFloatingRegistrationRequest, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::baas::IFloatingRegistrationRequest), (::nn::account::baas::IGuestLoginRequest))

    // nn::Result RegisterUser(nn::sf::Out<nn::account::Uid> uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUser, (::nn::sf::Out<::nn::account::Uid> uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterUser)
    }

    // nn::Result RegisterUserWithUid(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUserWithUid, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterUserWithUid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterUserWithUid)
    }

    // nn::Result RegisterNetworkServiceAccountAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterNetworkServiceAccountAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterNetworkServiceAccountAsync)
    }

    // nn::Result RegisterNetworkServiceAccountWithUidAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterNetworkServiceAccountWithUidAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterNetworkServiceAccountWithUidAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterNetworkServiceAccountWithUidAsync)
    }

    // nn::Result SetSystemProgramIdentification(const nn::account::SystemProgramIdentification& identification, nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemProgramIdentification, (const ::nn::account::SystemProgramIdentification& identification, ::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSystemProgramIdentification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(identification)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSystemProgramIdentification)
    }

    // nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnsureIdTokenCacheAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnsureIdTokenCacheAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnsureIdTokenCacheAsync)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::baas::IFloatingRegistrationRequest>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::baas::IFloatingRegistrationRequest), (::nn::account::baas::IGuestLoginRequest))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterUserWithUid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterUserWithUid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterNetworkServiceAccountAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterNetworkServiceAccountAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterNetworkServiceAccountWithUidAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterNetworkServiceAccountWithUidAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSystemProgramIdentification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(identification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.id != ::nn::ApplicationId::GetInvalidId()), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(identification)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSystemProgramIdentification)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(identification),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnsureIdTokenCacheAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnsureIdTokenCacheAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterUserWithUid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterNetworkServiceAccountAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterNetworkServiceAccountWithUidAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSystemProgramIdentification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnsureIdTokenCacheAsync)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::baas::IFloatingRegistrationRequest))

namespace nn { namespace account { namespace baas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManagerForApplication, (::nn::account::baas::IManagerBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManagerForApplication)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCacheForApplication, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBaseForApplication> pOutBase, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StoreOpenContext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadNetworkServiceLicenseKindAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManagerForApplication)

        ::nn::Result GetNintendoAccountUserResourceCacheForApplication(::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBaseForApplication> pOutBase, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), workBuffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = workBuffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCacheForApplication, (pOutId, pOutBase, workBuffer));
        }

        ::nn::Result CreateAuthorizationRequest(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (pOut, param, ::std::move(transferMemory), size));
        }

        ::nn::Result StoreOpenContext() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StoreOpenContext);
        }

        ::nn::Result LoadNetworkServiceLicenseKindAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadNetworkServiceLicenseKindAsync, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManagerForApplication : public ::nn::account::baas::IManagerBase
    {
    public:
        nn::Result GetNintendoAccountUserResourceCacheForApplication(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBaseForApplication> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT;
        nn::Result StoreOpenContext() NN_NOEXCEPT;
        nn::Result LoadNetworkServiceLicenseKindAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CheckAvailability() NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result EnsureIdTokenCacheAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result LoadIdTokenCache(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    nn::Result GetNintendoAccountUserResourceCacheForApplication(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBaseForApplication> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT;
    nn::Result StoreOpenContext() NN_NOEXCEPT;
    nn::Result LoadNetworkServiceLicenseKindAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::baas::IManagerForApplication), (::nn::account::baas::IManagerBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCacheForApplication, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBaseForApplication> pOutBase, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNintendoAccountUserResourceCacheForApplication, (pOutId, pOutBase, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateAuthorizationRequest, (pOut, param, ::std::move(transferMemory), size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StoreOpenContext)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StoreOpenContext);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadNetworkServiceLicenseKindAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadNetworkServiceLicenseKindAsync, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::baas::IManagerForApplication>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::baas::IManagerForApplication), (::nn::account::baas::IManagerBase))

    // nn::Result GetNintendoAccountUserResourceCacheForApplication(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBaseForApplication> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNintendoAccountUserResourceCacheForApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutBase, 0, (::nn::sf::Out<::nn::account::nas::NasUserBaseForApplication>), 104, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutBase, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutId, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNintendoAccountUserResourceCacheForApplication)

    // nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateAuthorizationRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(150)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(param, 0, (const ::nn::account::NintendoAccountAuthorizationRequestParameters&), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (param))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemory, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemory))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(param), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemory), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateAuthorizationRequest)

    // nn::Result StoreOpenContext() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StoreOpenContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(160)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StoreOpenContext)

    // nn::Result LoadNetworkServiceLicenseKindAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadNetworkServiceLicenseKindAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(170)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadNetworkServiceLicenseKindAsync)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::nas::NasUserBaseForApplication), 104, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountAuthorizationRequestParameters), 512, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::baas::IManagerForApplication, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::baas::IManagerForApplication), (::nn::account::baas::IManagerBase))

    // nn::Result GetNintendoAccountUserResourceCacheForApplication(nn::sf::Out<nn::account::NintendoAccountId> pOutId, nn::sf::Out<nn::account::nas::NasUserBaseForApplication> pOutBase, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoAccountUserResourceCacheForApplication, (::nn::sf::Out<::nn::account::NintendoAccountId> pOutId, ::nn::sf::Out<::nn::account::nas::NasUserBaseForApplication> pOutBase, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNintendoAccountUserResourceCacheForApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNintendoAccountUserResourceCacheForApplication)
    }

    // nn::Result CreateAuthorizationRequest(nn::sf::Out<nn::sf::SharedPointer<nn::account::nas::IAuthorizationRequest>> pOut, const nn::account::NintendoAccountAuthorizationRequestParameters& param, nn::sf::NativeHandle&& transferMemory, std::uint32_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAuthorizationRequest, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>> pOut, const ::nn::account::NintendoAccountAuthorizationRequestParameters& param, ::nn::sf::NativeHandle&& transferMemory, ::std::uint32_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateAuthorizationRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(param)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateAuthorizationRequest)
    }

    // nn::Result StoreOpenContext() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StoreOpenContext)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StoreOpenContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StoreOpenContext)
    }

    // nn::Result LoadNetworkServiceLicenseKindAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadNetworkServiceLicenseKindAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncNetworkServiceLicenseKindContext>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadNetworkServiceLicenseKindAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadNetworkServiceLicenseKindAsync)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::baas::IManagerForApplication>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::baas::IManagerForApplication), (::nn::account::baas::IManagerBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNintendoAccountUserResourceCacheForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBase)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNintendoAccountUserResourceCacheForApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateAuthorizationRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(param)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::nas::IAuthorizationRequest>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateAuthorizationRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(param),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemory),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StoreOpenContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StoreOpenContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadNetworkServiceLicenseKindAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncNetworkServiceLicenseKindContext>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadNetworkServiceLicenseKindAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNintendoAccountUserResourceCacheForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateAuthorizationRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StoreOpenContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadNetworkServiceLicenseKindAsync)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::baas::IManagerForApplication))
