﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasLoginCache.h>
#include <nn/account/baas/account_BaasTypes.h>
#include <nn/account/baas/account_BaasUserInfoHolder.h>
#include <nn/account/detail/account_Execution.h>
#include <nn/account/account_Types.h>

#include <curl/curl.h>

#include <nn/nn_Result.h>
#include <nn/npns/npns_Types.h>

namespace nn {
namespace account {
namespace baas {

class BaasChannelDriver
{
    NN_DISALLOW_COPY(BaasChannelDriver);

private:
    const UserAccessTokenCache& m_UserAccessTokenCache;

public:
    BaasChannelDriver(
        const UserAccessTokenCache& userAccessTokenCache) NN_NOEXCEPT
        : m_UserAccessTokenCache(userAccessTokenCache)
    {
    }

    Result PutChannel(
        const NetworkServiceAccountId& id, const uint64_t loginId,
        const npns::NotificationToken& nt,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result GetChannel(
        npns::NotificationToken* pOutNt,
        const NetworkServiceAccountId& id, const uint64_t loginId,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result DeleteChannel(
        const NetworkServiceAccountId& id, const uint64_t loginId,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;
};

} // ~namespace nn::account::baas
}
}
