﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections;
using System.Windows.Forms;

namespace Nintendo.InitializeSdev
{
    public class ListViewSort : IComparer
    {
        public enum CompareMode
        {
            Compare_String,
            Compare_Integer,
        };

        private CompareMode[] _columnModes;
        private CompareMode _mode;
        private int _column;
        private SortOrder _order;

        public CompareMode[] ColumnModes
        {
            set
            { _columnModes = value; }
        }

        public int Column
        {
            set
            {
                if (_column == value)       // 昇順・降順の切替
                {
                    if (_order == SortOrder.Ascending)
                    {
                        _order = SortOrder.Descending;
                    }
                    else if (_order == SortOrder.Descending)
                    {
                        _order = SortOrder.None;
                    }
                    else if (_order == SortOrder.None)
                    {
                        _order = SortOrder.Ascending;
                    }
                    return;
                }
                _column = value;
                _order = SortOrder.Ascending;
            }
            get
            { return _column; }
        }

        public SortOrder C
        {
            get { return _order; }
        }

        public ListViewSort(int col, SortOrder ord, CompareMode cmod)
        {
            _column = col;
            _order = ord;
            _mode = cmod;
        }

        public ListViewSort()
        {
            _column = 0;
            _order = SortOrder.None;
            _mode = CompareMode.Compare_String;
        }

        // 比較メソッド
        public int Compare(object x, object y)
        {
            int result = 0;

            ListViewItem itemx = (ListViewItem)x;
            ListViewItem itemy = (ListViewItem)y;

            if (_columnModes != null && _columnModes.Length > _column)
            {
                _mode = _columnModes[_column];
            }
            else
            {
                return 0;
            }

            switch (_mode)
            {
                case CompareMode.Compare_String:
                    result = string.Compare(itemx.SubItems[_column].Text, itemy.SubItems[_column].Text);
                    break;
                case CompareMode.Compare_Integer:
                    result = int.Parse(itemx.SubItems[_column].Text) - int.Parse(itemy.SubItems[_column].Text);
                    break;
            }

            if (_order == SortOrder.Descending)
            {
                result = -result;
            }
            else if (_order == SortOrder.None)
            {
                result = (int)itemx.Tag - (int)itemy.Tag;
            }

            return result;
        }
    }
}
