﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeSdev
{
    public class CommandInterfaceWin
    {
        public static int Main(string[] rawArgs)
        {
            Application.ThreadException += new System.Threading.ThreadExceptionEventHandler(Application_ThreadException);
            Application.SetUnhandledExceptionMode(UnhandledExceptionMode.ThrowException);
            AppDomain.CurrentDomain.UnhandledException += new UnhandledExceptionEventHandler(CurrentDomain_UnhandledException);

            try
            {
#if false
                SdevInitializeCommandArgument parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs<SdevInitializeCommandArgument>(rawArgs, out parsed))
                {
                    return 1;
                }
#endif
                LOG.SetLevel(LOG_LEVEL.LOG_INFO2);

                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new InitializeSdevWinLibrary.MainForm());
                return 0;
            }
            catch (System.IO.FileNotFoundException exception)
            {
                PrintFileNotFoundException(exception);
                return 1;
            }
            catch (Exception exception)
            {
                PrintException(exception);
                return 1;
            }
        }

        public static void PrintException(Exception exception)
        {
            string errorMsg = "Caught exception.\n";
            errorMsg += string.Format("  Message   : {0}\n", exception.Message);
            errorMsg += string.Format("  Source    : {0}\n", exception.Source);
            errorMsg += string.Format("  TargetSite: {0}\n", exception.TargetSite.ToString());
            errorMsg += string.Format("  StackTrace: \n{0}", exception.StackTrace);
            Trace.WriteLine(errorMsg);
        }

        public static void PrintFileNotFoundException(System.IO.FileNotFoundException exception)
        {
            string errorMsg = string.Format("Dependent file is not found ({0}).", exception.FileName);
            MessageBox.Show(errorMsg, "error", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        private static void Application_ThreadException(object sender, System.Threading.ThreadExceptionEventArgs args)
        {
            try
            {
                Exception ex = args.Exception;
                PrintException(ex);
            }
            finally
            {
                Environment.Exit(1);
            }
        }

        static void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs args)
        {
            try
            {
                Exception ex = (Exception)args.ExceptionObject;
                PrintException(ex);
            }
            finally
            {
                Environment.Exit(1);
            }
        }
    }
}
