﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.InitializeSdev
{
    public class ProcessingProgress : ProcessingProgressBase
    {
        private static ProcessingProgress _classInstance = new ProcessingProgress();

        public static ProcessingProgress GetInstance()
        {
            return _classInstance;
        }

    }

    public class ProcessingProgressBase
    {
        protected int Percentage = 0;

        protected ProcessingProgressBase()
        {
        }

        public void SetProgress(int percentage)
        {
            Percentage = percentage;
            WriteNdiProgress();
        }

        public int GetProgress()
        {
            return Percentage;
        }

        private void WriteNdiProgress()
        {
            if (this.Percentage >= 100)
            {
                ProgressWriterManager.Writer.Write(100, "Update completed", null);
            }
            else
            {
                ProgressWriterManager.Writer.Write(this.Percentage, "Updating", null);
            }
        }
    }
}
