﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

namespace Nintendo.ControlTarget
{
    public interface IGenericController
    {
        void Do();
    }

    public interface IGenericControllerData
    {
        int Priority { get; }
        string ControlType { get; }
        string HardwareType { get; }
        string ControllerType { get; }
    }

    public class GenericController
    {
        private CompositionContainer Container;

        [ImportMany]
        private IEnumerable<Lazy<IGenericController, IGenericControllerData>> Controllers = null;

        public GenericController()
        {
            var catalog = new AggregateCatalog();
            catalog.Catalogs.Add(new AssemblyCatalog(typeof(GenericController).Assembly));
            catalog.Catalogs.Add(new DirectoryCatalog(System.IO.Path.GetDirectoryName(typeof(GenericController).Assembly.Location)));
            Container = new CompositionContainer(catalog);
            Container.ComposeParts(this);
        }

        public void Do(string controlType)
        {
            var sortedControllers = new List<Lazy<IGenericController, IGenericControllerData>>(Controllers);
            sortedControllers.Sort((a, b) => {
                return a.Metadata.Priority - b.Metadata.Priority;
            });

            var controller = sortedControllers.Find((e) => {
                return e.Metadata.ControlType == controlType;
            });

            if (controller == null)
            {
                throw new Exception(string.Format("Found no controller: controller='{0}'", controlType));
            }

            controller.Value.Do();
        }
    }
}
