﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;

namespace Nintendo.ControlTarget
{
    public class BinaryUtility
    {
        public static void WriteBinary<StructType>(Stream outputStream, StructType value)
        {
            var size = Marshal.SizeOf(typeof(StructType));
            var buffer = new byte[size];
            var handle = GCHandle.Alloc(buffer, GCHandleType.Pinned);

            try
            {
                Marshal.StructureToPtr(value, handle.AddrOfPinnedObject(), false);
            }
            finally
            {
                handle.Free();
            }

            outputStream.Write(buffer, 0, size);
        }
    }
}
