﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class TakeScreenshotCommand : CommonTargetCommand
    {
        [CommandLineOption("full-path", ValueName = "Full path", Description = "Full path to output. If it is not specified, the screenshot will be created in the same manner as Target Manager does.")]
        public string FullPath { get; set; }

        [CommandLineOption("directory", ValueName = "Directory path", Description = "Directory to output. If it is not specified, the screenshot will be located at the default path which is defined by Target Manager.")]
        public string Directory { get; set; }

        [CommandLineOption("file-name", ValueName = "File name", Description = "File name to output. If it is not specified, the file name will be automatically numbered by Target Manager.")]
        public string FileName { get; set; }

        public override void Run()
        {
            if (FullPath != null && (Directory != null || FileName != null))
            {
                Console.WriteLine("full-path option cannot be used along with directory/file-name options.");
                return;
            }
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    Trace.WriteLine($"Taking a screenshot. handle={info.GetTargetHandle()}");
                    target.EnsureConnect();
                    string outputPath = (FullPath == null) ?
                        target.TakeScreenshot(Directory, FileName):
                        target.TakeScreenshot(System.IO.Path.GetDirectoryName(FullPath), System.IO.Path.GetFileName(FullPath));
                    if (outputPath != "")
                    {
                        Console.WriteLine("File was output as {0}.", outputPath);
                    }
                });
        }
    }
}
