﻿using System;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.ControlTarget
{
    public class SetBatteryLevelForSc7Command : CommandCommon
    {
        [CommandLineOption("ip-addr",
           Description = "IP address of SDEV.",
           IsRequired  = true)]
        public string IpAddr { get; set; }

        [CommandLineValue(0,
            ValueName   = "Battery level",
            Description = "Specifies a battery level(enough|no-boost|sleep-required).")]
        public string BatteryLevel { get; set; }

        public override void Run()
        {
            Telnet hbTelnet = new Telnet();
            if (!hbTelnet.Connect(IpAddr))
            {
                throw new Exception("HostBridge connection failed.");
            }
            hbTelnet.Login();

            var vCellAverage = 0xB400;
            var socRep = 0x3200;
            switch (BatteryLevel)
            {
            case "enough":
                // 3.60
                vCellAverage = 0xB400;

                // 電池残量表示 49%（生値 50%）
                socRep = 0x3200;

                break;
            case "no-boost":
                // 3.28 V
                vCellAverage = 0xA400;

                // 電池残量表示 1%（生値 3%）
                socRep = 0x0300;

                break;
            case "sleep-required":
                // 3.2 V弱
                vCellAverage = 0x9fff;

                // 電池残量表示 1%（生値 2%）
                socRep = 0x0200;
                break;
            default:
                throw new Exception("Invalid battery level.");
            }

            string commandForVoltage    = String.Format("ni2c_fg_test -a 0x19 -w 0x{0,0:X4}", vCellAverage);
            string commandForPercentage = String.Format("ni2c_fg_test -a 0x06 -w 0x{0,0:X4}", socRep);

            hbTelnet.WaitCommand(commandForVoltage);
            hbTelnet.WaitCommand(commandForPercentage);
        }
    }
}
