﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Net;
using Nintendo.ControlTarget.ConsoleShell;

namespace Nintendo.ControlTarget
{
    public class BootSafeModeForOldVersionsCommand : CommonTargetCommand
    {
        public void StopTargetManager()
        {
            String processName = "NintendoTargetManager";
            Process[] ps = Process.GetProcessesByName(processName);
            int loopConunt = 0;
            while (ps.Length > 0 && loopConunt++ < 10)
            {
                // 1: try to close process
                Process p = ps[0];
                p.CloseMainWindow();
                p.WaitForExit(10000);
                if (p.HasExited)
                {
                    continue;
                }

                // 2: try to terminate process
                p.Kill();
                p.WaitForExit(10000);
                ps = Process.GetProcessesByName(processName);
            }
        }

        public void StartOldTargetManager(FileInfo exePath)
        {
            if (!exePath.Exists)
            {
                throw new Exception("Executable file was not found.");
            }

            var process = new Process();

            process.StartInfo.FileName = exePath.FullName;
            process.StartInfo.Arguments = "-tasktray";

            process.Start();
        }

        public void BootSafeModeFor14483(FileInfo exePath)
        {
            if (!exePath.Exists)
            {
                throw new Exception("Executable file was not found.");
            }

            var process = new Process();

            process.StartInfo.FileName = exePath.FullName;
            process.StartInfo.Arguments = "boot-safemode --target " + this.Target;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.UseShellExecute = false;

            process.Start();
            process.WaitForExit();
        }

        public static bool UnregisterTargetFor14483(FileInfo exePath, string targetKeyString)
        {
            if (!exePath.Exists)
            {
                throw new Exception("Executable file was not found.");
            }

            var process = new Process();

            process.StartInfo.FileName = exePath.FullName;
            process.StartInfo.Arguments = "unregister --target " + targetKeyString;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.UseShellExecute = false;

            process.Start();
            process.WaitForExit();

            return (process.ExitCode == 0);
        }

        public override void Run()
        {
            StopTargetManager();

            Tmapi.RegisteredTargetInfo targetInfo;

            using (var tmapiAccessor = new TargetManagerAccessor())
            {
                tmapiAccessor.EnsureStart();

                var targetHandle = tmapiAccessor.FindTarget(this.Target);
                targetInfo = tmapiAccessor.FindRegisteredTarget(targetHandle);
            }

            String[] tmaVersion = targetInfo.GetTmaVersion().Split('.');
            var tmaBuildVersion = tmaVersion[tmaVersion.Length - 1];
            if (string.IsNullOrEmpty(tmaBuildVersion))
            {
                throw new Exception("Failed to get tma build version");
            }

            if (tmaBuildVersion == "14483")
            {
                using (var tmapiAccessor = new TargetManagerAccessor())
                {
                    tmapiAccessor.EnsureStart();

                    tmapiAccessor.Unregister(tmapiAccessor.FindTarget(this.Target));
                }
                StopTargetManager();

                var root = PathUtility.FindSigloRoot();
                var binariesDirectory = Path.Combine(root, @"Externals\Oasis\OldVersions\14483");

                StartOldTargetManager(new FileInfo(Path.Combine(binariesDirectory, @"NintendoTargetManager.exe")));

                BootSafeModeFor14483(new FileInfo(Path.Combine(binariesDirectory, @"Console.exe")));

                UnregisterTargetFor14483(new FileInfo(Path.Combine(binariesDirectory, @"Console.exe")), this.Target);

                StopTargetManager();
            }
            else
            {
                using (var tmapiAccessor = new TargetManagerAccessor())
                {
                    tmapiAccessor.EnsureStart();

                    Trace.WriteLine($"Try find target. name={this.Target}");
                    var info = tmapiAccessor.FindTargetInfo(this.Target);

                    Trace.WriteLine($"Try to connect: {info.GetSerialNumber()}");
                    tmapiAccessor.ConnectTarget(info.GetTargetHandle());

                    System.Net.IPEndPoint endPoint;
                    try
                    {
                        endPoint = tmapiAccessor.FindService("iywys@$csForRunnerTools", info.GetTargetHandle());
                    }
                    catch (HtcServiceNotFound)
                    {
                        try
                        {
                            endPoint = tmapiAccessor.FindService("@csForRunnerTools", info.GetTargetHandle());
                        }
                        catch (HtcServiceNotFound)
                        {
                            throw new Exception("Found no shell service.");
                        }
                    }

                    Trace.WriteLine($"Try to connect: {endPoint.ToString()}");
                    var csAccessor = new ConsoleShellAccessor(new ConsoleShellMessenger(endPoint));

                    Trace.WriteLine($"Try to boot the safemode. serial={targetInfo.GetSerialNumber()}");
                    csAccessor.BootSafeMode();
                }
            }

        }
    }
}
