﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using Nintendo.ControlTarget;
using Nintendo.ControlTarget.ConsoleShell;
using System.Threading;
using System.Globalization;
using System.Text.RegularExpressions;
using CommandUtility;

namespace Nintendo.ControlTarget
{
    public class Program
    {
        public static void Main(string[] args)
        {
            Thread.CurrentThread.CurrentUICulture = new CultureInfo("en", true);

            try
            {
                ControlTargetArgument parsed;

                if (false == SdkCommandLineParser.ParseArgs<ControlTargetArgument>(args, out parsed))
                {
                    System.Environment.Exit(1);
                }

                CommandCommon.FindActivatedSubCommand(parsed).Run();
            }
            catch (Exception exception)
            {
                PrintException(exception);
                System.Environment.Exit(1);
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Trace.WriteLine($"StackTrace: {exception.StackTrace}");
        }
    }
}
