﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nn.Adl.Syntax;

namespace Nn.ResultTool.Syntax
{
    internal class ResultRangeValue
    {
        public int Begin { get; set; }
        public int End { get; set; }

        public override string ToString()
        {
            if (End == 0 || Begin == End - 1)
            {
                return string.Format(@"({0})", Begin);
            }
            else
            {
                return string.Format(@"({0}, {1})", Begin, End - 1);
            }
        }
    }

    internal class NamelessModification : ValueModification
    {
        public NamelessModification()
        {
            this.DefineeName = new Identifier { Name = @"Text" };
        }
    }

    internal class SymboledLiteralExpression : LiteralExpression
    {
        public Symbol Symbol { get; set; }
    }
}
