﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace Nn.ResultTool.Parsing.Autogen
{
    enum Token
    {
        token_eof,
        token_BRACE_LEFT,
        token_BRACE_RIGHT,
        token_BRACKET_LEFT,
        token_BRACKET_RIGHT,
        token_COLON,
        token_COMMA,
        token_DOLLAR,
        token_DOUBLE_BRACE_LEFT,
        token_DOUBLE_BRACE_RIGHT,
        token_EQUAL,
        token_FALSE,
        token_GREATER,
        token_GROUP_MARK,
        token_IDENTIFIER,
        token_INTEGER,
        token_LESS,
        token_PAREN_LEFT,
        token_PAREN_RIGHT,
        token_RESULT,
        token_SEMICOLON,
        token_STRING,
        token_TRUE,
    }

    interface IErrorHandlingSemanticAction
    {
        void syntax_error(string expected);
        void stack_overflow();
    }

    interface ISemanticAction
        : IErrorHandlingSemanticAction
        , IAdlCommonSubSemanticAction
        , IResultSubSemanticAction
    {
    }

    interface IAdlCommonSubSemanticAction
    {
        Nn.Adl.Syntax.Definition AddChildren(int pos, Nn.Adl.Syntax.Definition definition, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> children);
        Nn.Adl.Syntax.Modification AddModificationCategory(int pos, Nn.Adl.Syntax.Modification modification, Nn.Adl.Syntax.Identifier category);
        Nn.Adl.Syntax.Definition MakeDefinition(int pos, Nn.Adl.Syntax.Identifier id, Nn.Adl.Syntax.Expression expression);
        Nn.Adl.Syntax.Document MakeDocument(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> list);
        Nn.Adl.Syntax.Document MakeDocumentEmpty(int pos);
        Nn.Adl.Syntax.Statement MakeGroup(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> statements);
        Nn.Adl.Syntax.Statement MakeGroup(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> statements, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification);
        Nn.Adl.Syntax.Statement MakeGroupEmpty(int pos);
        Nn.Adl.Syntax.Statement MakeGroupEmpty(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification);
        Nn.Adl.Syntax.Modification MakeModificationBody(int pos, Nn.Adl.Syntax.Identifier id);
        Nn.Adl.Syntax.Modification MakeModificationBody(int pos, Nn.Adl.Syntax.Identifier id, Nn.Adl.Syntax.Expression expression);
        System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationBodyList(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> list, Nn.Adl.Syntax.Modification one);
        System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationBodyListSingle(int pos, Nn.Adl.Syntax.Modification single);
        System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationList(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> list);
        System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationListEmpty(int pos);
        Nn.Adl.Syntax.Statement MakeScopedModification(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> scopedModification);
        Nn.Adl.Syntax.Statement MakeStatement(int pos, Nn.Adl.Syntax.Definition arg1);
        System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> MakeStatementList(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> list, Nn.Adl.Syntax.Statement one);
        System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> MakeStatementListSingle(int pos, Nn.Adl.Syntax.Statement single);
        Nn.Adl.Syntax.Definition PushBackModification(int pos, Nn.Adl.Syntax.Definition arg1, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification);
        Nn.Adl.Syntax.Definition PushFrontModification(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification, Nn.Adl.Syntax.Definition definition);
    }

    interface IResultSubSemanticAction
    {
        Nn.Adl.Syntax.Modification MakeDirectModificationExpression(int pos, Nn.Adl.Syntax.Literal<System.String> description);
        Nn.Adl.Syntax.Expression MakeExpression(int pos, Nn.Adl.Syntax.Literal<System.Int64> value);
        Nn.Adl.Syntax.Expression MakeFalse(int pos, Nn.Adl.Syntax.Keyword value);
        Nn.Adl.Syntax.Expression MakeResultExpression(int pos, Nn.Adl.Syntax.Literal<System.Int64> begin);
        Nn.Adl.Syntax.Expression MakeResultExpression(int pos, Nn.Adl.Syntax.Literal<System.Int64> begin, Nn.Adl.Syntax.Literal<System.Int64> end);
        Nn.Adl.Syntax.Expression MakeStringLiteral(int pos, Nn.Adl.Syntax.Literal<System.String> value);
        Nn.Adl.Syntax.Expression MakeStringLiteral(int pos, Nn.Adl.Syntax.Symbol symbol, Nn.Adl.Syntax.Literal<System.String> value);
        Nn.Adl.Syntax.Expression MakeTrue(int pos, Nn.Adl.Syntax.Keyword value);
    }

    class SubSemanticActionsAdapter
    {
        public IErrorHandlingSemanticAction ErrorHandlingSemanticAction { get; set; }
        public IAdlCommonSubSemanticAction AdlCommonSubSemanticAction { get; set; }
        public IResultSubSemanticAction ResultSubSemanticAction { get; set; }

        public void syntax_error(string expected) { ErrorHandlingSemanticAction.syntax_error(expected); }
        public void stack_overflow() { ErrorHandlingSemanticAction.stack_overflow(); }
        public Nn.Adl.Syntax.Definition AddChildren(int pos, Nn.Adl.Syntax.Definition definition, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> children) { return AdlCommonSubSemanticAction.AddChildren(pos, definition, children); }
        public Nn.Adl.Syntax.Modification AddModificationCategory(int pos, Nn.Adl.Syntax.Modification modification, Nn.Adl.Syntax.Identifier category) { return AdlCommonSubSemanticAction.AddModificationCategory(pos, modification, category); }
        public Nn.Adl.Syntax.Definition MakeDefinition(int pos, Nn.Adl.Syntax.Identifier id, Nn.Adl.Syntax.Expression expression) { return AdlCommonSubSemanticAction.MakeDefinition(pos, id, expression); }
        public Nn.Adl.Syntax.Document MakeDocument(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> list) { return AdlCommonSubSemanticAction.MakeDocument(pos, list); }
        public Nn.Adl.Syntax.Document MakeDocumentEmpty(int pos) { return AdlCommonSubSemanticAction.MakeDocumentEmpty(pos); }
        public Nn.Adl.Syntax.Statement MakeGroup(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> statements) { return AdlCommonSubSemanticAction.MakeGroup(pos, statements); }
        public Nn.Adl.Syntax.Statement MakeGroup(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> statements, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification) { return AdlCommonSubSemanticAction.MakeGroup(pos, statements, modification); }
        public Nn.Adl.Syntax.Statement MakeGroupEmpty(int pos) { return AdlCommonSubSemanticAction.MakeGroupEmpty(pos); }
        public Nn.Adl.Syntax.Statement MakeGroupEmpty(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification) { return AdlCommonSubSemanticAction.MakeGroupEmpty(pos, modification); }
        public Nn.Adl.Syntax.Modification MakeModificationBody(int pos, Nn.Adl.Syntax.Identifier id) { return AdlCommonSubSemanticAction.MakeModificationBody(pos, id); }
        public Nn.Adl.Syntax.Modification MakeModificationBody(int pos, Nn.Adl.Syntax.Identifier id, Nn.Adl.Syntax.Expression expression) { return AdlCommonSubSemanticAction.MakeModificationBody(pos, id, expression); }
        public System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationBodyList(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> list, Nn.Adl.Syntax.Modification one) { return AdlCommonSubSemanticAction.MakeModificationBodyList(pos, list, one); }
        public System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationBodyListSingle(int pos, Nn.Adl.Syntax.Modification single) { return AdlCommonSubSemanticAction.MakeModificationBodyListSingle(pos, single); }
        public System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationList(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> list) { return AdlCommonSubSemanticAction.MakeModificationList(pos, list); }
        public System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> MakeModificationListEmpty(int pos) { return AdlCommonSubSemanticAction.MakeModificationListEmpty(pos); }
        public Nn.Adl.Syntax.Statement MakeScopedModification(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> scopedModification) { return AdlCommonSubSemanticAction.MakeScopedModification(pos, scopedModification); }
        public Nn.Adl.Syntax.Statement MakeStatement(int pos, Nn.Adl.Syntax.Definition arg1) { return AdlCommonSubSemanticAction.MakeStatement(pos, arg1); }
        public System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> MakeStatementList(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> list, Nn.Adl.Syntax.Statement one) { return AdlCommonSubSemanticAction.MakeStatementList(pos, list, one); }
        public System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> MakeStatementListSingle(int pos, Nn.Adl.Syntax.Statement single) { return AdlCommonSubSemanticAction.MakeStatementListSingle(pos, single); }
        public Nn.Adl.Syntax.Definition PushBackModification(int pos, Nn.Adl.Syntax.Definition arg1, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification) { return AdlCommonSubSemanticAction.PushBackModification(pos, arg1, modification); }
        public Nn.Adl.Syntax.Definition PushFrontModification(int pos, System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> modification, Nn.Adl.Syntax.Definition definition) { return AdlCommonSubSemanticAction.PushFrontModification(pos, modification, definition); }
        public Nn.Adl.Syntax.Modification MakeDirectModificationExpression(int pos, Nn.Adl.Syntax.Literal<System.String> description) { return ResultSubSemanticAction.MakeDirectModificationExpression(pos, description); }
        public Nn.Adl.Syntax.Expression MakeExpression(int pos, Nn.Adl.Syntax.Literal<System.Int64> value) { return ResultSubSemanticAction.MakeExpression(pos, value); }
        public Nn.Adl.Syntax.Expression MakeFalse(int pos, Nn.Adl.Syntax.Keyword value) { return ResultSubSemanticAction.MakeFalse(pos, value); }
        public Nn.Adl.Syntax.Expression MakeResultExpression(int pos, Nn.Adl.Syntax.Literal<System.Int64> begin) { return ResultSubSemanticAction.MakeResultExpression(pos, begin); }
        public Nn.Adl.Syntax.Expression MakeResultExpression(int pos, Nn.Adl.Syntax.Literal<System.Int64> begin, Nn.Adl.Syntax.Literal<System.Int64> end) { return ResultSubSemanticAction.MakeResultExpression(pos, begin, end); }
        public Nn.Adl.Syntax.Expression MakeStringLiteral(int pos, Nn.Adl.Syntax.Literal<System.String> value) { return ResultSubSemanticAction.MakeStringLiteral(pos, value); }
        public Nn.Adl.Syntax.Expression MakeStringLiteral(int pos, Nn.Adl.Syntax.Symbol symbol, Nn.Adl.Syntax.Literal<System.String> value) { return ResultSubSemanticAction.MakeStringLiteral(pos, symbol, value); }
        public Nn.Adl.Syntax.Expression MakeTrue(int pos, Nn.Adl.Syntax.Keyword value) { return ResultSubSemanticAction.MakeTrue(pos, value); }
    }

    class Parser
    {
        public class stack_frame
        {
            public state_type state;
            public gotof_type gotof;
            public object value;

            public int pos;
            public string token;

            public stack_frame(state_type s, gotof_type g, object v, int p, string t)
            {
                state = s; gotof = g; value = v; pos = p; token = t;
            }
        }

        public class Stack
        {
            private List<stack_frame> stack = new List<stack_frame>();
            private List<stack_frame> tmp = new List<stack_frame>();
            private int gap;

            public Stack(){ this.gap = 0; }
            public void reset_tmp()
            {
                this.gap = this.stack.Count;
                this.tmp.Clear();
            }

            public void commit_tmp()
            {
                int size = this.gap + this.tmp.Count;
                if(size > this.stack.Capacity) this.stack.Capacity = size;
                this.stack.RemoveRange(this.gap, this.stack.Count - this.gap);
                this.stack.AddRange(this.tmp);
            }
            public bool push(stack_frame f)
            {
                this.tmp.Add(f);
                return true;
            }

            public void pop(int n)
            {
                if(this.tmp.Count < n)
                {
                n -= this.tmp.Count;
                this.tmp.Clear();
                this.gap -= n;
                }else
                {
                    this.tmp.RemoveRange(this.tmp.Count - n, n);
                }
            }

            public stack_frame top()
            {
                if( this.tmp.Count != 0 )
                {
                    return this.tmp[this.tmp.Count - 1];
                }else
                {
                    return this.stack[this.gap - 1];
                }
            }

            public stack_frame get_arg(int b, int i)
            {
                int n = this.tmp.Count;
                if(b - i <= n)
                {
                    return this.tmp[n - (b - i)];
                }else
                {
                    return this.stack[this.gap - (b - n) + i];
                }
            }

            public void clear()
            {
                this.stack.Clear();
            }

            public int get_stack_level()
            {
                return this.tmp.Count + this.gap;
            }

        } // class Stack

        public delegate bool state_type(Token token, object value, int pos);
        public delegate bool gotof_type(int i, object value, int pos);

        public Parser(ISemanticAction sa)
        {
            this.stack = new Stack();
            this.sa = sa;
            this.reset();
        }


        public void reset()
        {
            this.error = false;
            this.accepted = false;
            this.clear_stack();
            this.reset_tmp_stack();
            if( this.push_stack( this.state_0, this.gotof_0, new object(), -1, null) )
            {
                this.commit_tmp_stack();
            }else
            {
                this.sa.stack_overflow();
                this.error = true;
            }
        }
        public bool post(Token token,object value, int pos)
        {
            System.Diagnostics.Debug.Assert(!this.error);
            this.reset_tmp_stack();
            while(stack_top().state(token, value, pos));
            if( !this.error )
            {
                this.commit_tmp_stack();
            }
            return this.accepted;
        }

        public bool accept(out object v)
        {
            System.Diagnostics.Debug.Assert(this.accepted);
            if(this.error) { v = new object(); return false; }
            v = this.accepted_value;
            return true;
        }

        public event System.Action<object, int, IEnumerable<object>> ReduceEventHandler;

        public bool Error() { return this.error; }

        private ISemanticAction sa;
        public Stack stack;
        private bool accepted;
        private bool error;
        private object accepted_value;

        private bool push_stack(state_type s, gotof_type g, object v, int p, string t)
        {
            bool f = this.stack.push(new stack_frame(s, g, v, p, t));
            System.Diagnostics.Debug.Assert(!this.error);
            if(!f)
            {
                this.error = true;
                this.sa.stack_overflow();
            }
            return f;
        }

        private void pop_stack(int n)
        {
            this.stack.pop(n);
        }

        private stack_frame stack_top()
        {
            return this.stack.top();
        }

        private object get_arg(int b, int i)
        {
            return stack.get_arg(b, i).value;
        }

        private int  get_pos(int b, int i)
        {
            return stack.get_arg(b, i).pos;
        }

        private void clear_stack()
        {
            this.stack.clear();
        }

        private void reset_tmp_stack()
        {
            this.stack.reset_tmp();
        }

        private void commit_tmp_stack()
        {
            this.stack.commit_tmp();
        }

        bool gotof_0(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 0: return push_stack( this.state_1, this.gotof_1, v, p, "adl" );
                case 31: return push_stack( this.state_2, this.gotof_2, v, p, "adl_statement_list" );
                case 30: return push_stack( this.state_7, this.gotof_7, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_0_expected = "eof BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_0(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Document r = this.sa.MakeDocumentEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { });
                    object v = (object)r;
                    pop_stack( 0);
                    return stack_top().gotof(0, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_0_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_1(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_1_expected = "eof";

        bool state_1(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // accept
                // run_semantic_action();
                this.accepted = true;
                this.accepted_value  = get_arg( 1, 0 );
                return false;
            default:
                this.sa.syntax_error(state_1_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_2(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 30: return push_stack( this.state_12, this.gotof_12, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_2_expected = "eof BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_2(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(1, 0);
                    Nn.Adl.Syntax.Document r = this.sa.MakeDocument(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(0, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_2_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_3(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 31: return push_stack( this.state_8, this.gotof_8, v, p, "adl_statement_list" );
                case 30: return push_stack( this.state_7, this.gotof_7, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_3_expected = "BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_3(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_3_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_4(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 31: return push_stack( this.state_9, this.gotof_9, v, p, "adl_statement_list" );
                case 30: return push_stack( this.state_7, this.gotof_7, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 15: return push_stack( this.state_34, this.gotof_34, v, p, "adl_end_group" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_4_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_4(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_4_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_5(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 31: return push_stack( this.state_10, this.gotof_10, v, p, "adl_statement_list" );
                case 30: return push_stack( this.state_7, this.gotof_7, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 15: return push_stack( this.state_36, this.gotof_36, v, p, "adl_end_group" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_5_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_5(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_5_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_6(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 31: return push_stack( this.state_11, this.gotof_11, v, p, "adl_statement_list" );
                case 30: return push_stack( this.state_7, this.gotof_7, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 15: return push_stack( this.state_39, this.gotof_39, v, p, "adl_end_group" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_6_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_6(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_6_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_7(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_7_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_7(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(31, v, pos);
                }
            default:
                this.sa.syntax_error(state_7_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_8(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 30: return push_stack( this.state_12, this.gotof_12, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 14: return push_stack( this.state_23, this.gotof_23, v, p, "adl_end_children" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_8_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_8(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_65, this.gotof_65, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_8_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_9(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 30: return push_stack( this.state_12, this.gotof_12, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 15: return push_stack( this.state_35, this.gotof_35, v, p, "adl_end_group" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_9_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_9(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_9_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_10(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 30: return push_stack( this.state_12, this.gotof_12, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 15: return push_stack( this.state_37, this.gotof_37, v, p, "adl_end_group" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_10_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_10(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_10_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_11(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 30: return push_stack( this.state_12, this.gotof_12, v, p, "adl_statement" );
                case 10: return push_stack( this.state_20, this.gotof_20, v, p, "adl_definition_statement" );
                case 11: return push_stack( this.state_21, this.gotof_21, v, p, "adl_definition_statement1" );
                case 12: return push_stack( this.state_25, this.gotof_25, v, p, "adl_definition_statement2" );
                case 20: return push_stack( this.state_18, this.gotof_18, v, p, "adl_group_statement" );
                case 28: return push_stack( this.state_27, this.gotof_27, v, p, "adl_modification_list" );
                case 15: return push_stack( this.state_40, this.gotof_40, v, p, "adl_end_group" );
                case 19: return push_stack( this.state_33, this.gotof_33, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                case 5: return push_stack( this.state_13, this.gotof_13, v, p, "adl_begin_scoped_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_11_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_11(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_DOUBLE_BRACE_LEFT:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "DOUBLE_BRACE_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_11_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_12(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_12_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_12(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement arg1 = (Nn.Adl.Syntax.Statement)get_arg(2, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement arg1 = (Nn.Adl.Syntax.Statement)get_arg(2, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement arg1 = (Nn.Adl.Syntax.Statement)get_arg(2, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement arg1 = (Nn.Adl.Syntax.Statement)get_arg(2, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement arg1 = (Nn.Adl.Syntax.Statement)get_arg(2, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(31, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement arg1 = (Nn.Adl.Syntax.Statement)get_arg(2, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> r = this.sa.MakeStatementList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(31, v, pos);
                }
            default:
                this.sa.syntax_error(state_12_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_13(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 24: return push_stack( this.state_14, this.gotof_14, v, p, "adl_modification_body_list" );
                case 22: return push_stack( this.state_47, this.gotof_47, v, p, "adl_modification_body" );
                case 23: return push_stack( this.state_50, this.gotof_50, v, p, "adl_modification_body1" );
                case 3: return push_stack( this.state_51, this.gotof_51, v, p, "adl_begin_modification_category" );
                case 27: return push_stack( this.state_54, this.gotof_54, v, p, "adl_modification_id" );
                case 6: return push_stack( this.state_57, this.gotof_57, v, p, "adl_custom_modification" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_13_expected = "IDENTIFIER LESS STRING";

        bool state_13(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_73, this.gotof_73, value, pos, "IDENTIFIER");
                return false;
            case Token.token_LESS:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "LESS");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_85, this.gotof_85, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_13_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_14(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 18: return push_stack( this.state_15, this.gotof_15, v, p, "adl_end_scoped_modify" );
                case 29: return push_stack( this.state_16, this.gotof_16, v, p, "adl_modification_terminator" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_14_expected = "COMMA DOUBLE_BRACE_RIGHT";

        bool state_14(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // shift
                push_stack( this.state_75, this.gotof_75, value, pos, "COMMA");
                return false;
            case Token.token_DOUBLE_BRACE_RIGHT:
                // shift
                push_stack( this.state_72, this.gotof_72, value, pos, "DOUBLE_BRACE_RIGHT");
                return false;
            default:
                this.sa.syntax_error(state_14_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_15(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_15_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_15(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(30, v, pos);
                }
            default:
                this.sa.syntax_error(state_15_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_16(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 22: return push_stack( this.state_48, this.gotof_48, v, p, "adl_modification_body" );
                case 23: return push_stack( this.state_50, this.gotof_50, v, p, "adl_modification_body1" );
                case 3: return push_stack( this.state_51, this.gotof_51, v, p, "adl_begin_modification_category" );
                case 18: return push_stack( this.state_17, this.gotof_17, v, p, "adl_end_scoped_modify" );
                case 27: return push_stack( this.state_54, this.gotof_54, v, p, "adl_modification_id" );
                case 6: return push_stack( this.state_57, this.gotof_57, v, p, "adl_custom_modification" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_16_expected = "DOUBLE_BRACE_RIGHT IDENTIFIER LESS STRING";

        bool state_16(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_DOUBLE_BRACE_RIGHT:
                // shift
                push_stack( this.state_72, this.gotof_72, value, pos, "DOUBLE_BRACE_RIGHT");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_73, this.gotof_73, value, pos, "IDENTIFIER");
                return false;
            case Token.token_LESS:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "LESS");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_85, this.gotof_85, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_16_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_17(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_17_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_17(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeScopedModification(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(30, v, pos);
                }
            default:
                this.sa.syntax_error(state_17_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_18(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 13: return push_stack( this.state_19, this.gotof_19, v, p, "adl_definition_terminator" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_18_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_18(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_18_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_19(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_19_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_19(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Statement arg0 = (Nn.Adl.Syntax.Statement)get_arg(2, 0);
                    Nn.Adl.Syntax.Statement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(30, v, pos);
                }
            default:
                this.sa.syntax_error(state_19_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_20(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_20_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_20(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeStatement(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeStatement(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeStatement(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeStatement(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeStatement(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeStatement(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(30, v, pos);
                }
            default:
                this.sa.syntax_error(state_20_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_21(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 28: return push_stack( this.state_26, this.gotof_26, v, p, "adl_modification_list" );
                case 13: return push_stack( this.state_22, this.gotof_22, v, p, "adl_definition_terminator" );
                case 1: return push_stack( this.state_3, this.gotof_3, v, p, "adl_begin_children" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_21_expected = "BRACE_LEFT BRACKET_LEFT SEMICOLON";

        bool state_21(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_64, this.gotof_64, value, pos, "BRACE_LEFT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_21_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_22(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_22_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_22(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            default:
                this.sa.syntax_error(state_22_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_23(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 13: return push_stack( this.state_24, this.gotof_24, v, p, "adl_definition_terminator" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_23_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_23(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_23_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_24(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_24_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_24(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.AddChildren(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(10, v, pos);
                }
            default:
                this.sa.syntax_error(state_24_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_25(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_25_expected = "BRACE_LEFT BRACKET_LEFT SEMICOLON";

        bool state_25(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(11, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(11, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(1, 0);
                    Nn.Adl.Syntax.Definition r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(11, v, pos);
                }
            default:
                this.sa.syntax_error(state_25_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_26(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_26_expected = "BRACE_LEFT BRACKET_LEFT SEMICOLON";

        bool state_26(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(2, 1);
                    Nn.Adl.Syntax.Definition r = this.sa.PushBackModification(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(11, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(2, 1);
                    Nn.Adl.Syntax.Definition r = this.sa.PushBackModification(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(11, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Definition arg0 = (Nn.Adl.Syntax.Definition)get_arg(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(2, 1);
                    Nn.Adl.Syntax.Definition r = this.sa.PushBackModification(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(11, v, pos);
                }
            default:
                this.sa.syntax_error(state_26_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_27(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 12: return push_stack( this.state_32, this.gotof_32, v, p, "adl_definition_statement2" );
                case 28: return push_stack( this.state_28, this.gotof_28, v, p, "adl_modification_list" );
                case 2: return push_stack( this.state_5, this.gotof_5, v, p, "adl_begin_group" );
                case 19: return push_stack( this.state_38, this.gotof_38, v, p, "adl_group_mark" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_27_expected = "BRACE_LEFT BRACKET_LEFT GROUP_MARK IDENTIFIER";

        bool state_27(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_58, this.gotof_58, value, pos, "BRACE_LEFT");
                return false;
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_GROUP_MARK:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "GROUP_MARK");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_27_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_28(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 12: return push_stack( this.state_32, this.gotof_32, v, p, "adl_definition_statement2" );
                case 28: return push_stack( this.state_28, this.gotof_28, v, p, "adl_modification_list" );
                case 9: return push_stack( this.state_29, this.gotof_29, v, p, "adl_definition_id" );
                case 4: return push_stack( this.state_41, this.gotof_41, v, p, "adl_begin_modify" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_28_expected = "BRACKET_LEFT IDENTIFIER";

        bool state_28(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_28_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_29(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 7: return push_stack( this.state_30, this.gotof_30, v, p, "adl_definition_binder" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_29_expected = "EQUAL";

        bool state_29(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_EQUAL:
                // shift
                push_stack( this.state_62, this.gotof_62, value, pos, "EQUAL");
                return false;
            default:
                this.sa.syntax_error(state_29_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_30(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 8: return push_stack( this.state_31, this.gotof_31, v, p, "adl_definition_expression" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_30_expected = "INTEGER";

        bool state_30(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_INTEGER:
                // shift
                push_stack( this.state_76, this.gotof_76, value, pos, "INTEGER");
                return false;
            default:
                this.sa.syntax_error(state_30_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_31(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_31_expected = "BRACE_LEFT BRACKET_LEFT SEMICOLON";

        bool state_31(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(3, 0);
                    Nn.Adl.Syntax.Expression arg1 = (Nn.Adl.Syntax.Expression)get_arg(3, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.MakeDefinition(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(3, 0);
                    Nn.Adl.Syntax.Expression arg1 = (Nn.Adl.Syntax.Expression)get_arg(3, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.MakeDefinition(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(3, 0);
                    Nn.Adl.Syntax.Expression arg1 = (Nn.Adl.Syntax.Expression)get_arg(3, 2);
                    Nn.Adl.Syntax.Definition r = this.sa.MakeDefinition(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(12, v, pos);
                }
            default:
                this.sa.syntax_error(state_31_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_32(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_32_expected = "BRACE_LEFT BRACKET_LEFT SEMICOLON";

        bool state_32(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition arg1 = (Nn.Adl.Syntax.Definition)get_arg(2, 1);
                    Nn.Adl.Syntax.Definition r = this.sa.PushFrontModification(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition arg1 = (Nn.Adl.Syntax.Definition)get_arg(2, 1);
                    Nn.Adl.Syntax.Definition r = this.sa.PushFrontModification(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(2, 0);
                    Nn.Adl.Syntax.Definition arg1 = (Nn.Adl.Syntax.Definition)get_arg(2, 1);
                    Nn.Adl.Syntax.Definition r = this.sa.PushFrontModification(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(12, v, pos);
                }
            default:
                this.sa.syntax_error(state_32_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_33(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 2: return push_stack( this.state_4, this.gotof_4, v, p, "adl_begin_group" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_33_expected = "BRACE_LEFT";

        bool state_33(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_58, this.gotof_58, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_33_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_34(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_34_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_34(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = pos;
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_34_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_35(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_35_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_35(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_35_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_36(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_36_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_36(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_36_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_37(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_37_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_37(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(4, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_37_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_38(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 2: return push_stack( this.state_6, this.gotof_6, v, p, "adl_begin_group" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_38_expected = "BRACE_LEFT";

        bool state_38(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_58, this.gotof_58, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_38_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_39(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_39_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_39(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroupEmpty(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_39_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_40(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_40_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_40(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Statement>)get_arg(5, 3);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg1 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(5, 0);
                    Nn.Adl.Syntax.Statement r = this.sa.MakeGroup(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(5, 0), get_arg(5, 1), get_arg(5, 2), get_arg(5, 3), get_arg(5, 4), });
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_40_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_41(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 24: return push_stack( this.state_42, this.gotof_42, v, p, "adl_modification_body_list" );
                case 22: return push_stack( this.state_47, this.gotof_47, v, p, "adl_modification_body" );
                case 23: return push_stack( this.state_50, this.gotof_50, v, p, "adl_modification_body1" );
                case 3: return push_stack( this.state_51, this.gotof_51, v, p, "adl_begin_modification_category" );
                case 17: return push_stack( this.state_46, this.gotof_46, v, p, "adl_end_modify" );
                case 27: return push_stack( this.state_54, this.gotof_54, v, p, "adl_modification_id" );
                case 6: return push_stack( this.state_57, this.gotof_57, v, p, "adl_custom_modification" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_41_expected = "BRACKET_RIGHT IDENTIFIER LESS STRING";

        bool state_41(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // shift
                push_stack( this.state_70, this.gotof_70, value, pos, "BRACKET_RIGHT");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_73, this.gotof_73, value, pos, "IDENTIFIER");
                return false;
            case Token.token_LESS:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "LESS");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_85, this.gotof_85, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_41_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_42(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 17: return push_stack( this.state_43, this.gotof_43, v, p, "adl_end_modify" );
                case 29: return push_stack( this.state_44, this.gotof_44, v, p, "adl_modification_terminator" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_42_expected = "BRACKET_RIGHT COMMA";

        bool state_42(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // shift
                push_stack( this.state_70, this.gotof_70, value, pos, "BRACKET_RIGHT");
                return false;
            case Token.token_COMMA:
                // shift
                push_stack( this.state_75, this.gotof_75, value, pos, "COMMA");
                return false;
            default:
                this.sa.syntax_error(state_42_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_43(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_43_expected = "BRACE_LEFT BRACKET_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_43(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(28, v, pos);
                }
            default:
                this.sa.syntax_error(state_43_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_44(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 22: return push_stack( this.state_48, this.gotof_48, v, p, "adl_modification_body" );
                case 23: return push_stack( this.state_50, this.gotof_50, v, p, "adl_modification_body1" );
                case 3: return push_stack( this.state_51, this.gotof_51, v, p, "adl_begin_modification_category" );
                case 17: return push_stack( this.state_45, this.gotof_45, v, p, "adl_end_modify" );
                case 27: return push_stack( this.state_54, this.gotof_54, v, p, "adl_modification_id" );
                case 6: return push_stack( this.state_57, this.gotof_57, v, p, "adl_custom_modification" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_44_expected = "BRACKET_RIGHT IDENTIFIER LESS STRING";

        bool state_44(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // shift
                push_stack( this.state_70, this.gotof_70, value, pos, "BRACKET_RIGHT");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_73, this.gotof_73, value, pos, "IDENTIFIER");
                return false;
            case Token.token_LESS:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "LESS");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_85, this.gotof_85, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_44_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_45(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_45_expected = "BRACE_LEFT BRACKET_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_45(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(4, 1);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationList(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(28, v, pos);
                }
            default:
                this.sa.syntax_error(state_45_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_46(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_46_expected = "BRACE_LEFT BRACKET_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_46(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = pos;
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationListEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = pos;
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationListEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = pos;
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationListEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = pos;
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationListEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(28, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = pos;
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationListEmpty(firstPos);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(28, v, pos);
                }
            default:
                this.sa.syntax_error(state_46_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_47(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_47_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_47(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationBodyListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(24, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationBodyListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(24, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationBodyListSingle(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(24, v, pos);
                }
            default:
                this.sa.syntax_error(state_47_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_48(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_48_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_48(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Modification arg1 = (Nn.Adl.Syntax.Modification)get_arg(3, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationBodyList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(24, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Modification arg1 = (Nn.Adl.Syntax.Modification)get_arg(3, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationBodyList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(24, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> arg0 = (System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification>)get_arg(3, 0);
                    Nn.Adl.Syntax.Modification arg1 = (Nn.Adl.Syntax.Modification)get_arg(3, 2);
                    System.Collections.Generic.IEnumerable<Nn.Adl.Syntax.Modification> r = this.sa.MakeModificationBodyList(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(24, v, pos);
                }
            default:
                this.sa.syntax_error(state_48_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_49(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 22: return push_stack( this.state_53, this.gotof_53, v, p, "adl_modification_body" );
                case 23: return push_stack( this.state_50, this.gotof_50, v, p, "adl_modification_body1" );
                case 3: return push_stack( this.state_51, this.gotof_51, v, p, "adl_begin_modification_category" );
                case 27: return push_stack( this.state_54, this.gotof_54, v, p, "adl_modification_id" );
                case 6: return push_stack( this.state_57, this.gotof_57, v, p, "adl_custom_modification" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_49_expected = "IDENTIFIER LESS STRING";

        bool state_49(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_73, this.gotof_73, value, pos, "IDENTIFIER");
                return false;
            case Token.token_LESS:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "LESS");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_85, this.gotof_85, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_49_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_50(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_50_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_50(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(22, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(22, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(22, v, pos);
                }
            default:
                this.sa.syntax_error(state_50_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_51(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 25: return push_stack( this.state_52, this.gotof_52, v, p, "adl_modification_category_id" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_51_expected = "IDENTIFIER";

        bool state_51(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_68, this.gotof_68, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_51_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_52(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 16: return push_stack( this.state_49, this.gotof_49, v, p, "adl_end_modification_category" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_52_expected = "GREATER";

        bool state_52(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_GREATER:
                // shift
                push_stack( this.state_67, this.gotof_67, value, pos, "GREATER");
                return false;
            default:
                this.sa.syntax_error(state_52_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_53(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_53_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_53(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(4, 3);
                    Nn.Adl.Syntax.Identifier arg1 = (Nn.Adl.Syntax.Identifier)get_arg(4, 1);
                    Nn.Adl.Syntax.Modification r = this.sa.AddModificationCategory(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(22, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(4, 3);
                    Nn.Adl.Syntax.Identifier arg1 = (Nn.Adl.Syntax.Identifier)get_arg(4, 1);
                    Nn.Adl.Syntax.Modification r = this.sa.AddModificationCategory(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(22, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(4, 3);
                    Nn.Adl.Syntax.Identifier arg1 = (Nn.Adl.Syntax.Identifier)get_arg(4, 1);
                    Nn.Adl.Syntax.Modification r = this.sa.AddModificationCategory(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(4, 0), get_arg(4, 1), get_arg(4, 2), get_arg(4, 3), });
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(22, v, pos);
                }
            default:
                this.sa.syntax_error(state_53_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_54(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 21: return push_stack( this.state_55, this.gotof_55, v, p, "adl_modification_binder" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_54_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT EQUAL";

        bool state_54(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeModificationBody(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeModificationBody(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeModificationBody(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_EQUAL:
                // shift
                push_stack( this.state_74, this.gotof_74, value, pos, "EQUAL");
                return false;
            default:
                this.sa.syntax_error(state_54_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_55(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 26: return push_stack( this.state_56, this.gotof_56, v, p, "adl_modification_expression" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_55_expected = "DOLLAR FALSE INTEGER STRING TRUE";

        bool state_55(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_DOLLAR:
                // shift
                push_stack( this.state_80, this.gotof_80, value, pos, "DOLLAR");
                return false;
            case Token.token_FALSE:
                // shift
                push_stack( this.state_84, this.gotof_84, value, pos, "FALSE");
                return false;
            case Token.token_INTEGER:
                // shift
                push_stack( this.state_82, this.gotof_82, value, pos, "INTEGER");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_79, this.gotof_79, value, pos, "STRING");
                return false;
            case Token.token_TRUE:
                // shift
                push_stack( this.state_83, this.gotof_83, value, pos, "TRUE");
                return false;
            default:
                this.sa.syntax_error(state_55_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_56(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_56_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_56(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(3, 0);
                    Nn.Adl.Syntax.Expression arg1 = (Nn.Adl.Syntax.Expression)get_arg(3, 2);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeModificationBody(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(3, 0);
                    Nn.Adl.Syntax.Expression arg1 = (Nn.Adl.Syntax.Expression)get_arg(3, 2);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeModificationBody(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(3, 0);
                    Nn.Adl.Syntax.Expression arg1 = (Nn.Adl.Syntax.Expression)get_arg(3, 2);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeModificationBody(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(23, v, pos);
                }
            default:
                this.sa.syntax_error(state_56_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_57(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_57_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_57(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(23, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Modification arg0 = (Nn.Adl.Syntax.Modification)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(23, v, pos);
                }
            default:
                this.sa.syntax_error(state_57_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_58(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_58_expected = "BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_58(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            default:
                this.sa.syntax_error(state_58_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_59(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_59_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_59(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            default:
                this.sa.syntax_error(state_59_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_60(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_60_expected = "BRACE_LEFT";

        bool state_60(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(19, v, pos);
                }
            default:
                this.sa.syntax_error(state_60_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_61(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_61_expected = "EQUAL";

        bool state_61(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_EQUAL:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Identifier r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(9, v, pos);
                }
            default:
                this.sa.syntax_error(state_61_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_62(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_62_expected = "INTEGER";

        bool state_62(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_INTEGER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(7, v, pos);
                }
            default:
                this.sa.syntax_error(state_62_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_63(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_63_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_63(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            default:
                this.sa.syntax_error(state_63_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_64(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_64_expected = "BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_64(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(1, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(1, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(1, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(1, v, pos);
                }
            default:
                this.sa.syntax_error(state_64_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_65(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_65_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_65(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(14, v, pos);
                }
            default:
                this.sa.syntax_error(state_65_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_66(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_66_expected = "IDENTIFIER";

        bool state_66(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(3, v, pos);
                }
            default:
                this.sa.syntax_error(state_66_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_67(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_67_expected = "IDENTIFIER LESS STRING";

        bool state_67(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_LESS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            default:
                this.sa.syntax_error(state_67_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_68(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_68_expected = "GREATER";

        bool state_68(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_GREATER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Identifier r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(25, v, pos);
                }
            default:
                this.sa.syntax_error(state_68_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_69(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_69_expected = "BRACKET_RIGHT IDENTIFIER LESS STRING";

        bool state_69(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(4, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(4, v, pos);
                }
            case Token.token_LESS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(4, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(4, v, pos);
                }
            default:
                this.sa.syntax_error(state_69_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_70(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_70_expected = "BRACE_LEFT BRACKET_LEFT GROUP_MARK IDENTIFIER SEMICOLON";

        bool state_70(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(17, v, pos);
                }
            default:
                this.sa.syntax_error(state_70_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_71(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_71_expected = "IDENTIFIER LESS STRING";

        bool state_71(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(5, v, pos);
                }
            case Token.token_LESS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(5, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(5, v, pos);
                }
            default:
                this.sa.syntax_error(state_71_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_72(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_72_expected = "eof BRACE_RIGHT BRACKET_LEFT DOUBLE_BRACE_LEFT GROUP_MARK IDENTIFIER";

        bool state_72(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_DOUBLE_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_GROUP_MARK:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            default:
                this.sa.syntax_error(state_72_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_73(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_73_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT EQUAL";

        bool state_73(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Identifier r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(27, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Identifier r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(27, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Identifier r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(27, v, pos);
                }
            case Token.token_EQUAL:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Identifier arg0 = (Nn.Adl.Syntax.Identifier)get_arg(1, 0);
                    Nn.Adl.Syntax.Identifier r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(27, v, pos);
                }
            default:
                this.sa.syntax_error(state_73_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_74(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_74_expected = "DOLLAR FALSE INTEGER STRING TRUE";

        bool state_74(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_DOLLAR:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(21, v, pos);
                }
            case Token.token_FALSE:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(21, v, pos);
                }
            case Token.token_INTEGER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(21, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(21, v, pos);
                }
            case Token.token_TRUE:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(21, v, pos);
                }
            default:
                this.sa.syntax_error(state_74_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_75(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_75_expected = "BRACKET_RIGHT DOUBLE_BRACE_RIGHT IDENTIFIER LESS STRING";

        bool state_75(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(29, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(29, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(29, v, pos);
                }
            case Token.token_LESS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(29, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(1, 0);
                    Nn.Adl.Syntax.SyntaxElement r = arg0;
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(29, v, pos);
                }
            default:
                this.sa.syntax_error(state_75_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_76(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_76_expected = "BRACE_LEFT BRACKET_LEFT COLON SEMICOLON";

        bool state_76(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeResultExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(8, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeResultExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(8, v, pos);
                }
            case Token.token_COLON:
                // shift
                push_stack( this.state_77, this.gotof_77, value, pos, "COLON");
                return false;
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeResultExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(8, v, pos);
                }
            default:
                this.sa.syntax_error(state_76_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_77(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_77_expected = "INTEGER";

        bool state_77(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_INTEGER:
                // shift
                push_stack( this.state_78, this.gotof_78, value, pos, "INTEGER");
                return false;
            default:
                this.sa.syntax_error(state_77_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_78(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_78_expected = "BRACE_LEFT BRACKET_LEFT SEMICOLON";

        bool state_78(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(3, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg1 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(3, 2);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeResultExpression(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(8, v, pos);
                }
            case Token.token_BRACKET_LEFT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(3, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg1 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(3, 2);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeResultExpression(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(8, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(3, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg1 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(3, 2);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeResultExpression(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(3, 0), get_arg(3, 1), get_arg(3, 2), });
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(8, v, pos);
                }
            default:
                this.sa.syntax_error(state_78_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_79(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_79_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_79(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg0 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeStringLiteral(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg0 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeStringLiteral(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg0 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeStringLiteral(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            default:
                this.sa.syntax_error(state_79_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_80(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_80_expected = "STRING";

        bool state_80(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_STRING:
                // shift
                push_stack( this.state_81, this.gotof_81, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_80_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_81(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_81_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_81(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(2, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg1 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(2, 1);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeStringLiteral(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(2, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg1 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(2, 1);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeStringLiteral(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    Nn.Adl.Syntax.Symbol arg0 = (Nn.Adl.Syntax.Symbol)get_arg(2, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg1 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(2, 1);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeStringLiteral(firstPos, arg0, arg1);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(2, 0), get_arg(2, 1), });
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(26, v, pos);
                }
            default:
                this.sa.syntax_error(state_81_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_82(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_82_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_82(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.Int64> arg0 = (Nn.Adl.Syntax.Literal<System.Int64>)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            default:
                this.sa.syntax_error(state_82_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_83(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_83_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_83(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeTrue(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeTrue(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeTrue(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            default:
                this.sa.syntax_error(state_83_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_84(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_84_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_84(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeFalse(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeFalse(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Keyword arg0 = (Nn.Adl.Syntax.Keyword)get_arg(1, 0);
                    Nn.Adl.Syntax.Expression r = this.sa.MakeFalse(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(26, v, pos);
                }
            default:
                this.sa.syntax_error(state_84_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_85(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_85_expected = "BRACKET_RIGHT COMMA DOUBLE_BRACE_RIGHT";

        bool state_85(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg0 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeDirectModificationExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(6, v, pos);
                }
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg0 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeDirectModificationExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(6, v, pos);
                }
            case Token.token_DOUBLE_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Nn.Adl.Syntax.Literal<System.String> arg0 = (Nn.Adl.Syntax.Literal<System.String>)get_arg(1, 0);
                    Nn.Adl.Syntax.Modification r = this.sa.MakeDirectModificationExpression(firstPos, arg0);
                    ReduceEventHandler(r, firstPos, new object[] { get_arg(1, 0), });
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(6, v, pos);
                }
            default:
                this.sa.syntax_error(state_85_expected);
                this.error = true;
                return false;
            }
        }

    } // class Parser

} // namespace Nn.ResultTool.Parsing.Autogen
