﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nn.Adl
{
    public class ImplementationSupendedException : ApplicationException { }

    public class ErrorException : ApplicationException
    {
        public string Info { get; protected set; }

        public ErrorException(string msg)
            : this(msg, null, null)
        {
        }
        public ErrorException(string msg, string info)
            : this(msg, info, null)
        {
        }
        public ErrorException(string msg, string info, Exception e)
            : base(msg, e)
        {
            Info = info;
        }

        public void AddInfo(string info)
        {
            Info = Info + info;
        }
    }
}
